/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.subreport.command.wizard;

import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.subreport.MSubreport;
import com.jaspersoft.studio.model.subreport.command.wizard.NewSubreportPage;
import com.jaspersoft.studio.model.subreport.command.wizard.SubreportParameterPage;
import com.jaspersoft.studio.property.dataset.wizard.WizardConnectionPage;
import com.jaspersoft.studio.property.descriptor.parameter.dialog.GenericJSSParameter;
import com.jaspersoft.studio.utils.ExpressionUtil;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.wizards.JSSWizard;
import com.jaspersoft.studio.wizards.ReportNewWizard;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.eclipse.util.StringUtils;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRSubreportParameter;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignDatasetRun;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import net.sf.jasperreports.repo.RepositoryContext;
import net.sf.jasperreports.repo.RepositoryResourceContext;
import net.sf.jasperreports.repo.RepositoryUtil;
import net.sf.jasperreports.repo.SimpleRepositoryContext;
import net.sf.jasperreports.repo.SimpleRepositoryResourceContext;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;

public class SubreportWizard
extends JSSWizard {
    private NewSubreportPage step0;
    private WizardConnectionPage step2;
    private SubreportParameterPage step3;
    private MSubreport subreport;
    private boolean isLoading = false;
    private JRReport subreportDesign = null;
    private String lastLoadedSubreportLocation = null;

    public SubreportWizard() {
        this.setWindowTitle(Messages.common_subreport);
    }

    @Override
    public void addPages() {
        this.subreport = new MSubreport();
        this.subreport.setValue(this.subreport.createJRElement(this.getConfig().getJasperDesign()));
        this.subreport.setPropertyValue("connectionExpression", "$P{REPORT_CONNECTION}");
        this.step0 = this.getSubreportPage();
        this.step0.setSubreport(this.subreport);
        this.addPage((IWizardPage)this.step0);
        this.subreport.setJasperConfiguration(this.getConfig());
        this.step2 = new WizardConnectionPage();
        this.addPage((IWizardPage)this.step2);
        this.step3 = new SubreportParameterPage();
        this.addPage((IWizardPage)this.step3);
        ExpressionContext ec = ModelUtils.getElementExpressionContext((JRDesignElement)this.subreport.getValue(), this.subreport);
        this.step0.setExpressionContext(ec);
        this.step2.setExpressionContext(ec);
        this.step3.setExpressionContext(ec);
    }

    protected NewSubreportPage getSubreportPage() {
        return new NewSubreportPage();
    }

    @Override
    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.step2) {
            this.runLoading();
        }
        if (page == this.step3) {
            this.step3.setJasperDesign(this.getSubreportJasperDesign(), this.getConfig().getJasperDesign());
        }
        return super.getNextPage(page);
    }

    private void runLoading() {
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    block12: {
                        SubreportWizard.this.getSubreportJasperDesign();
                        SubreportWizard.this.setLoading(true);
                        Object reportFileName = null;
                        JRExpression subreportExp = SubreportWizard.this.getSubreport().getValue().getExpression();
                        JasperReportsConfiguration jrConf = SubreportWizard.this.getConfig();
                        if (subreportExp != null && !Misc.isNullOrEmpty((String)subreportExp.getText())) {
                            reportFileName = ExpressionUtil.cachedExpressionEvaluation(subreportExp, jrConf);
                        }
                        if (reportFileName != null) {
                            String location;
                            if (reportFileName instanceof File) {
                                reportFileName = ((File)reportFileName).toURI().toString();
                            }
                            if (reportFileName instanceof String && !(location = (String)reportFileName).equals(SubreportWizard.this.lastLoadedSubreportLocation)) {
                                SubreportWizard.this.lastLoadedSubreportLocation = new String(location);
                                IFile file = (IFile)jrConf.get("ifile");
                                String parentPath = file.getParent().getLocation().toFile().getAbsolutePath();
                                SimpleRepositoryResourceContext context = SimpleRepositoryResourceContext.of((String)parentPath);
                                SimpleRepositoryContext repoContext = SimpleRepositoryContext.of((JasperReportsContext)jrConf, (RepositoryResourceContext)context);
                                InputStream in = null;
                                try {
                                    try {
                                        in = RepositoryUtil.getInstance((RepositoryContext)repoContext).getInputStreamFromLocation(location);
                                        this.readJR(jrConf, location, in);
                                    }
                                    catch (JRException e) {
                                        e.printStackTrace();
                                        if (location.endsWith(".jasper")) {
                                            location = StringUtils.replaceAllIns((String)location, (String)"jasper$", (String)"jrxml");
                                            try {
                                                in = RepositoryUtil.getInstance((RepositoryContext)repoContext).getInputStreamFromLocation(location);
                                                this.readJR(jrConf, location, in);
                                            }
                                            catch (JRException jRException) {
                                                e.printStackTrace();
                                            }
                                        }
                                        FileUtils.closeStream((Closeable)in);
                                        break block12;
                                    }
                                }
                                catch (Throwable throwable) {
                                    FileUtils.closeStream(in);
                                    throw throwable;
                                }
                                FileUtils.closeStream((Closeable)in);
                            }
                        }
                    }
                    SubreportWizard.this.setLoading(false);
                }

                protected void readJR(JasperReportsConfiguration jrConf, String location, InputStream in) throws JRException {
                    JasperDesign r = null;
                    if (location.endsWith(".jrxml")) {
                        r = JRXmlLoader.load((InputStream)in);
                    } else if (location.endsWith(".jasper")) {
                        r = (JRReport)JRLoader.loadObject((JasperReportsContext)jrConf, (InputStream)in);
                    } else {
                        try {
                            r = JRXmlLoader.load((InputStream)in);
                        }
                        catch (JRException jRException) {
                            r = (JRReport)JRLoader.loadObject((JasperReportsContext)jrConf, (InputStream)in);
                        }
                    }
                    SubreportWizard.this.subreportDesign = r;
                }
            });
        }
        catch (InvocationTargetException e) {
            UIUtils.showError((Throwable)e.getCause());
            this.setLoading(false);
        }
        catch (InterruptedException e) {
            UIUtils.showError((Throwable)e.getCause());
            this.setLoading(false);
        }
    }

    @Override
    public boolean performFinish() {
        for (IWizard w : this.getChildWizards()) {
            if (w instanceof ReportNewWizard) {
                JRSubreportParameter[] parameters = GenericJSSParameter.convertToSubreport(this.step3.getValue());
                ((ReportNewWizard)w).getSettings().put("extra_parameters", parameters);
            }
            w.performFinish();
        }
        return true;
    }

    public MSubreport getSubreport() {
        JRSubreportParameter[] map = GenericJSSParameter.convertToSubreport(this.step3.getValue());
        if (map != null) {
            this.subreport.setPropertyValue("parameters", map);
        }
        JRDesignDatasetRun datasetRun = this.step2.getJRDesignDatasetRun();
        this.subreport.setPropertyValue("parametersMapExpression", datasetRun.getParametersMapExpression());
        this.subreport.setPropertyValue("connectionExpression", datasetRun.getConnectionExpression());
        this.subreport.setPropertyValue("dataSourceExpression", datasetRun.getDataSourceExpression());
        if (this.step0.getSelectedOption() == 1) {
            this.subreport.setPropertyValue("expression", this.step0.getSelectedSubreportExpression());
        } else if (this.step0.getSelectedOption() == 0) {
            IPath path = (IPath)this.getSettings().get("file_path");
            String fname = (String)this.getSettings().get("file_name");
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IResource resource = root.findMember(path);
            IFile file = ((IContainer)resource).getFile((IPath)new Path(fname));
            IFile contextfile = (IFile)this.getConfig().get("ifile");
            String filepath = "";
            filepath = contextfile != null && file.getProject().equals((Object)contextfile.getProject()) ? file.getProjectRelativePath().toPortableString().replaceAll(String.valueOf(file.getProject().getName()) + "/", "") : file.getRawLocationURI().toASCIIString();
            if (filepath.toLowerCase().endsWith(".jrxml")) {
                filepath = String.valueOf(filepath.substring(0, filepath.lastIndexOf("."))) + ".jasper";
            }
            JRDesignExpression exp = new JRDesignExpression();
            exp.setText("\"" + filepath + "\"");
            this.subreport.setPropertyValue("expression", exp);
        }
        return this.subreport;
    }

    @Override
    public void setConfig(JasperReportsConfiguration config, boolean disposeConfig) {
        super.setConfig(config, disposeConfig);
        if (this.subreport != null) {
            this.subreport.setJasperConfiguration(config);
        }
    }

    @Override
    public boolean canFinish() {
        if (this.step0.getSelectedOption() == 0) {
            return this.getContainer().getCurrentPage() == this.step3;
        }
        return super.canFinish();
    }

    private synchronized void setLoading(boolean value) {
        this.isLoading = value;
    }

    private synchronized boolean isLoading() {
        return this.isLoading;
    }

    public JRReport getSubreportJasperDesign() {
        while (this.isLoading()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.subreportDesign;
    }
}

