/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.text;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.DefaultValue;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.property.descriptor.checkbox.CheckBoxPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.combo.FontNamePropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.combo.FontSizeButtonPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.combo.RWComboBoxPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.combo.RWFontSizePropertyDescriptor;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.widgets.ASPropertyWidget;
import com.jaspersoft.studio.property.section.widgets.SPBooleanToggle;
import com.jaspersoft.studio.utils.ModelUtils;
import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRFont;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class MFont
extends APropertyNode {
    public static final long serialVersionUID = 10200L;
    public static final String FONT_INCREMENT = "FONT_INCREMENT";
    private static IPropertyDescriptor[] descriptors;

    public MFont(JRFont value) {
        this.setValue(value);
    }

    @Override
    public ImageDescriptor getImagePath() {
        return null;
    }

    @Override
    public String getDisplayText() {
        return null;
    }

    @Override
    protected void postDescriptors(IPropertyDescriptor[] descriptors) {
        super.postDescriptors(descriptors);
    }

    @Override
    public HashMap<String, Object> getStylesDescriptors() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.getValue() == null) {
            return result;
        }
        JRFont element = this.getValue();
        result.put("fontName", element.getOwnFontName());
        result.put("fontSize", element.getOwnFontsize());
        result.put("pdfEncoding", element.getOwnPdfEncoding());
        result.put("pdfFontName", element.getOwnPdfFontName());
        result.put("isBold", element.isOwnBold());
        result.put("isItalic", element.isOwnItalic());
        result.put("isUnderline", element.isOwnUnderline());
        result.put("isPdfEmbedded", element.isOwnPdfEmbedded());
        result.put("isStrikeThrough", element.isOwnStrikeThrough());
        return result;
    }

    @Override
    public void createPropertyDescriptors(List<IPropertyDescriptor> desc) {
        FontNamePropertyDescriptor fontNameD = new FontNamePropertyDescriptor("fontName", Messages.common_font_name, this.getJasperConfiguration().getFontList(), NullEnum.INHERITED);
        fontNameD.setDescription(Messages.MFont_font_name_description);
        desc.add((IPropertyDescriptor)fontNameD);
        RWFontSizePropertyDescriptor fontSizeD = new RWFontSizePropertyDescriptor("fontSize", Messages.common_font_size, ModelUtils.FONT_SIZES, NullEnum.INHERITED);
        fontSizeD.setDescription(Messages.MFont_font_size_description);
        desc.add((IPropertyDescriptor)fontSizeD);
        FontSizeButtonPropertyDescriptor fontIncrement = new FontSizeButtonPropertyDescriptor(FONT_INCREMENT, this);
        desc.add((IPropertyDescriptor)fontIncrement);
        RWComboBoxPropertyDescriptor pdfFontNameD = new RWComboBoxPropertyDescriptor("pdfFontName", Messages.MFont_pdf_font_name, ModelUtils.getPDFFontNames(), NullEnum.INHERITED);
        pdfFontNameD.setDescription(Messages.MFont_pdf_font_name_description);
        pdfFontNameD.setCategory(Messages.MFont_pdfCategory);
        desc.add((IPropertyDescriptor)pdfFontNameD);
        RWComboBoxPropertyDescriptor pdfEncodingD = new RWComboBoxPropertyDescriptor("pdfEncoding", Messages.MFont_pdf_encoding, ModelUtils.getPDFEncodings(), NullEnum.INHERITED);
        pdfEncodingD.setDescription(Messages.MFont_pdf_encoding_description);
        pdfEncodingD.setCategory(Messages.MFont_pdfCategory);
        desc.add((IPropertyDescriptor)pdfEncodingD);
        CheckBoxPropertyDescriptor boldD = new CheckBoxPropertyDescriptor("isBold", Messages.common_bold, NullEnum.INHERITED){

            @Override
            public ASPropertyWidget<CheckBoxPropertyDescriptor> createWidget(Composite parent, AbstractSection section) {
                return new SPBooleanToggle(parent, section, this, JaspersoftStudioPlugin.getInstance().getImage("icons/resources/edit-bold.png"));
            }
        };
        boldD.setDescription(Messages.MFont_bold_description);
        desc.add((IPropertyDescriptor)boldD);
        CheckBoxPropertyDescriptor italicD = new CheckBoxPropertyDescriptor("isItalic", Messages.common_italic, NullEnum.INHERITED){

            @Override
            public ASPropertyWidget<CheckBoxPropertyDescriptor> createWidget(Composite parent, AbstractSection section) {
                return new SPBooleanToggle(parent, section, this, JaspersoftStudioPlugin.getInstance().getImage("icons/resources/edit-italic.png"));
            }
        };
        italicD.setDescription(Messages.MFont_italic_description);
        desc.add((IPropertyDescriptor)italicD);
        CheckBoxPropertyDescriptor underlineD = new CheckBoxPropertyDescriptor("isUnderline", Messages.common_underline, NullEnum.INHERITED){

            @Override
            public ASPropertyWidget<CheckBoxPropertyDescriptor> createWidget(Composite parent, AbstractSection section) {
                return new SPBooleanToggle(parent, section, this, JaspersoftStudioPlugin.getInstance().getImage("icons/resources/edit-underline.png"));
            }
        };
        underlineD.setDescription(Messages.MFont_underline_description);
        desc.add((IPropertyDescriptor)underlineD);
        CheckBoxPropertyDescriptor strikeTroughD = new CheckBoxPropertyDescriptor("isStrikeThrough", Messages.common_strike_trough, NullEnum.INHERITED){

            @Override
            public ASPropertyWidget<CheckBoxPropertyDescriptor> createWidget(Composite parent, AbstractSection section) {
                return new SPBooleanToggle(parent, section, this, JaspersoftStudioPlugin.getInstance().getImage("icons/resources/edit-strike.png"));
            }
        };
        strikeTroughD.setDescription(Messages.MFont_strike_trough_description);
        desc.add((IPropertyDescriptor)strikeTroughD);
        CheckBoxPropertyDescriptor pdfEmbedD = new CheckBoxPropertyDescriptor("isPdfEmbedded", Messages.MFont_pdf_embedded, NullEnum.INHERITED);
        pdfEmbedD.setDescription(Messages.MFont_pdf_embedded_description);
        pdfEmbedD.setCategory(Messages.MFont_pdfCategory);
        desc.add((IPropertyDescriptor)pdfEmbedD);
        fontNameD.setCategory(Messages.common_font);
        fontSizeD.setCategory(Messages.common_font);
        boldD.setCategory(Messages.common_font);
        italicD.setCategory(Messages.common_font);
        underlineD.setCategory(Messages.common_font);
        strikeTroughD.setCategory(Messages.common_font);
        this.setHelpPrefix(desc, "net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#font");
    }

    @Override
    protected Map<String, DefaultValue> createDefaultsMap() {
        Map<String, DefaultValue> defaultsMap = super.createDefaultsMap();
        defaultsMap.put("fontName", new DefaultValue("SansSerif", true));
        defaultsMap.put("fontSize", new DefaultValue(Float.valueOf(10.0f), true));
        defaultsMap.put("isStrikeThrough", new DefaultValue(null, true));
        defaultsMap.put("isUnderline", new DefaultValue(null, true));
        defaultsMap.put("isItalic", new DefaultValue(null, true));
        defaultsMap.put("isBold", new DefaultValue(null, true));
        return defaultsMap;
    }

    @Override
    public IPropertyDescriptor[] getDescriptors() {
        return descriptors;
    }

    @Override
    public void setDescriptors(IPropertyDescriptor[] descriptors1) {
        descriptors = descriptors1;
    }

    public JRFont getValue() {
        return (JRFont)super.getValue();
    }

    @Override
    public Object getPropertyActualValue(Object id) {
        JRFont jrElement = this.getValue();
        if (id.equals("isBold")) {
            return jrElement.isBold();
        }
        if (id.equals("isUnderline")) {
            return jrElement.isUnderline();
        }
        if (id.equals("isItalic")) {
            return jrElement.isItalic();
        }
        if (id.equals("isStrikeThrough")) {
            return jrElement.isStrikeThrough();
        }
        if (id.equals("isPdfEmbedded")) {
            return jrElement.isPdfEmbedded();
        }
        if (id.equals("fontName")) {
            return jrElement.getFontName();
        }
        if (id.equals("pdfFontName")) {
            return jrElement.getPdfFontName();
        }
        if (id.equals("pdfEncoding")) {
            return ModelUtils.getKey4PDFEncoding(jrElement.getPdfEncoding());
        }
        if (id.equals("fontSize")) {
            return Float.valueOf(jrElement.getFontsize());
        }
        return null;
    }

    public Object getPropertyValue(Object id) {
        JRFont jrElement = this.getValue();
        if (id.equals("isBold")) {
            return jrElement.isOwnBold();
        }
        if (id.equals("isUnderline")) {
            return jrElement.isOwnUnderline();
        }
        if (id.equals("isItalic")) {
            return jrElement.isOwnItalic();
        }
        if (id.equals("isStrikeThrough")) {
            return jrElement.isOwnStrikeThrough();
        }
        if (id.equals("isPdfEmbedded")) {
            return jrElement.isOwnPdfEmbedded();
        }
        if (id.equals("fontName")) {
            return jrElement.getOwnFontName();
        }
        if (id.equals("pdfFontName")) {
            return jrElement.getOwnPdfFontName();
        }
        if (id.equals("pdfEncoding")) {
            return ModelUtils.getKey4PDFEncoding(jrElement.getOwnPdfEncoding());
        }
        if (id.equals("fontSize")) {
            return jrElement.getOwnFontsize();
        }
        return null;
    }

    public void setPropertyValue(Object id, Object value) {
        JRFont jrElement = this.getValue();
        if (id.equals("isBold")) {
            jrElement.setBold((Boolean)value);
        } else if (id.equals("isUnderline")) {
            jrElement.setUnderline((Boolean)value);
        } else if (id.equals("isItalic")) {
            jrElement.setItalic((Boolean)value);
        } else if (id.equals("isStrikeThrough")) {
            jrElement.setStrikeThrough((Boolean)value);
        } else if (id.equals("isPdfEmbedded")) {
            jrElement.setPdfEmbedded((Boolean)value);
        } else if (id.equals("fontName")) {
            if (value instanceof String) {
                if (((String)value).isEmpty()) {
                    value = null;
                }
                jrElement.setFontName((String)value);
            } else if (value == null) {
                jrElement.setFontName((String)value);
            }
        } else if (id.equals("fontSize")) {
            jrElement.setFontSize((Float)value);
        } else if (id.equals("pdfFontName")) {
            jrElement.setPdfFontName((String)value);
        } else if (id.equals("pdfEncoding")) {
            jrElement.setPdfEncoding(ModelUtils.getPDFEncoding2key((String)value));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (name.equals("isBold") || name.equals("isUnderline") || name.equals("isItalic") || name.equals("isStrikeThrough") || name.equals("isPdfEmbedded") || name.equals("fontName") || name.equals("fontSize") || name.equals("pdfFontName") || name.equals("pdfEncoding")) {
            super.propertyChange(evt);
        }
    }
}

