/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.text;

import com.jaspersoft.studio.editor.defaults.DefaultManager;
import com.jaspersoft.studio.help.HelpReferenceBuilder;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.text.MTextElement;
import com.jaspersoft.studio.model.util.IIconDescriptor;
import com.jaspersoft.studio.model.util.NodeIconDescriptor;
import com.jaspersoft.studio.property.descriptor.text.NTextPropertyDescriptor;
import java.util.HashSet;
import java.util.List;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRStaticText;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignStaticText;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class MStaticText
extends MTextElement {
    public static final long serialVersionUID = 10200L;
    private static IIconDescriptor iconDescriptor;
    private static IPropertyDescriptor[] descriptors;

    public static IIconDescriptor getIconDescriptor() {
        if (iconDescriptor == null) {
            iconDescriptor = new NodeIconDescriptor("statictext");
        }
        return iconDescriptor;
    }

    public MStaticText() {
    }

    public MStaticText(ANode parent, JRStaticText jrStaticText, int newIndex) {
        super(parent, newIndex);
        this.setValue(jrStaticText);
    }

    @Override
    public IPropertyDescriptor[] getDescriptors() {
        return descriptors;
    }

    @Override
    public void setDescriptors(IPropertyDescriptor[] descriptors1) {
        descriptors = descriptors1;
    }

    @Override
    public void createPropertyDescriptors(List<IPropertyDescriptor> desc) {
        super.createPropertyDescriptors(desc);
        NTextPropertyDescriptor textD = new NTextPropertyDescriptor("text", Messages.common_text);
        desc.add((IPropertyDescriptor)textD);
        textD.setCategory(Messages.MStaticText_text_description);
        textD.setHelpRefBuilder(new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#text"));
    }

    @Override
    public Object getPropertyValue(Object id) {
        JRDesignStaticText jrElement = (JRDesignStaticText)this.getValue();
        if (id.equals("text")) {
            return jrElement.getText();
        }
        return super.getPropertyValue(id);
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        JRDesignStaticText jrElement = (JRDesignStaticText)this.getValue();
        if (id.equals("text")) {
            jrElement.setText((String)value);
        } else {
            super.setPropertyValue(id, value);
        }
    }

    @Override
    public JRDesignElement createJRElement(JasperDesign jasperDesign, boolean applyDefault) {
        JRDesignStaticText jrDesignStaticText = new JRDesignStaticText((JRDefaultStyleProvider)jasperDesign);
        jrDesignStaticText.setText(Messages.common_static_text);
        if (applyDefault) {
            DefaultManager.INSTANCE.applyDefault(this.getClass(), (JRElement)jrDesignStaticText);
        }
        return jrDesignStaticText;
    }

    @Override
    public String getDisplayText() {
        String p = this.getElementNameProperty();
        if (!Misc.isNullOrEmpty((String)p)) {
            return p;
        }
        JRStaticText st = (JRStaticText)this.getValue();
        if (st != null && !Misc.isNullOrEmpty((String)(p = st.getText()))) {
            return p;
        }
        return Misc.isNullOrEmpty((String)p) ? MStaticText.getIconDescriptor().getTitle() : p;
    }

    @Override
    public ImageDescriptor getImagePath() {
        return MStaticText.getIconDescriptor().getIcon16();
    }

    @Override
    public String getToolTip() {
        if (this.getValue() != null) {
            return String.valueOf(MStaticText.getIconDescriptor().getTitle()) + ": " + ((JRStaticText)this.getValue()).getText();
        }
        return MStaticText.getIconDescriptor().getToolTip();
    }

    @Override
    public HashSet<String> generateGraphicalProperties() {
        HashSet<String> result = super.generateGraphicalProperties();
        result.add("text");
        return result;
    }
}

