/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.textfield.command;

import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.MElementGroup;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.band.MBand;
import com.jaspersoft.studio.model.command.CreateElementCommand;
import com.jaspersoft.studio.model.frame.MFrame;
import com.jaspersoft.studio.model.textfield.MPercentage;
import com.jaspersoft.studio.model.textfield.command.wizard.PercentageWizard;
import java.math.BigDecimal;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.type.CalculationEnum;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.ResetTypeEnum;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;

public class CreatePercentageCommand
extends CreateElementCommand {
    private JRDesignVariable jrVariable;

    public CreatePercentageCommand(MElementGroup destNode, MPercentage srcNode, int index) {
        super(destNode, (MGraphicElement)srcNode, index);
    }

    public CreatePercentageCommand(MFrame destNode, MPercentage srcNode, int index) {
        super(destNode, (MGraphicElement)srcNode, index);
    }

    public CreatePercentageCommand(MBand destNode, MPercentage srcNode, int index) {
        super(destNode, (MGraphicElement)srcNode, index);
    }

    public CreatePercentageCommand(ANode destNode, MPercentage srcNode, Rectangle position, int index) {
        super(destNode, (MGraphicElement)srcNode, position, index);
    }

    @Override
    protected void createObject() {
        if (this.jrElement == null) {
            JRCloneable field = null;
            ResetTypeEnum rtype = ResetTypeEnum.REPORT;
            JRGroup group = null;
            PercentageWizard wizard = new PercentageWizard();
            WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
            wizard.init(this.jasperDesign);
            dialog.create();
            if (dialog.open() == 0) {
                field = wizard.getField();
                rtype = wizard.getResetType();
                group = wizard.getGroup();
                super.createObject();
                if (field != null) {
                    JRDesignTextField tf = (JRDesignTextField)this.jrElement;
                    JRDesignVariable variable = null;
                    try {
                        if (field instanceof JRField) {
                            variable = this.createVariable(((JRField)field).getName(), ((JRField)field).getValueClassName(), rtype, group);
                        } else if (field instanceof JRVariable) {
                            variable = this.createVariable(((JRVariable)field).getName(), ((JRVariable)field).getValueClassName(), rtype, group);
                        }
                        if (variable == null) {
                            return;
                        }
                        this.jasperDesign.addVariable(variable);
                    }
                    catch (Exception e) {
                        UIUtils.showError((Throwable)e);
                    }
                    JRDesignExpression expression = new JRDesignExpression();
                    if (field instanceof JRField) {
                        expression.setText(this.createExpression(((JRField)field).getName(), variable.getName(), ((JRField)field).getValueClass()));
                    }
                    if (field instanceof JRVariable) {
                        expression.setText(this.createExpression(((JRVariable)field).getName(), variable.getName(), ((JRVariable)field).getValueClass()));
                    }
                    tf.setExpression((JRExpression)expression);
                    tf.setPattern("#,##0.00%");
                    tf.setEvaluationTime(EvaluationTimeEnum.AUTO);
                }
            }
        }
    }

    private String createExpression(String name, String vname, Class<?> clazz) {
        if (clazz.isAssignableFrom(Integer.class)) {
            return "new Double($F{" + name + "}.intValue() / $V{" + vname + "}.intValue())";
        }
        if (clazz.isAssignableFrom(Byte.class)) {
            return "new Double($F{" + name + "}.byteValue() / $V{" + vname + "}.byteValue())";
        }
        if (clazz.isAssignableFrom(Short.class)) {
            return "new Double($F{" + name + "}.shortValue() / $V{" + vname + "}.shortValue())";
        }
        if (clazz.isAssignableFrom(Float.class)) {
            return "new Float($F{" + name + "}.floatValue() / $V{" + vname + "}.floatValue())";
        }
        if (clazz.isAssignableFrom(Double.class)) {
            return "new Double($F{" + name + "}.doubleValue() / $V{" + vname + "}.doubleValue())";
        }
        if (clazz.isAssignableFrom(BigDecimal.class)) {
            return "$F{" + name + "} / $V{" + vname + "}";
        }
        return "";
    }

    public static boolean isNumber(Class<?> clazz) {
        if (clazz.isAssignableFrom(Integer.class)) {
            return true;
        }
        if (clazz.isAssignableFrom(Byte.class)) {
            return true;
        }
        if (clazz.isAssignableFrom(Short.class)) {
            return true;
        }
        if (clazz.isAssignableFrom(Float.class)) {
            return true;
        }
        if (clazz.isAssignableFrom(Double.class)) {
            return true;
        }
        return clazz.isAssignableFrom(BigDecimal.class);
    }

    private JRDesignVariable createVariable(String name, String clazz, ResetTypeEnum rtype, JRGroup group) throws Exception {
        this.jrVariable = new JRDesignVariable();
        this.jrVariable.setCalculation(CalculationEnum.SUM);
        String vname = String.valueOf(name) + "_SUM";
        int i = 0;
        while (this.jasperDesign.getVariablesMap().containsKey(vname)) {
            vname = String.valueOf(name) + "_" + ++i + "_SUM";
        }
        this.jrVariable.setName(vname);
        this.jrVariable.setResetType(rtype);
        if (rtype.equals((Object)ResetTypeEnum.GROUP)) {
            this.jrVariable.setResetGroup(group);
        }
        this.jrVariable.setValueClassName(clazz);
        JRDesignExpression jre = new JRDesignExpression();
        jre.setText("$F{" + name + "}");
        this.jrVariable.setExpression((JRExpression)jre);
        return this.jrVariable;
    }
}

