/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.textfield.command.wizard;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.textfield.MPercentage;
import com.jaspersoft.studio.model.textfield.command.CreatePercentageCommand;
import com.jaspersoft.studio.property.dataset.TLabelProvider;
import com.jaspersoft.studio.swt.widgets.table.ListContentProvider;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.ResetTypeEnum;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;

public class PercentagePage
extends WizardPage {
    private static final String GROUP2 = "(Group) ";
    private JRCloneable field;
    private ResetTypeEnum rtype;
    private JRGroup group;
    private JasperDesign jDesign;
    private Combo rtypeList;
    private TableViewer fieldsView;
    private Table fieldsTable;
    private List<String> rtypes;

    public JRCloneable getField() {
        return this.field;
    }

    public ResetTypeEnum getResetType() {
        return this.rtype;
    }

    public JRGroup getGroup() {
        return this.group;
    }

    public void init(JasperDesign jDesign) {
        this.jDesign = jDesign;
    }

    public PercentagePage() {
        super("pecentage");
        this.setTitle(Messages.PercentagePage_percentageWizardTitle);
        this.setDescription(Messages.PercentagePage_percentaceWizardDescription);
        this.setImageDescriptor(MPercentage.getIconDescriptor().getIcon32());
    }

    public void dispose() {
        int sel = this.rtypeList.getSelectionIndex();
        switch (sel) {
            case 0: {
                this.rtype = ResetTypeEnum.REPORT;
                break;
            }
            case 1: {
                this.rtype = ResetTypeEnum.COLUMN;
                break;
            }
            case 2: {
                this.rtype = ResetTypeEnum.PAGE;
                break;
            }
            default: {
                if (sel <= 2) break;
                String groupname = this.rtypes.get(sel).substring(GROUP2.length());
                this.group = (JRGroup)this.jDesign.getGroupsMap().get(groupname);
            }
        }
        StructuredSelection s = (StructuredSelection)this.fieldsView.getSelection();
        if (!s.isEmpty()) {
            this.field = (JRCloneable)s.getFirstElement();
        }
        super.dispose();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout(1, false));
        Label lblResetType = new Label(composite, 0);
        lblResetType.setText(Messages.PercentagePage_resetTypeLabel);
        this.rtypeList = new Combo(composite, 2048);
        this.rtypeList.setLayoutData((Object)new GridData(768));
        Label lblFields = new Label(composite, 0);
        lblFields.setText(Messages.PercentagePage_fieldsLabel);
        this.fieldsTable = new Table(composite, 68100);
        GridData gd = new GridData(1808);
        gd.widthHint = 300;
        this.fieldsTable.setLayoutData((Object)gd);
        this.fieldsTable.setHeaderVisible(true);
        TableColumn[] col = new TableColumn[]{new TableColumn(this.fieldsTable, 0)};
        col[0].setText(Messages.PercentagePage_datasetsLabel);
        col[0].pack();
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, false));
        this.fieldsTable.setLayout((Layout)tlayout);
        this.fieldsView = new TableViewer(this.fieldsTable);
        this.fieldsView.setContentProvider((IContentProvider)new ListContentProvider());
        this.fieldsView.setLabelProvider((IBaseLabelProvider)new TLabelProvider());
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "Jaspersoft.wizard");
        this.fillData();
    }

    private void fillData() {
        ArrayList<JRField> flist = new ArrayList<JRField>();
        for (JRField f : this.jDesign.getFieldsList()) {
            if (!CreatePercentageCommand.isNumber(f.getValueClass())) continue;
            flist.add(f);
        }
        for (JRField f : this.jDesign.getVariablesList()) {
            if (!CreatePercentageCommand.isNumber(f.getValueClass())) continue;
            flist.add(f);
        }
        this.fieldsView.setInput(flist);
        this.fieldsTable.select(0);
        this.rtypes = new ArrayList<String>();
        this.rtypes.add(ResetTypeEnum.REPORT.getName());
        this.rtypes.add(ResetTypeEnum.COLUMN.getName());
        this.rtypes.add(ResetTypeEnum.PAGE.getName());
        for (JRGroup group : this.jDesign.getGroupsList()) {
            this.rtypes.add(GROUP2 + group.getName());
        }
        this.rtypeList.setItems(this.rtypes.toArray(new String[this.rtypes.size()]));
        this.rtypeList.select(0);
    }
}

