/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.variable;

import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.help.HelpReferenceBuilder;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.DefaultValue;
import com.jaspersoft.studio.model.ICopyable;
import com.jaspersoft.studio.model.util.IIconDescriptor;
import com.jaspersoft.studio.model.util.NodeIconDescriptor;
import com.jaspersoft.studio.model.variable.MVariableSystem;
import com.jaspersoft.studio.model.variable.MVariables;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.property.descriptor.classname.NClassTypePropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.combo.RWComboBoxPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.expression.ExprUtil;
import com.jaspersoft.studio.property.descriptor.expression.JRExpressionPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.text.NTextPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.NamedEnumPropertyDescriptor;
import com.jaspersoft.studio.utils.EnumHelper;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.util.StringUtils;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.fill.JRIncrementerFactory;
import net.sf.jasperreports.engine.type.CalculationEnum;
import net.sf.jasperreports.engine.type.IncrementTypeEnum;
import net.sf.jasperreports.engine.type.NamedEnum;
import net.sf.jasperreports.engine.type.ResetTypeEnum;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class MVariable
extends MVariableSystem
implements ICopyable {
    public static final long serialVersionUID = 10200L;
    private static NamedEnumPropertyDescriptor<CalculationEnum> calculationD;
    private static NamedEnumPropertyDescriptor<ResetTypeEnum> resetTypeD;
    private static NamedEnumPropertyDescriptor<IncrementTypeEnum> incrementTypeD;
    private RWComboBoxPropertyDescriptor resetGroupD;
    private RWComboBoxPropertyDescriptor incrementGroupD;
    private static IIconDescriptor iconDescriptor;
    private IPropertyDescriptor[] descriptors;

    public static IIconDescriptor getIconDescriptor() {
        if (iconDescriptor == null) {
            iconDescriptor = new NodeIconDescriptor("variable");
        }
        return iconDescriptor;
    }

    public MVariable() {
        this.setEditable(true);
    }

    @Override
    public Color getForeground() {
        return null;
    }

    public MVariable(ANode parent, JRDesignVariable jrVariable, int newIndex) {
        super(parent, jrVariable, newIndex);
        this.setEditable(true);
    }

    @Override
    public IPropertyDescriptor[] getDescriptors() {
        return this.descriptors;
    }

    @Override
    public void setDescriptors(IPropertyDescriptor[] descriptors1) {
        this.descriptors = descriptors1;
    }

    @Override
    protected void postDescriptors(IPropertyDescriptor[] descriptors) {
        String[] items;
        super.postDescriptors(descriptors);
        if (this.getParent() != null && (items = this.getGroupList()) != null) {
            this.resetGroupD.setItems(items);
            this.incrementGroupD.setItems(items);
        }
    }

    @Override
    public void createPropertyDescriptors(List<IPropertyDescriptor> desc) {
        super.createPropertyDescriptors(desc);
        NTextPropertyDescriptor descriptionD = new NTextPropertyDescriptor("description", Messages.common_description);
        descriptionD.setDescription(Messages.MVariable_description_description);
        desc.add((IPropertyDescriptor)descriptionD);
        descriptionD.setHelpRefBuilder(new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#variableDescription"));
        this.resetGroupD = new RWComboBoxPropertyDescriptor("resetGroup", Messages.common_reset_group, new String[]{""}, NullEnum.NULL);
        this.resetGroupD.setDescription(Messages.MVariable_reset_group_description);
        desc.add((IPropertyDescriptor)this.resetGroupD);
        this.incrementGroupD = new RWComboBoxPropertyDescriptor("incrementGroup", Messages.common_increment_group, new String[]{""}, NullEnum.NULL);
        this.incrementGroupD.setDescription(Messages.MVariable_increment_group_description);
        desc.add((IPropertyDescriptor)this.incrementGroupD);
        calculationD = new NamedEnumPropertyDescriptor<CalculationEnum>("calculation", Messages.MVariable_calculation, CalculationEnum.AVERAGE, NullEnum.NOTNULL);
        calculationD.setDescription(Messages.MVariable_calculation_description);
        desc.add((IPropertyDescriptor)calculationD);
        resetTypeD = new NamedEnumPropertyDescriptor<ResetTypeEnum>("resetType", Messages.common_reset_type, ResetTypeEnum.COLUMN, NullEnum.NOTNULL);
        resetTypeD.setDescription(Messages.MVariable_reset_type_description);
        desc.add((IPropertyDescriptor)resetTypeD);
        incrementTypeD = new NamedEnumPropertyDescriptor<IncrementTypeEnum>("incrementType", Messages.common_increment_type, IncrementTypeEnum.COLUMN, NullEnum.NOTNULL);
        incrementTypeD.setDescription(Messages.MVariable_increment_type_description);
        desc.add((IPropertyDescriptor)incrementTypeD);
        JRExpressionPropertyDescriptor expressionD = new JRExpressionPropertyDescriptor("expression", Messages.common_expression);
        expressionD.setDescription(Messages.MVariable_expression_description);
        desc.add((IPropertyDescriptor)expressionD);
        expressionD.setHelpRefBuilder(new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#variableExpression"));
        JRExpressionPropertyDescriptor iniValExprD = new JRExpressionPropertyDescriptor("initialValueExpression", Messages.MVariable_initial_value_expression);
        iniValExprD.setDescription(Messages.MVariable_initial_value_expression_description);
        desc.add((IPropertyDescriptor)iniValExprD);
        iniValExprD.setHelpRefBuilder(new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#initialValueExpression"));
        NClassTypePropertyDescriptor factoryClassName = new NClassTypePropertyDescriptor("incrementerFactoryClass", Messages.MVariable_incrementer_factory_class_name);
        ArrayList classes = new ArrayList();
        classes.add(JRIncrementerFactory.class);
        factoryClassName.setClasses(classes);
        factoryClassName.setDescription(Messages.MVariable_incrementer_factory_class_name_description);
        desc.add((IPropertyDescriptor)factoryClassName);
        this.setHelpPrefix(desc, "net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#variable");
    }

    @Override
    protected Map<String, DefaultValue> createDefaultsMap() {
        Map<String, DefaultValue> defaultsMap = super.createDefaultsMap();
        defaultsMap.put("resetType", new DefaultValue(ResetTypeEnum.REPORT, false));
        defaultsMap.put("incrementType", new DefaultValue(IncrementTypeEnum.NONE, false));
        int calculationValue = NamedEnumPropertyDescriptor.getIntValue(CalculationEnum.NOTHING, NullEnum.NOTNULL, CalculationEnum.NOTHING);
        defaultsMap.put("calculation", new DefaultValue(calculationValue, false));
        return defaultsMap;
    }

    @Override
    public ExpressionContext getExpressionContext() {
        JRDesignDataset dataSet = this.getDataSet();
        JasperReportsConfiguration conf = this.getJasperConfiguration();
        if (dataSet != null && conf != null) {
            return new ExpressionContext(dataSet, conf);
        }
        return null;
    }

    @Override
    public Object getPropertyValue(Object id) {
        JRDesignVariable jrVariable = this.getValue();
        Object s = super.getPropertyValue(id);
        if (s != null) {
            return s;
        }
        if (id.equals("description")) {
            return jrVariable.getDescription();
        }
        if (id.equals("resetGroup")) {
            if (jrVariable.getResetTypeValue().equals((Object)ResetTypeEnum.GROUP) && this.resetGroupD != null && jrVariable.getResetGroup() != null) {
                return jrVariable.getResetGroup().getName();
            }
            return "";
        }
        if (id.equals("incrementGroup")) {
            if (jrVariable.getIncrementTypeValue().equals((Object)IncrementTypeEnum.GROUP) && this.incrementGroupD != null && jrVariable.getIncrementGroup() != null) {
                return jrVariable.getIncrementGroup().getName();
            }
            return "";
        }
        if (id.equals("calculation")) {
            return calculationD.getIntValue(jrVariable.getCalculationValue());
        }
        if (id.equals("resetType")) {
            return jrVariable.getResetTypeValue();
        }
        if (id.equals("incrementType")) {
            return jrVariable.getIncrementTypeValue();
        }
        if (id.equals("incrementerFactoryClass")) {
            return jrVariable.getIncrementerFactoryClassName();
        }
        if (id.equals("expression")) {
            return ExprUtil.getExpression(jrVariable.getExpression());
        }
        if (id.equals("initialValueExpression")) {
            return ExprUtil.getExpression(jrVariable.getInitialValueExpression());
        }
        return null;
    }

    private String[] getGroupList() {
        JRDesignDataset jrDataset = this.getDataSet();
        JRGroup[] groups = jrDataset.getGroups();
        String[] items = null;
        if (groups != null) {
            items = new String[groups.length + 1];
            items[0] = "";
            int j = 0;
            while (j < groups.length) {
                items[j + 1] = groups[j].getName();
                ++j;
            }
        }
        return items;
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        super.setPropertyValue(id, value);
        JRDesignVariable jrVariable = this.getValue();
        if (id.equals("resetGroup")) {
            if (value != null && !value.equals("")) {
                JRDesignDataset jrDataset = this.getDataSet();
                JRGroup group = (JRGroup)jrDataset.getGroupsMap().get(value);
                jrVariable.setResetGroup(group);
            } else {
                jrVariable.setResetGroup(null);
            }
        } else if (id.equals("description")) {
            if (StringUtils.isNullOrEmpty((String)((String)value))) {
                jrVariable.setDescription(null);
            } else {
                jrVariable.setDescription((String)value);
            }
        } else if (id.equals("expression")) {
            jrVariable.setExpression(ExprUtil.setValues(jrVariable.getExpression(), value));
        } else if (id.equals("initialValueExpression")) {
            jrVariable.setInitialValueExpression(ExprUtil.setValues(jrVariable.getInitialValueExpression(), value));
        } else if (id.equals("incrementGroup")) {
            if (value != null && !value.equals("")) {
                JRDesignDataset jrDataset = this.getDataSet();
                JRGroup group = (JRGroup)jrDataset.getGroupsMap().get(value);
                jrVariable.setIncrementGroup(group);
            } else {
                jrVariable.setIncrementGroup(null);
            }
        } else if (id.equals("calculation")) {
            jrVariable.setCalculation(calculationD.getEnumValue(value));
        } else if (id.equals("resetType")) {
            jrVariable.setResetType((ResetTypeEnum)EnumHelper.getEnumByObjectValue((NamedEnum[])ResetTypeEnum.values(), (Object)value));
            if (!jrVariable.getResetTypeValue().equals((Object)ResetTypeEnum.GROUP)) {
                jrVariable.setResetGroup(null);
            }
        } else if (id.equals("incrementType")) {
            jrVariable.setIncrementType((IncrementTypeEnum)EnumHelper.getEnumByObjectValue((NamedEnum[])((IncrementTypeEnum[])incrementTypeD.getEnumElements()), (Object)value));
            if (!jrVariable.getIncrementTypeValue().equals((Object)IncrementTypeEnum.GROUP)) {
                jrVariable.setIncrementGroup(null);
            }
        } else if (id.equals("incrementerFactoryClass")) {
            if (value == null || ((String)value).isEmpty()) {
                jrVariable.setIncrementerFactoryClassName(null);
            } else {
                jrVariable.setIncrementerFactoryClassName((String)value);
            }
        }
    }

    protected JRDesignDataset getDataSet() {
        return ModelUtils.getDataset(this);
    }

    public static JRDesignVariable createJRVariable(JRDesignDataset jrDataset) {
        JRDesignVariable jrDesignVariable = new JRDesignVariable();
        jrDesignVariable.setSystemDefined(false);
        jrDesignVariable.setName(ModelUtils.getDefaultName(jrDataset.getVariablesMap(), "Variable_"));
        return jrDesignVariable;
    }

    @Override
    public ICopyable.RESULT isCopyable2(Object parent) {
        if (parent instanceof MVariables) {
            return ICopyable.RESULT.COPYABLE;
        }
        return ICopyable.RESULT.CHECK_PARENT;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (ExpressionContext.class.equals((Object)adapter)) {
            return this.getExpressionContext();
        }
        return super.getAdapter(adapter);
    }

    @Override
    public boolean isCuttable(ISelection currentSelection) {
        return true;
    }
}

