/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.variable.command;

import com.jaspersoft.studio.model.variable.MVariable;
import com.jaspersoft.studio.model.variable.MVariables;
import com.jaspersoft.studio.model.variable.command.ReorderVariableCommand;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.SelectionHelper;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import org.eclipse.gef.commands.Command;

public class CreateVariableCommand
extends Command {
    private JRDesignVariable jrVariable;
    private JRDesignDataset jrDataset;
    private int index;
    private JasperReportsConfiguration jrContext;
    private ReorderVariableCommand rc;

    public CreateVariableCommand(MVariables destNode, MVariable srcNode, int index) {
        this.jrDataset = destNode.getValue();
        this.index = index;
        if (srcNode != null && srcNode.getValue() != null) {
            this.jrVariable = srcNode.getValue();
        }
        this.jrContext = destNode.getJasperConfiguration();
    }

    public void execute() {
        if (this.rc != null) {
            this.rc.execute();
            return;
        }
        if (this.jrVariable == null) {
            this.jrVariable = MVariable.createJRVariable(this.jrDataset);
        }
        if (this.jrVariable != null) {
            try {
                if (this.jrDataset.getVariablesList().contains(this.jrVariable)) {
                    this.rc = new ReorderVariableCommand(this.jrVariable, this.jrDataset, this.jrContext, this.index);
                    this.rc.execute();
                    return;
                }
                if (this.jrDataset.getVariablesMap().get(this.jrVariable.getName()) != null) {
                    this.jrVariable.setName(ModelUtils.getDefaultName(this.jrDataset.getVariablesMap(), String.valueOf(this.jrVariable.getName()) + "_"));
                }
                if (this.index < 0 || this.index > this.jrDataset.getVariablesList().size()) {
                    this.jrDataset.addVariable(this.jrVariable);
                } else {
                    this.jrDataset.addVariable(this.index, this.jrVariable);
                }
            }
            catch (JRException e) {
                e.printStackTrace();
            }
            SelectionHelper.setOutlineSelection(this.jrVariable);
        }
    }

    public boolean canUndo() {
        return true;
    }

    public void undo() {
        if (this.rc != null) {
            this.rc.undo();
        } else {
            this.jrDataset.removeVariable((JRVariable)this.jrVariable);
        }
    }
}

