/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.outline.action.compile;

import com.jaspersoft.studio.editor.action.CompileAction;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.templates.JrxmlTemplateBundle;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JasperReportsContext;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class CompileHandler
implements IHandler {
    private void evaluateChild(HashMap<String, JasperReportsConfiguration> foundReports, Object element) {
        IProject project;
        if (element instanceof IFolder) {
            IFolder folder = (IFolder)element;
            try {
                IResource[] iResourceArray = folder.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource resource = iResourceArray[n2];
                    this.evaluateChild(foundReports, resource);
                    ++n2;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        } else if (element instanceof IFile) {
            String key;
            IFile file = (IFile)element;
            String extension = file.getFileExtension();
            if (extension != null && extension.toLowerCase().equals("jrxml") && !foundReports.containsKey(key = file.getRawLocation().toPortableString())) {
                JasperReportsConfiguration jConfig = new JasperReportsConfiguration((JasperReportsContext)DefaultJasperReportsContext.getInstance(), file);
                foundReports.put(key, jConfig);
            }
        } else if (element instanceof IProject && (project = (IProject)element).isOpen()) {
            try {
                IResource[] iResourceArray = project.members();
                int n = iResourceArray.length;
                int n3 = 0;
                while (n3 < n) {
                    IResource resource = iResourceArray[n3];
                    this.evaluateChild(foundReports, resource);
                    ++n3;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    private HashMap<String, JasperReportsConfiguration> getOperationSet(ExecutionEvent event) {
        HashMap<String, JasperReportsConfiguration> result = new HashMap<String, JasperReportsConfiguration>();
        ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        if (selection instanceof IStructuredSelection) {
            for (Object element : (IStructuredSelection)selection) {
                this.evaluateChild(result, element);
            }
        }
        return result;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        final HashMap<String, JasperReportsConfiguration> reportsToCompile = this.getOperationSet(event);
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(UIUtils.getShell());
        IRunnableWithProgress compileProcess = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(Messages.CompileHandler_compilingStart, reportsToCompile.size());
                for (JasperReportsConfiguration jrConfig : reportsToCompile.values()) {
                    IFile mfile = (IFile)jrConfig.get("ifile");
                    monitor.setTaskName(String.valueOf(Messages.CompileHandler_compilingReport) + mfile.getName());
                    try {
                        JrxmlTemplateBundle bundle = new JrxmlTemplateBundle(mfile.getLocationURI().toURL(), true, (JasperReportsContext)jrConfig);
                        jrConfig.setJasperDesign(bundle.getJasperDesign());
                        CompileAction.doRun(jrConfig, monitor, true);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    monitor.worked(1);
                    if (monitor.isCanceled()) break;
                }
                monitor.done();
            }
        };
        try {
            dialog.run(true, true, compileProcess);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }
}

