/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.preferences;

import com.jaspersoft.studio.ConfigurationManager;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.messages.Messages;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.KeyValue;
import net.sf.jasperreports.eclipse.util.Misc;
import org.apache.commons.io.FileUtils;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class GlobalPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String LOG_FILE = "com.jaspersoft.studio.log.file";
    public static final String LOG4j_FILE = "com.jaspersoft.studio.log.log4jfile";
    public static final String LOG_ENABLE = "com.jaspersoft.studio.log.enable";
    public static final String JSS_JETTY_PORT = "com.jaspersoft.studio.jetty.port";
    public static final String JSS_USE_SECURE_STORAGE = "com.jaspersoft.studio.secure.storage";
    public static final String JSS_DISABLE_EXPRESSION_EVALUATION = "com.jaspersoft.studio.secure.disableExpression";
    public static final String JSS_ENABLE_INTERNAL_CONSOLE = "com.jaspersoft.studio.jss.console";
    public static final String JSS_USE_ALWAYS_EXTERNAL_BROWSER = "com.jaspersoft.studio.jss.browser.external";
    public static final String JSS_CLEANUP_MARKERS_ONSTARTUP = "com.jaspersoft.studio.jss.clean.jrprojects.markers";
    public static final String JSS_PROPERTIES_VIEW_MODE = "com.jaspersoft.studio.properties.view.mode";
    public static final String JSS_PROPERTIES_SHOW_SET = "com.jaspersoft.studio.properties.show.set";
    private BooleanFieldEditor enableLoggers;
    private FileFieldEditor logFile;
    private static File fini;
    private static File defaultLogProperties;
    private static File defaultLog4jProperties;
    private Text tLogPreview;
    private static File template;
    private static File log4jTemplate;
    private boolean refresh = false;
    private Composite cmpJavaLog;
    private FileFieldEditor log4jFile;
    private Text tLog4jPreview;
    private Composite cmpLog4j;
    private CTabFolder tabFolder;

    public GlobalPreferencePage() {
        super(1);
        this.setPreferenceStore(JaspersoftStudioPlugin.getInstance().getPreferenceStore());
        GlobalPreferencePage.initVars();
    }

    private static void initVars() {
        if (fini == null) {
            try {
                fini = ConfigurationManager.getApplicationConfigurationFile();
                System.out.println("Fini: " + fini.toString());
                defaultLogProperties = new File(ConfigurationManager.getAppDataFolder("config"), "log.properties");
                defaultLog4jProperties = new File(ConfigurationManager.getAppDataFolder("config"), "log4j-config.properties");
                GlobalPreferencePage.initDefaultLogProperties();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void initDefaultLogProperties() throws IOException {
        File tmp;
        if (!defaultLogProperties.exists()) {
            defaultLogProperties.getParentFile().mkdirs();
            defaultLogProperties.createNewFile();
            tmp = GlobalPreferencePage.getTemplate();
            if (tmp != null) {
                try {
                    FileUtils.copyFile((File)tmp, (File)GlobalPreferencePage.getDefaultLogProperties());
                }
                catch (IOException e) {
                    UIUtils.showError((Throwable)e);
                    return;
                }
            }
        }
        if (!defaultLog4jProperties.exists()) {
            defaultLog4jProperties.getParentFile().mkdirs();
            defaultLog4jProperties.createNewFile();
            tmp = GlobalPreferencePage.getLog4JTemplate();
            if (tmp != null) {
                try {
                    FileUtils.copyFile((File)tmp, (File)GlobalPreferencePage.getDefaultLog4jProperties());
                }
                catch (IOException e) {
                    UIUtils.showError((Throwable)e);
                    return;
                }
            }
        }
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.createNoteComposite(this.getFont(), parent, "", Messages.GlobalPreferencePage_NoteMsg);
        return contents;
    }

    protected void createFieldEditors() {
        Label lbl = new Label(this.getFieldEditorParent(), 0);
        lbl.setText(Messages.GlobalPreferencePage_jettyServerTitle);
        lbl.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        IntegerFieldEditor port = new IntegerFieldEditor(JSS_JETTY_PORT, Messages.GlobalPreferencePage_port, this.getFieldEditorParent());
        port.setValidRange(0, 49151);
        this.addField((FieldEditor)port);
        Label separator = new Label(this.getFieldEditorParent(), 258);
        separator.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        Label browserTitle = new Label(this.getFieldEditorParent(), 0);
        browserTitle.setText(Messages.GlobalPreferencePage_EmbeddedBrowserSection);
        browserTitle.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        BooleanFieldEditor useAlwaysExternalBrowser = new BooleanFieldEditor(JSS_USE_ALWAYS_EXTERNAL_BROWSER, Messages.GlobalPreferencePage_UseExternalBrowserCheckbox, this.getFieldEditorParent());
        this.addField((FieldEditor)useAlwaysExternalBrowser);
        Label separator2 = new Label(this.getFieldEditorParent(), 258);
        separator2.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        Label securityTitle = new Label(this.getFieldEditorParent(), 0);
        securityTitle.setText(Messages.GlobalPreferencePage_title);
        securityTitle.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        BooleanFieldEditor useSecStorage = new BooleanFieldEditor(JSS_USE_SECURE_STORAGE, Messages.GlobalPreferencePage_flagDescription, this.getFieldEditorParent());
        this.addField((FieldEditor)useSecStorage);
        BooleanFieldEditor disableExpressions = new BooleanFieldEditor(JSS_DISABLE_EXPRESSION_EVALUATION, Messages.GlobalPreferencePage_disableExpression, this.getFieldEditorParent());
        disableExpressions.getDescriptionControl(this.getFieldEditorParent()).setToolTipText(Messages.GlobalPreferencePage_disableExpressionTooltip);
        this.addField((FieldEditor)disableExpressions);
        Label startupSep = new Label(this.getFieldEditorParent(), 258);
        startupSep.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        Label startupOptions = new Label(this.getFieldEditorParent(), 0);
        startupOptions.setText(Messages.GlobalPreferencePage_StartupPrefTitle);
        startupOptions.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        BooleanFieldEditor forceMarkersCleanup = new BooleanFieldEditor(JSS_CLEANUP_MARKERS_ONSTARTUP, Messages.GlobalPreferencePage_ForceCleanupErrorMarkersMsg, this.getFieldEditorParent());
        this.addField((FieldEditor)forceMarkersCleanup);
        Label separator3 = new Label(this.getFieldEditorParent(), 258);
        separator3.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        Label debuggingTitle = new Label(this.getFieldEditorParent(), 0);
        debuggingTitle.setText(Messages.GlobalPreferencePage_LoggingPrefs);
        debuggingTitle.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        BooleanFieldEditor enableJSSConsole = new BooleanFieldEditor(JSS_ENABLE_INTERNAL_CONSOLE, Messages.GlobalPreferencePage_JSSConsoleFieldLabel, this.getFieldEditorParent());
        enableJSSConsole.getDescriptionControl(this.getFieldEditorParent()).setToolTipText(Messages.GlobalPreferencePage_JSSConsoleFieldTooltip);
        this.addField((FieldEditor)enableJSSConsole);
        this.enableLoggers = new BooleanFieldEditor(LOG_ENABLE, Messages.GlobalPreferencePage_5, this.getFieldEditorParent()){

            protected void doStore() {
                super.doStore();
                if (this.getBooleanValue()) {
                    File f;
                    String javaLogPath;
                    String fLog4jName;
                    String fname = GlobalPreferencePage.this.logFile.getStringValue();
                    if (Misc.isNullOrEmpty((String)fname)) {
                        fname = GlobalPreferencePage.getDefaultLogProperties().toString();
                        File tmp = GlobalPreferencePage.getTemplate();
                        if (tmp != null) {
                            try {
                                FileUtils.copyFile((File)tmp, (File)new File(fname));
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                return;
                            }
                        }
                    }
                    if (Misc.isNullOrEmpty((String)(fLog4jName = GlobalPreferencePage.this.log4jFile.getStringValue()))) {
                        fLog4jName = GlobalPreferencePage.getDefaultLog4jProperties().toString();
                        File tmp = GlobalPreferencePage.getLog4JTemplate();
                        if (tmp != null) {
                            try {
                                FileUtils.copyFile((File)tmp, (File)new File(fLog4jName));
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                return;
                            }
                        }
                    }
                    KeyValue[] kv = new KeyValue[(javaLogPath = GlobalPreferencePage.this.getJavaLogPath()) != null ? 4 : 3];
                    kv[0] = new KeyValue((Object)"-Djava.util.logging.config.file", (Object)fname);
                    kv[1] = new KeyValue((Object)"-Dlog4j.configuration", (Object)fLog4jName);
                    kv[2] = new KeyValue((Object)"-Dorg.apache.commons.logging.Log", (Object)"org.apache.commons.logging.impl.Jdk14Logger");
                    if (javaLogPath != null) {
                        kv[3] = new KeyValue((Object)"-Dorg.apache.commons.logging.diagnostics.dest", (Object)javaLogPath);
                    }
                    ConfigurationManager.changeVMArgs(kv);
                    try {
                        f = new File(fname);
                        FileUtils.writeStringToFile((File)f, (String)GlobalPreferencePage.this.tLogPreview.getText());
                        LogManager.getLogManager().readConfiguration(FileUtils.openInputStream((File)f));
                    }
                    catch (SecurityException e) {
                        UIUtils.showError((Throwable)e);
                    }
                    catch (IOException e) {
                        UIUtils.showError((Throwable)e);
                    }
                    try {
                        f = new File(fLog4jName);
                        FileUtils.writeStringToFile((File)f, (String)GlobalPreferencePage.this.tLog4jPreview.getText());
                        LogManager.getLogManager().readConfiguration(FileUtils.openInputStream((File)f));
                    }
                    catch (SecurityException e) {
                        UIUtils.showError((Throwable)e);
                    }
                    catch (IOException e) {
                        UIUtils.showError((Throwable)e);
                    }
                } else {
                    LogManager.getLogManager().reset();
                    this.getPreferenceStore().putValue(GlobalPreferencePage.LOG_FILE, this.getPreferenceStore().getDefaultString(GlobalPreferencePage.LOG_FILE));
                    this.getPreferenceStore().putValue(GlobalPreferencePage.LOG4j_FILE, this.getPreferenceStore().getDefaultString(GlobalPreferencePage.LOG4j_FILE));
                    KeyValue[] kv = new KeyValue[]{new KeyValue((Object)"-Djava.util.logging.config.file", null), new KeyValue((Object)"-Dorg.apache.commons.logging.diagnostics.dest", null), new KeyValue((Object)"-Dorg.apache.commons.logging.Log", null), new KeyValue((Object)"-Dlog4j.configuration", null)};
                    ConfigurationManager.changeVMArgs(kv);
                }
                if (!this.getBooleanValue()) {
                    Logger.getAnonymousLogger().info("LOGGER ENDED");
                }
                if (this.getBooleanValue()) {
                    Logger.getAnonymousLogger().info("LOGGER STARTED");
                }
            }
        };
        this.enableLoggers.getDescriptionControl(this.getFieldEditorParent()).setToolTipText(Messages.GlobalPreferencePage_15);
        this.addField((FieldEditor)this.enableLoggers);
        this.tabFolder = new CTabFolder(this.getFieldEditorParent(), 0x800080);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 3;
        gd.widthHint = 600;
        this.tabFolder.setLayoutData((Object)gd);
        this.createJavaLogging(this.tabFolder);
        this.createLog4jLogging(this.tabFolder);
        this.tabFolder.setSelection(0);
        this.showLogFile();
        this.showLog4jFile();
        this.enableLogging(this.getPreferenceStore().getBoolean(LOG_ENABLE));
    }

    private void createJavaLogging(CTabFolder tabFolder) {
        CTabItem bptab = new CTabItem(tabFolder, 0);
        bptab.setText(Messages.GlobalPreferencePage_16);
        this.cmpJavaLog = new Composite((Composite)tabFolder, 0);
        this.cmpJavaLog.setLayout((Layout)new GridLayout(3, false));
        this.logFile = new FileFieldEditor(LOG_FILE, Messages.GlobalPreferencePage_17, this.cmpJavaLog);
        this.addField((FieldEditor)this.logFile);
        this.logFile.getTextControl(this.cmpJavaLog).addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!GlobalPreferencePage.this.refresh) {
                    try {
                        String lfile = GlobalPreferencePage.this.logFile.getTextControl(GlobalPreferencePage.this.cmpJavaLog).getText();
                        File file = new File(lfile);
                        if (file.exists()) {
                            GlobalPreferencePage.this.tLogPreview.setText(FileUtils.readFileToString((File)file));
                        } else if (lfile.equals(GlobalPreferencePage.getDefaultLogProperties().toString())) {
                            File tmp = GlobalPreferencePage.getTemplate();
                            if (tmp != null) {
                                GlobalPreferencePage.this.tLogPreview.setText(FileUtils.readFileToString((File)tmp));
                            }
                        } else {
                            GlobalPreferencePage.this.tLogPreview.setText(Messages.GlobalPreferencePage_20);
                        }
                    }
                    catch (IOException ex) {
                        GlobalPreferencePage.this.tLogPreview.setText(String.valueOf(ex.getLocalizedMessage()) + "\n" + ex.toString());
                        ex.printStackTrace();
                    }
                }
            }
        });
        this.tLogPreview = new Text(this.cmpJavaLog, 2114);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 3;
        this.tLogPreview.setLayoutData((Object)gd);
        bptab.setControl((Control)this.cmpJavaLog);
    }

    private String getJavaLogPath() {
        try {
            Properties props = net.sf.jasperreports.eclipse.util.FileUtils.load((String)this.tLogPreview.getText());
            Object obj = props.get("java.util.logging.FileHandler.pattern");
            if (obj instanceof String) {
                return (String)obj;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void createLog4jLogging(CTabFolder tabFolder) {
        CTabItem bptab = new CTabItem(tabFolder, 0);
        bptab.setText(Messages.GlobalPreferencePage_19);
        this.cmpLog4j = new Composite((Composite)tabFolder, 0);
        this.cmpLog4j.setLayout((Layout)new GridLayout(3, false));
        this.log4jFile = new FileFieldEditor(LOG4j_FILE, Messages.GlobalPreferencePage_0, this.cmpLog4j);
        this.addField((FieldEditor)this.log4jFile);
        this.log4jFile.getTextControl(this.cmpLog4j).addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!GlobalPreferencePage.this.refresh) {
                    try {
                        String lfile = GlobalPreferencePage.this.log4jFile.getTextControl(GlobalPreferencePage.this.cmpLog4j).getText();
                        File file = new File(lfile);
                        if (file.exists()) {
                            GlobalPreferencePage.this.tLog4jPreview.setText(FileUtils.readFileToString((File)file));
                        } else if (lfile.equals(GlobalPreferencePage.getDefaultLog4jProperties().toString())) {
                            File tmp = GlobalPreferencePage.getTemplate();
                            if (tmp != null) {
                                GlobalPreferencePage.this.tLog4jPreview.setText(FileUtils.readFileToString((File)tmp));
                            }
                        } else {
                            GlobalPreferencePage.this.tLog4jPreview.setText(Messages.GlobalPreferencePage_20);
                        }
                    }
                    catch (IOException ex) {
                        GlobalPreferencePage.this.tLog4jPreview.setText(String.valueOf(ex.getLocalizedMessage()) + "\n" + ex.toString());
                        ex.printStackTrace();
                    }
                }
            }
        });
        this.tLog4jPreview = new Text(this.cmpLog4j, 2114);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 3;
        this.tLog4jPreview.setLayoutData((Object)gd);
        bptab.setControl((Control)this.cmpLog4j);
    }

    public void showLogFile() {
        block11: {
            if (this.refresh) {
                return;
            }
            this.refresh = true;
            try {
                if (this.enableLoggers.getBooleanValue()) {
                    String lfile = this.getPreferenceStore().getString(LOG_FILE);
                    if (Misc.isNullOrEmpty((String)lfile)) {
                        lfile = GlobalPreferencePage.getDefaultLogProperties().toString();
                        this.getPreferenceStore().putValue(LOG_FILE, lfile);
                    }
                    this.logFile.load();
                    if (Misc.isNullOrEmpty((String)lfile)) break block11;
                    try {
                        File file = new File(lfile);
                        if (file.exists()) {
                            this.tLogPreview.setText(FileUtils.readFileToString((File)file));
                            break block11;
                        }
                        if (lfile.equals(GlobalPreferencePage.getDefaultLogProperties().toString())) {
                            File tmp = GlobalPreferencePage.getTemplate();
                            if (tmp != null) {
                                this.tLogPreview.setText(FileUtils.readFileToString((File)tmp));
                            }
                            break block11;
                        }
                        this.tLogPreview.setText(Messages.GlobalPreferencePage_20);
                    }
                    catch (IOException e) {
                        this.tLogPreview.setText(String.valueOf(e.getLocalizedMessage()) + "\n" + e.toString());
                        e.printStackTrace();
                    }
                    break block11;
                }
                this.tLogPreview.setText("");
            }
            finally {
                this.refresh = false;
            }
        }
    }

    public void showLog4jFile() {
        block11: {
            if (this.refresh) {
                return;
            }
            this.refresh = true;
            try {
                if (this.enableLoggers.getBooleanValue()) {
                    String lfile = this.getPreferenceStore().getString(LOG4j_FILE);
                    if (Misc.isNullOrEmpty((String)lfile)) {
                        lfile = GlobalPreferencePage.getDefaultLog4jProperties().toString();
                        this.getPreferenceStore().putValue(LOG4j_FILE, lfile);
                    }
                    this.log4jFile.load();
                    if (Misc.isNullOrEmpty((String)lfile)) break block11;
                    try {
                        File file = new File(lfile);
                        if (file.exists()) {
                            this.tLog4jPreview.setText(FileUtils.readFileToString((File)file));
                            break block11;
                        }
                        if (lfile.equals(GlobalPreferencePage.getDefaultLog4jProperties().toString())) {
                            File tmp = GlobalPreferencePage.getTemplate();
                            if (tmp != null) {
                                this.tLog4jPreview.setText(FileUtils.readFileToString((File)tmp));
                            }
                            break block11;
                        }
                        this.tLog4jPreview.setText(Messages.GlobalPreferencePage_20);
                    }
                    catch (IOException e) {
                        this.tLog4jPreview.setText(String.valueOf(e.getLocalizedMessage()) + "\n" + e.toString());
                        e.printStackTrace();
                    }
                    break block11;
                }
                this.tLog4jPreview.setText("");
            }
            finally {
                this.refresh = false;
            }
        }
    }

    private static File getDefaultLogProperties() {
        String homeDir;
        if (defaultLogProperties == null) {
            GlobalPreferencePage.initVars();
        }
        if (defaultLogProperties == null && !(defaultLogProperties = new File(homeDir = System.getProperty("user.home"), "log.properties")).exists()) {
            try {
                GlobalPreferencePage.initDefaultLogProperties();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return defaultLogProperties;
    }

    private static File getDefaultLog4jProperties() {
        String homeDir;
        if (defaultLog4jProperties == null) {
            GlobalPreferencePage.initVars();
        }
        if (defaultLog4jProperties == null && !(defaultLog4jProperties = new File(homeDir = System.getProperty("user.home"), "log4j-config.properties")).exists()) {
            try {
                GlobalPreferencePage.initDefaultLogProperties();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return defaultLog4jProperties;
    }

    private static File getTemplate() {
        if (template == null) {
            try {
                String path = JaspersoftStudioPlugin.getInstance().getFileLocation("/resources/log.properties");
                if (!Misc.isNullOrEmpty((String)path)) {
                    template = FileUtils.toFile((URL)new URL("file://" + path));
                }
            }
            catch (IOException e) {
                UIUtils.showError((Throwable)e);
            }
        }
        return template;
    }

    private static File getLog4JTemplate() {
        if (log4jTemplate == null) {
            try {
                String path = JaspersoftStudioPlugin.getInstance().getFileLocation("/resources/log4j-config.properties");
                if (!Misc.isNullOrEmpty((String)path)) {
                    log4jTemplate = FileUtils.toFile((URL)new URL("file://" + path));
                }
            }
            catch (IOException e) {
                UIUtils.showError((Throwable)e);
            }
        }
        return log4jTemplate;
    }

    public void enableLogging(boolean enable) {
        this.tabFolder.setEnabled(enable);
        this.logFile.setEnabled(enable, this.cmpJavaLog);
        this.log4jFile.setEnabled(enable, this.cmpLog4j);
        this.tLogPreview.setEnabled(enable);
        this.tLog4jPreview.setEnabled(enable);
        if (!enable) {
            IPreferenceStore pstore = this.getPreferenceStore();
            String d = pstore.getDefaultString(LOG_FILE);
            pstore.putValue(LOG_FILE, d);
            this.logFile.setStringValue(d);
            d = pstore.getDefaultString(LOG4j_FILE);
            pstore.putValue(LOG4j_FILE, d);
            this.log4jFile.setStringValue(d);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getProperty().equals("field_editor_value")) {
            if (event.getSource() == this.enableLoggers) {
                this.enableLogging((Boolean)event.getNewValue());
                this.showLogFile();
                this.showLog4jFile();
            } else if (event.getSource() == this.logFile || event.getSource() == this.log4jFile) {
                // empty if block
            }
        }
    }

    public static void getDefaults(IPreferenceStore store) {
        GlobalPreferencePage.initVars();
        store.setDefault(JSS_JETTY_PORT, 0);
        store.setDefault(JSS_USE_SECURE_STORAGE, false);
        store.setDefault(JSS_DISABLE_EXPRESSION_EVALUATION, false);
        store.setDefault(JSS_ENABLE_INTERNAL_CONSOLE, false);
        store.setDefault(JSS_USE_ALWAYS_EXTERNAL_BROWSER, false);
        store.setDefault(LOG_ENABLE, false);
        store.setDefault(JSS_CLEANUP_MARKERS_ONSTARTUP, false);
    }

    public void init(IWorkbench workbench) {
    }
}

