/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.preferences.editor.number;

import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class JSSIntegerFieldEditor
extends IntegerFieldEditor {
    private int minValidValue = 0;
    private int maxValidValue = Integer.MAX_VALUE;

    public JSSIntegerFieldEditor() {
    }

    public JSSIntegerFieldEditor(String name, String labelText, Composite parent, int textLimit) {
        super(name, labelText, parent, textLimit);
    }

    public JSSIntegerFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
    }

    public void setValidRange(int min, int max) {
        this.minValidValue = min;
        this.maxValidValue = max;
        super.setValidRange(min, max);
    }

    protected boolean checkState() {
        block5: {
            Text text = this.getTextControl();
            if (text == null) {
                return false;
            }
            String numberString = text.getText();
            if (numberString.isEmpty() && this.isEmptyStringAllowed()) {
                return false;
            }
            try {
                int number = Integer.valueOf(numberString);
                if (number < this.minValidValue || number > this.maxValidValue) break block5;
                this.clearErrorMessage();
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                this.showErrorMessage();
                return false;
            }
        }
        this.showErrorMessage();
        return false;
    }
}

