/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.preferences.editor.number;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Spinner;

public class SpinnerFieldEditor
extends FieldEditor {
    private Spinner spinnerCtrl;
    private int digits = 0;
    private int oldValue;

    public SpinnerFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
    }

    public SpinnerFieldEditor(String name, String labelText, Composite parent, int digits) {
        super(name, labelText, parent);
        this.digits = digits;
    }

    protected void valueChanged() {
        this.setPresentsDefaultValue(false);
        int newValue = this.spinnerCtrl.getSelection();
        if (newValue != this.oldValue) {
            this.fireValueChanged("field_editor_value", new Integer(this.oldValue), new Integer(newValue));
            this.oldValue = newValue;
        }
    }

    protected void adjustForNumColumns(int numColumns) {
        GridData gd = (GridData)this.spinnerCtrl.getLayoutData();
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = gd.horizontalSpan == 1;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getLabelControl(parent);
        this.spinnerCtrl = new Spinner(parent, 2048);
        this.spinnerCtrl.setDigits(this.digits);
        this.spinnerCtrl.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                SpinnerFieldEditor.this.valueChanged();
            }

            public void widgetSelected(SelectionEvent e) {
                SpinnerFieldEditor.this.valueChanged();
            }
        });
        this.spinnerCtrl.setDigits(this.digits);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns - 1;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.spinnerCtrl.setLayoutData((Object)gd);
    }

    protected void doLoad() {
        if (this.spinnerCtrl != null) {
            int value = this.getPreferenceStore().getInt(this.getPreferenceName());
            this.spinnerCtrl.setSelection(value);
            this.oldValue = value;
        }
    }

    protected void doLoadDefault() {
        if (this.spinnerCtrl != null) {
            int defaultValue = this.getPreferenceStore().getDefaultInt(this.getPreferenceName());
            this.spinnerCtrl.setSelection(defaultValue);
        }
        this.valueChanged();
    }

    protected void doStore() {
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.spinnerCtrl.getSelection());
    }

    public int getNumberOfControls() {
        if (this.getLabelControl() == null) {
            return 1;
        }
        return 2;
    }

    public void setIncrement(int increment) {
        this.spinnerCtrl.setIncrement(increment);
    }

    public int getIncrement() {
        return this.spinnerCtrl.getIncrement();
    }

    public void setPageIncrement(int increment) {
        this.spinnerCtrl.setPageIncrement(increment);
    }

    public int getPageIncrement() {
        return this.spinnerCtrl.getPageIncrement();
    }

    public void setMaximum(int maximum) {
        this.spinnerCtrl.setMaximum(maximum);
    }

    public int getMaximum() {
        return this.spinnerCtrl.getMaximum();
    }

    public void setMinimum(int minimum) {
        this.spinnerCtrl.setMinimum(minimum);
    }

    public int getMinimum() {
        return this.spinnerCtrl.getMinimum();
    }

    public int getIntValue() {
        return this.spinnerCtrl.getSelection();
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.spinnerCtrl.setEnabled(enabled);
    }

    public Spinner getSpinnerControl() {
        return this.spinnerCtrl;
    }
}

