/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.preferences.editor.properties;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.action.exporter.BaseResource;
import com.jaspersoft.studio.editor.action.exporter.IExportedResourceHandler;
import com.jaspersoft.studio.editor.action.exporter.IPropertyCustomExporter;
import com.jaspersoft.studio.editor.action.exporter.IResourceDefinition;
import com.jaspersoft.studio.plugin.ExtensionManager;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import net.sf.jasperreports.eclipse.MScopedPreferenceStore;
import net.sf.jasperreports.eclipse.util.FileUtils;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.IPreferenceStore;

public class ExportedStudioPropertiesHandler
implements IExportedResourceHandler {
    private static final String CONTAINER_NAME = "jssProperties";
    private static final String FILE_NAME = "backup.properties";
    private static HashSet<String> propertiesBlackList = null;

    private static HashSet<String> getPropertiesBlacklist() {
        HashSet<String> result = new HashSet<String>();
        result.add("com.jaspersoft.studio.log.enable");
        result.add("com.jaspersoft.studio.log.log4jfile");
        result.add("com.jaspersoft.studio.log.file");
        return result;
    }

    protected HashSet<String> getExcludedProeprties() {
        if (propertiesBlackList == null) {
            propertiesBlackList = ExportedStudioPropertiesHandler.getPropertiesBlacklist();
            for (IExportedResourceHandler definition : ExtensionManager.getContributedExporters()) {
                if (!(definition instanceof IPropertyCustomExporter)) continue;
                IPropertyCustomExporter customExporter = (IPropertyCustomExporter)((Object)definition);
                propertiesBlackList.addAll(customExporter.getHandledProperties());
            }
        }
        return propertiesBlackList;
    }

    @Override
    public String getResourceNameExport() {
        try {
            MScopedPreferenceStore store = (MScopedPreferenceStore)JaspersoftStudioPlugin.getInstance().getPreferenceStore();
            HashSet<String> resources = new HashSet<String>();
            IEclipsePreferences pref = store.getQualifierStore();
            resources.addAll(Arrays.asList(pref.keys()));
            int size = resources.size();
            for (String blacklistedProperty : this.getExcludedProeprties()) {
                if (!resources.contains(blacklistedProperty)) continue;
                --size;
            }
            return "Jaspersoft Studio Properties (" + size + ")";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "Jaspersoft Studio Properties";
        }
    }

    @Override
    public String getResourceNameImport(File exportedContainer) {
        String result;
        block5: {
            File destDir = new File(exportedContainer, CONTAINER_NAME);
            File f = new File(destDir, FILE_NAME);
            FileInputStream is = null;
            result = "Jaspersoft Studio Properties";
            try {
                try {
                    is = new FileInputStream(f);
                    Properties loadedProperties = new Properties();
                    loadedProperties.load(is);
                    result = "Jaspersoft Studio Properties (" + loadedProperties.size() + ")";
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    FileUtils.closeStream((Closeable)is);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                FileUtils.closeStream(is);
                throw throwable;
            }
            FileUtils.closeStream((Closeable)is);
        }
        return result;
    }

    @Override
    public List<IResourceDefinition> getRestorableResources(File exportedContainer) {
        ArrayList<IResourceDefinition> result = new ArrayList<IResourceDefinition>();
        File destDir = new File(exportedContainer, CONTAINER_NAME);
        if (destDir.exists() && destDir.list().length > 0) {
            result.add(new BaseResource("All Jaspersoft Studio Preferences"));
        }
        return result;
    }

    @Override
    public List<IResourceDefinition> getExportableResources() {
        ArrayList<IResourceDefinition> result = new ArrayList<IResourceDefinition>();
        try {
            IPreferenceStore store = JaspersoftStudioPlugin.getInstance().getPreferenceStore();
            Properties props = FileUtils.load((String)store.getString("net.sf.jasperreports.JRPROPERTIES"));
            if (props.size() > 0) {
                result.add(new BaseResource("All Jaspersoft Studio Preferences"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    @Override
    public File exportContentFolder(List<IResourceDefinition> resourcesToExport) {
        FileOutputStream out = null;
        File destDir = null;
        if (!resourcesToExport.isEmpty()) {
            block8: {
                try {
                    try {
                        MScopedPreferenceStore store = (MScopedPreferenceStore)JaspersoftStudioPlugin.getInstance().getPreferenceStore();
                        HashSet<String> resources = new HashSet<String>();
                        IEclipsePreferences pref = store.getQualifierStore();
                        resources.addAll(Arrays.asList(pref.keys()));
                        Properties props = new Properties();
                        for (String resource : resources) {
                            if (this.getExcludedProeprties().contains(resource)) continue;
                            props.put(resource, store.getString(resource));
                        }
                        File tempDir = new File(System.getProperty("java.io.tmpdir"));
                        tempDir.deleteOnExit();
                        destDir = new File(tempDir, CONTAINER_NAME);
                        if (destDir.exists()) {
                            FileUtils.recursiveDelete((File)destDir);
                        }
                        destDir.mkdirs();
                        out = new FileOutputStream(new File(destDir, FILE_NAME));
                        props.store(out, "Jaspersoft Studio Properties Backup");
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        destDir = null;
                        FileUtils.closeStream(out);
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    FileUtils.closeStream(out);
                    throw throwable;
                }
                FileUtils.closeStream((Closeable)out);
            }
            return destDir;
        }
        return null;
    }

    @Override
    public void restoreContentFolder(File exportedContainer, List<IResourceDefinition> resourcesToImport) {
        block12: {
            FileInputStream is = null;
            if (!resourcesToImport.isEmpty()) {
                try {
                    try {
                        File destDir = new File(exportedContainer, CONTAINER_NAME);
                        File f = new File(destDir, FILE_NAME);
                        is = new FileInputStream(f);
                        Properties loadedProperties = new Properties();
                        loadedProperties.load(is);
                        HashSet<String> missingProperties = new HashSet<String>();
                        for (Object key : loadedProperties.keySet()) {
                            missingProperties.add(key.toString());
                        }
                        MScopedPreferenceStore store = (MScopedPreferenceStore)JaspersoftStudioPlugin.getInstance().getPreferenceStore();
                        IEclipsePreferences pref = store.getQualifierStore();
                        String[] stringArray = pref.keys();
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String key = stringArray[n2];
                            if (!this.getExcludedProeprties().contains(key)) {
                                Object loadedValue = loadedProperties.get(key);
                                if (loadedValue != null) {
                                    pref.put(key, loadedValue.toString());
                                    missingProperties.remove(key);
                                } else {
                                    pref.remove(key);
                                }
                            }
                            ++n2;
                        }
                        Iterator iterator = missingProperties.iterator();
                        while (iterator.hasNext()) {
                            String missingProperty;
                            Object loadedValue = loadedProperties.get(missingProperty = (String)iterator.next());
                            pref.put(missingProperty, loadedValue != null ? loadedValue.toString() : null);
                        }
                        store.save();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        FileUtils.closeStream(is);
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    FileUtils.closeStream(is);
                    throw throwable;
                }
                FileUtils.closeStream((Closeable)is);
            }
        }
    }
}

