/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.preferences.editor.properties;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.action.exporter.BaseResource;
import com.jaspersoft.studio.editor.action.exporter.IExportedResourceHandler;
import com.jaspersoft.studio.editor.action.exporter.IPropertyCustomExporter;
import com.jaspersoft.studio.editor.action.exporter.IResourceDefinition;
import com.jaspersoft.studio.messages.Messages;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import net.sf.jasperreports.eclipse.MScopedPreferenceStore;
import net.sf.jasperreports.eclipse.ui.FolderDestinationDialog;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Pair;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.IPreferenceStore;

public class ExportedStudioTemplatesHandler
implements IExportedResourceHandler,
IPropertyCustomExporter {
    private static final String CONTAINER_NAME = "jssReportTemplates";
    private List<IResourceDefinition> cachedExportableResources = null;
    private Pair<String, List<IResourceDefinition>> cachedImportableResources = null;

    @Override
    public String getResourceNameExport() {
        return "Jaspersoft Studio Templates (" + this.getExportableResources().size() + ")";
    }

    @Override
    public String getResourceNameImport(File exportedContainer) {
        return "Jaspersoft Studio Templates (" + this.getRestorableResources(exportedContainer).size() + ")";
    }

    @Override
    public List<IResourceDefinition> getRestorableResources(File exportedContainer) {
        String containerPath = exportedContainer.getAbsolutePath();
        if (this.cachedImportableResources == null || !((String)this.cachedImportableResources.getKey()).equals(containerPath)) {
            ArrayList<BaseResource> result = new ArrayList<BaseResource>();
            File importedDir = new File(exportedContainer, CONTAINER_NAME);
            if (importedDir.exists()) {
                File[] fileArray = importedDir.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File[] propertiesFiles;
                    File templateFolder = fileArray[n2];
                    File[] fileArray2 = propertiesFiles = templateFolder.listFiles(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return name.endsWith(".properties");
                        }
                    });
                    int n3 = propertiesFiles.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        block10: {
                            File properitesFile = fileArray2[n4];
                            FileInputStream is = null;
                            try {
                                try {
                                    is = new FileInputStream(properitesFile);
                                    Properties props = new Properties();
                                    props.load(is);
                                    String templtateName = props.getProperty("template.name");
                                    if (templtateName != null) {
                                        BaseResource templateResource = new BaseResource(templtateName);
                                        templateResource.setData(properitesFile.getAbsolutePath());
                                        result.add(templateResource);
                                    }
                                }
                                catch (Exception exception) {
                                    net.sf.jasperreports.eclipse.util.FileUtils.closeStream(is);
                                    break block10;
                                }
                            }
                            catch (Throwable throwable) {
                                net.sf.jasperreports.eclipse.util.FileUtils.closeStream(is);
                                throw throwable;
                            }
                            net.sf.jasperreports.eclipse.util.FileUtils.closeStream((Closeable)is);
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
            this.cachedImportableResources = new Pair((Object)containerPath, result);
        }
        return (List)this.cachedImportableResources.getValue();
    }

    @Override
    public List<IResourceDefinition> getExportableResources() {
        if (this.cachedExportableResources == null) {
            this.cachedExportableResources = new ArrayList<IResourceDefinition>();
            try {
                IPreferenceStore store = JaspersoftStudioPlugin.getInstance().getPreferenceStore();
                String s = store.getString("TEMPLATES_LOCATIONS_LIST");
                List<String> paths = this.parseString(s);
                for (String path : paths) {
                    File[] propertiesFiles;
                    File templateLocation = new File(path);
                    File[] fileArray = propertiesFiles = templateLocation.listFiles(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return name.endsWith(".properties");
                        }
                    });
                    int n = propertiesFiles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        block11: {
                            File properitesFile = fileArray[n2];
                            FileInputStream is = null;
                            try {
                                try {
                                    is = new FileInputStream(properitesFile);
                                    Properties props = new Properties();
                                    props.load(is);
                                    String templtateName = props.getProperty("template.name");
                                    if (templtateName != null) {
                                        BaseResource templateResource = new BaseResource(templtateName);
                                        templateResource.setData(properitesFile.getAbsolutePath());
                                        this.cachedExportableResources.add(templateResource);
                                    }
                                }
                                catch (Exception exception) {
                                    net.sf.jasperreports.eclipse.util.FileUtils.closeStream(is);
                                    break block11;
                                }
                            }
                            catch (Throwable throwable) {
                                net.sf.jasperreports.eclipse.util.FileUtils.closeStream(is);
                                throw throwable;
                            }
                            net.sf.jasperreports.eclipse.util.FileUtils.closeStream((Closeable)is);
                        }
                        ++n2;
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return this.cachedExportableResources;
    }

    protected List<String> parseString(String stringList) {
        StringTokenizer st = new StringTokenizer(stringList, String.valueOf(File.pathSeparator) + "\n\r");
        ArrayList<String> v = new ArrayList<String>();
        while (st.hasMoreElements()) {
            v.add(st.nextElement().toString());
        }
        return v;
    }

    protected String createList(List<String> items) {
        StringBuffer path = new StringBuffer("");
        for (String item : items) {
            path.append(item);
            path.append(File.pathSeparator);
        }
        return path.toString();
    }

    protected String getFolderName(HashSet<String> usedNames, String baseName) {
        if (!usedNames.contains(baseName)) {
            return baseName;
        }
        int index = 1;
        String newName = String.valueOf(baseName) + "_" + index;
        while (usedNames.contains(newName)) {
            newName = String.valueOf(baseName) + "_" + ++index;
        }
        return newName;
    }

    protected void removeUnwantedTemplates(File destinationFolder, HashSet<String> allowedTemplates) {
        File[] propertiesFiles;
        File[] fileArray = propertiesFiles = destinationFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".properties");
            }
        });
        int n = propertiesFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File templateFile = fileArray[n2];
            if (!allowedTemplates.contains(templateFile.getName())) {
                File[] filesToDelete;
                final String templateToDelete = FilenameUtils.removeExtension((String)templateFile.getName());
                File[] fileArray2 = filesToDelete = destinationFolder.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        String fileNameWithOutExt = FilenameUtils.removeExtension((String)name);
                        return fileNameWithOutExt.equals(templateToDelete);
                    }
                });
                int n3 = filesToDelete.length;
                int n4 = 0;
                while (n4 < n3) {
                    File fileToDelete = fileArray2[n4];
                    fileToDelete.delete();
                    ++n4;
                }
            }
            ++n2;
        }
    }

    @Override
    public File exportContentFolder(List<IResourceDefinition> resourcesToExport) {
        IPreferenceStore store = JaspersoftStudioPlugin.getInstance().getPreferenceStore();
        String s = store.getString("TEMPLATES_LOCATIONS_LIST");
        List<String> paths = this.parseString(s);
        if (paths.isEmpty()) {
            return null;
        }
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        tempDir.deleteOnExit();
        File destDir = new File(tempDir, CONTAINER_NAME);
        if (destDir.exists()) {
            net.sf.jasperreports.eclipse.util.FileUtils.recursiveDelete((File)destDir);
        }
        destDir.mkdirs();
        HashMap<String, HashSet<String>> templatesToExportMap = new HashMap<String, HashSet<String>>();
        for (IResourceDefinition definition : resourcesToExport) {
            File templateDefinition = new File(definition.getData().toString());
            File contentFolder = templateDefinition.getParentFile();
            String templateDefinitionName = templateDefinition.getName();
            HashSet<String> templateNames = (HashSet<String>)templatesToExportMap.get(contentFolder.getAbsolutePath());
            if (templateNames == null) {
                templateNames = new HashSet<String>();
                templatesToExportMap.put(contentFolder.getAbsolutePath(), templateNames);
            }
            templateNames.add(templateDefinitionName);
        }
        HashSet<String> usedNames = new HashSet<String>();
        for (String path : paths) {
            File filePath = new File(path);
            HashSet templatesToExportSet = (HashSet)templatesToExportMap.get(path);
            if (!filePath.exists() || !filePath.isDirectory() || filePath.list().length <= 0 || templatesToExportSet == null || templatesToExportSet.size() <= 0) continue;
            String folderName = this.getFolderName(usedNames, filePath.getName());
            usedNames.add(folderName);
            File containerfolder = new File(destDir, folderName);
            try {
                FileUtils.copyDirectory((File)filePath, (File)containerfolder);
                this.removeUnwantedTemplates(containerfolder, templatesToExportSet);
            }
            catch (IOException e) {
                e.printStackTrace();
                JaspersoftStudioPlugin.getInstance().logError(e);
            }
        }
        return destDir;
    }

    @Override
    public void restoreContentFolder(File exportedContainer, List<IResourceDefinition> resourcesToImport) {
        FolderDestinationDialog destDialog = new FolderDestinationDialog(UIUtils.getShell(), Messages.ExportedStudioTemplatesHandler_dialogTitle, Messages.ExportedStudioTemplatesHandler_dialogDescription);
        destDialog.open();
        if (destDialog.getDirectory() != null) {
            MScopedPreferenceStore store = (MScopedPreferenceStore)JaspersoftStudioPlugin.getInstance().getPreferenceStore();
            IEclipsePreferences pref = store.getQualifierStore();
            String s = store.getString("TEMPLATES_LOCATIONS_LIST");
            List<String> paths = this.parseString(s);
            File importedDir = new File(exportedContainer, CONTAINER_NAME);
            File targetDir = new File(destDialog.getDirectory());
            HashMap<String, HashSet<String>> templatesToImportMap = new HashMap<String, HashSet<String>>();
            for (IResourceDefinition definition : resourcesToImport) {
                File templateDefinition = new File(definition.getData().toString());
                File contentFolder = templateDefinition.getParentFile();
                String templateDefinitionName = templateDefinition.getName();
                HashSet<String> templateNames = (HashSet<String>)templatesToImportMap.get(contentFolder.getAbsolutePath());
                if (templateNames == null) {
                    templateNames = new HashSet<String>();
                    templatesToImportMap.put(contentFolder.getAbsolutePath(), templateNames);
                }
                templateNames.add(templateDefinitionName);
            }
            File[] fileArray = importedDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File templateFolder = fileArray[n2];
                HashSet templatesToImportSet = (HashSet)templatesToImportMap.get(templateFolder.getAbsolutePath());
                if (templatesToImportSet != null && !templatesToImportSet.isEmpty()) {
                    try {
                        File targetFile = new File(targetDir, templateFolder.getName());
                        FileUtils.copyDirectory((File)templateFolder, (File)targetFile);
                        paths.add(targetFile.getAbsolutePath());
                        this.removeUnwantedTemplates(templateFolder, templatesToImportSet);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        JaspersoftStudioPlugin.getInstance().logError(e);
                    }
                }
                ++n2;
            }
            String newPaths = this.createList(paths);
            pref.put("TEMPLATES_LOCATIONS_LIST", newPaths);
            try {
                store.save();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public List<String> getHandledProperties() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("TEMPLATES_LOCATIONS_LIST");
        return result;
    }
}

