/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.preferences.editor.properties;

import com.jaspersoft.studio.help.TableHelpListener;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.property.dataset.fields.table.TColumn;
import com.jaspersoft.studio.property.dataset.fields.table.TColumnFactory;
import com.jaspersoft.studio.property.dataset.fields.table.widget.AWidget;
import com.jaspersoft.studio.property.descriptor.propexpr.dialog.HintsPropertiesList;
import com.jaspersoft.studio.property.section.widgets.CustomAutoCompleteField;
import com.jaspersoft.studio.swt.widgets.table.ListContentProvider;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.wizards.ContextHelpIDs;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sf.jasperreports.annotations.properties.PropertyScope;
import net.sf.jasperreports.eclipse.ui.util.PersistentLocationDialog;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.properties.PropertyMetadata;
import net.sf.jasperreports.properties.StandardPropertyMetadata;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wb.swt.SWTResourceManager;

public class PropertyListFieldEditor
extends FieldEditor {
    protected Table table;
    protected TableViewer viewer;
    protected List<Pair> input;
    private Composite buttonBox;
    protected Button addButton;
    protected Button duplicateButton;
    protected Button removeButton;
    protected Button editButton;
    protected SelectionListener selectionListener;
    private final int[] columnWidths;
    private final String[] columnNames;
    private static List<PropertyMetadata> pmds = HintsPropertiesList.getPropertiesMetadata(null, JasperReportsConfiguration.getDefaultInstance());
    private static Map<String, PropertyMetadata> pmMap = new HashMap<String, PropertyMetadata>();
    private static List<String> pkeys;

    public PropertyListFieldEditor(String name, String text, Composite parent) {
        this.init(name, text);
        this.columnNames = new String[]{Messages.PropertyListFieldEditor_propertyLabel, Messages.PropertyListFieldEditor_valueLabel};
        this.columnWidths = new int[]{300, 300};
        this.createControl(parent);
    }

    protected Pair getNewInputObject() {
        PEditDialog dialog = new PEditDialog(UIUtils.getShell());
        if (dialog.open() == 0) {
            String name = dialog.getPName();
            for (Pair p : this.input) {
                if (!p.getKey().equals(name)) continue;
                p.setValue(dialog.getPValue());
                this.viewer.refresh();
                return null;
            }
            return new Pair(dialog.getPName(), dialog.getPValue());
        }
        return null;
    }

    protected void doStore() {
        PropertyListFieldEditor.storeProperties(this.input, this.getPreferenceStore());
    }

    public static void storeProperties(List<Pair> in, IPreferenceStore store) {
        Properties props = new Properties();
        for (Pair item : in) {
            String k = item.getKey();
            String v = item.getValue();
            PropertyMetadata pm = pmMap.get(k);
            if (pm != null && pm.getDefaultValue() != null && pm.getDefaultValue().equals(v)) {
                v = null;
            }
            if (v != null) {
                props.setProperty(k, v);
            }
            if (!k.equals("net.sf.jasperreports.default.font.name") && !k.equals("net.sf.jasperreports.default.font.size")) continue;
            PropertyListFieldEditor.setContextProperty(k, v);
        }
        store.setValue("net.sf.jasperreports.JRPROPERTIES", FileUtils.getPropertyAsString((Properties)props));
    }

    private static void setContextProperty(String k, String v) {
        if (v != null) {
            JRPropertiesUtil.getInstance((JasperReportsContext)JasperReportsConfiguration.getDefaultInstance()).setProperty(k, v);
        } else {
            JRPropertiesUtil.getInstance((JasperReportsContext)JasperReportsConfiguration.getDefaultInstance()).removeProperty(k);
        }
    }

    protected void doLoad() {
        if (this.getTable() != null) {
            try {
                this.input = PropertyListFieldEditor.loadProperties(this.getPreferenceStore());
                this.viewer.setInput(this.input);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            TableHelpListener.setTableHelp(this.getTable());
        }
    }

    private static List<String> getPropertyKeys() {
        if (pkeys == null) {
            pkeys = new ArrayList<String>();
            for (PropertyMetadata pm : pmds) {
                pkeys.add(pm.getName());
                pmMap.put(pm.getName(), pm);
            }
            Map jrprops = DefaultJasperReportsContext.getInstance().getProperties();
            for (String k : jrprops.keySet()) {
                if (pkeys.contains(k)) continue;
                StandardPropertyMetadata spm = new StandardPropertyMetadata();
                spm.setName(k);
                ArrayList<PropertyScope> scopes = new ArrayList<PropertyScope>();
                scopes.add(PropertyScope.CONTEXT);
                spm.setScopes(scopes);
                spm.setDefaultValue((String)jrprops.get(k));
                spm.setValueType(String.class.getCanonicalName());
                pkeys.add(k);
                pmMap.put(spm.getName(), (PropertyMetadata)spm);
            }
            Collections.sort(pkeys);
        }
        return pkeys;
    }

    public static List<Pair> loadProperties(IPreferenceStore store) throws IOException {
        Properties props = FileUtils.load((String)store.getString("net.sf.jasperreports.JRPROPERTIES"));
        ArrayList<Pair> input = new ArrayList<Pair>();
        for (String key : PropertyListFieldEditor.getPropertyKeys()) {
            input.add(new Pair(key, props.getProperty(key)));
        }
        for (String key : props.stringPropertyNames()) {
            boolean found = false;
            for (Pair pair : input) {
                if (!pair.key.equals(key)) continue;
                found = true;
                break;
            }
            if (found) continue;
            input.add(new Pair(key, props.getProperty(key)));
        }
        return input;
    }

    protected void doLoadDefault() {
        if (this.getTable() != null) {
            this.getTable().removeAll();
            try {
                Properties props = FileUtils.load((String)this.getPreferenceStore().getDefaultString("net.sf.jasperreports.JRPROPERTIES"));
                this.input = new ArrayList<Pair>();
                for (String key : PropertyListFieldEditor.getPropertyKeys()) {
                    String value = props.getProperty(key);
                    this.input.add(new Pair(key, value));
                }
                this.viewer.setInput(this.input);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, ContextHelpIDs.PREFERENCES_PROPERTIES);
    }

    public void createSelectionListener() {
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Widget widget = event.widget;
                if (widget == PropertyListFieldEditor.this.addButton) {
                    PropertyListFieldEditor.this.addPressed();
                } else if (widget == PropertyListFieldEditor.this.duplicateButton) {
                    PropertyListFieldEditor.this.duplicatePressed();
                } else if (widget == PropertyListFieldEditor.this.removeButton) {
                    PropertyListFieldEditor.this.removePressed();
                } else if (widget == PropertyListFieldEditor.this.editButton) {
                    PropertyListFieldEditor.this.editPressed();
                } else if (widget == PropertyListFieldEditor.this.table) {
                    PropertyListFieldEditor.this.selectionChanged();
                }
            }
        };
    }

    protected void editPressed() {
        StructuredSelection selection = (StructuredSelection)this.viewer.getSelection();
        if (!selection.isEmpty()) {
            Pair element = (Pair)selection.getFirstElement();
            int selIdx = this.input.indexOf(element);
            element = this.input.get(selIdx);
            String pname = element.getKey();
            String pvalue = element.getValue();
            PEditDialog dialog = new PEditDialog(UIUtils.getShell(), pname, pvalue);
            if (dialog.open() == 0) {
                String newPName = dialog.getPName();
                String newPValue = dialog.getPValue();
                if (!pname.equals(newPName)) {
                    int i = 0;
                    while (i < this.table.getItemCount()) {
                        if (i != selIdx && newPName.equals(this.table.getItem(i).getText(0))) {
                            MessageDialog.openError((Shell)UIUtils.getShell(), (String)Messages.PropertyListFieldEditor_ErrTitle, (String)Messages.PropertyListFieldEditor_ErrMsg);
                            return;
                        }
                        ++i;
                    }
                }
                element.setKey(newPName);
                element.setValue(newPValue);
                this.viewer.refresh();
            }
        }
    }

    protected void selectionChanged() {
        boolean isMultiSelection;
        int index = this.table.getSelectionIndex();
        int size = this.table.getItemCount();
        if (this.duplicateButton != null) {
            this.duplicateButton.setEnabled(index >= 0);
        }
        if (this.removeButton != null) {
            this.removeButton.setEnabled(index >= 0);
        }
        boolean bl = isMultiSelection = this.table.getSelectionCount() > 1;
        if (this.editButton != null) {
            this.editButton.setEnabled(!isMultiSelection && size >= 1 && index >= 0 && index < size);
        }
    }

    protected void createButtons(Composite box) {
        this.addButton = this.createPushButton(box, Messages.common_add);
        this.duplicateButton = this.createPushButton(box, Messages.PropertyListFieldEditor_duplicateButton);
        this.removeButton = this.createPushButton(box, Messages.common_delete);
        this.editButton = this.createPushButton(box, Messages.common_edit);
    }

    public Table getTable() {
        return this.table;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    protected Button getAddButton() {
        return this.addButton;
    }

    protected Button getDuplicateButton() {
        return this.duplicateButton;
    }

    protected Button getRemoveButton() {
        return this.removeButton;
    }

    protected Button createPushButton(Composite parent, String key) {
        Button button = new Button(parent, 8);
        button.setText(key);
        button.setFont(parent.getFont());
        GridData data = new GridData(768);
        int widthHint = this.convertHorizontalDLUsToPixels((Control)button, 61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        button.addSelectionListener(this.getSelectionListener());
        return button;
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        ((GridData)this.table.getLayoutData()).horizontalSpan = numColumns - 1;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        control.setLayoutData((Object)gd);
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.minimumWidth = 500;
        gridData.heightHint = 500;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.table = this.getTableControl(composite);
        gd = new GridData(1808);
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = true;
        int[] nArray = this.columnWidths;
        int n = this.columnWidths.length;
        int n2 = 0;
        while (n2 < n) {
            int width = nArray[n2];
            gd.widthHint += width;
            ++n2;
        }
        this.table.setLayoutData((Object)gd);
        this.buttonBox = this.getButtonBoxControl(composite);
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.buttonBox.setLayoutData((Object)gd);
    }

    public Composite getButtonBoxControl(Composite parent) {
        if (this.buttonBox == null) {
            this.buttonBox = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            this.buttonBox.setLayout((Layout)layout);
            this.createButtons(this.buttonBox);
            this.buttonBox.addDisposeListener(event -> {
                this.addButton = null;
                this.duplicateButton = null;
                this.removeButton = null;
                this.buttonBox = null;
            });
        } else {
            this.checkParent((Control)this.buttonBox, parent);
        }
        this.selectionChanged();
        return this.buttonBox;
    }

    public Table getTableControl(Composite parent) {
        if (this.table == null) {
            this.viewer = new TableViewer(parent, 68354);
            this.table = this.viewer.getTable();
            this.table.setFont(parent.getFont());
            this.table.setLinesVisible(true);
            this.table.setHeaderVisible(true);
            this.viewer.setContentProvider((IContentProvider)new ListContentProvider());
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer, (int)2);
            this.table.addSelectionListener(this.getSelectionListener());
            int index = 0;
            String[] stringArray = this.columnNames;
            int n = this.columnNames.length;
            int n2 = 0;
            while (n2 < n) {
                String columnName = stringArray[n2];
                TableViewerColumn tcol = new TableViewerColumn(this.viewer, 0);
                tcol.getColumn().setText(columnName);
                tcol.setLabelProvider((CellLabelProvider)new PairColumnLabelProvider(index));
                ++index;
                ++n2;
            }
            if (this.columnNames.length > 0) {
                TableLayout layout = new TableLayout();
                if (this.columnNames.length > 1) {
                    int i = 0;
                    while (i < this.columnNames.length - 1) {
                        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(0, this.columnWidths[i], false));
                        ++i;
                    }
                }
                layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, this.columnWidths[this.columnNames.length - 1], true));
                this.table.setLayout((Layout)layout);
            }
            this.viewer.addDoubleClickListener(event -> this.editPressed());
        }
        return this.table;
    }

    public int getNumberOfControls() {
        return this.columnNames.length;
    }

    protected SelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.createSelectionListener();
        }
        return this.selectionListener;
    }

    protected Shell getShell() {
        if (this.addButton == null) {
            return null;
        }
        return this.addButton.getShell();
    }

    protected void addPressed() {
        this.setPresentsDefaultValue(false);
        Pair newInputObject = this.getNewInputObject();
        if (newInputObject != null) {
            this.input.add(newInputObject);
            this.viewer.refresh();
        }
    }

    protected void duplicatePressed() {
        this.setPresentsDefaultValue(false);
        StructuredSelection sel = (StructuredSelection)this.viewer.getSelection();
        for (Object obj : sel.toList()) {
            Pair selectedElement = (Pair)obj;
            int index = this.input.indexOf(obj);
            if (index < 0) continue;
            Pair newElement = new Pair(String.valueOf(selectedElement.getKey()) + "_copy", selectedElement.getValue());
            if (index < this.input.size() - 1) {
                this.input.add(index + 1, newElement);
            } else {
                this.input.add(newElement);
            }
            this.viewer.refresh();
        }
        this.selectionChanged();
    }

    protected void removePressed() {
        this.setPresentsDefaultValue(false);
        StructuredSelection sel = (StructuredSelection)this.viewer.getSelection();
        for (Object obj : sel.toList()) {
            int indx = this.input.indexOf(obj);
            if (indx <= -1) continue;
            Pair p = this.input.get(indx);
            if (pmMap.containsKey(p.getKey())) {
                p.setValue(null);
                continue;
            }
            this.input.remove(indx);
        }
        this.viewer.refresh();
        this.selectionChanged();
    }

    public void setFocus() {
        if (this.table != null) {
            this.table.setFocus();
        }
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.getTableControl(parent).setEnabled(enabled);
        if (this.addButton != null) {
            this.addButton.setEnabled(enabled);
        }
        if (this.duplicateButton != null) {
            this.duplicateButton.setEnabled(enabled);
        }
        if (this.removeButton != null) {
            this.removeButton.setEnabled(enabled);
        }
        if (this.editButton != null) {
            this.editButton.setEnabled(enabled);
        }
    }

    public static final class FontStyles {
        private static FontData[] italicValues;

        public static Font getItalicFont() {
            if (italicValues == null) {
                Font originalFont = Display.getCurrent().getSystemFont();
                italicValues = originalFont.getFontData();
                int i = 0;
                while (i < italicValues.length) {
                    italicValues[i].setStyle(italicValues[i].getStyle() | 2);
                    ++i;
                }
            }
            return new Font((Device)Display.getCurrent(), italicValues);
        }
    }

    protected class PEditDialog
    extends PersistentLocationDialog {
        private String pname;
        private String pvalue;
        private JRPropertiesMap pmap;

        protected PEditDialog(Shell parentShell) {
            this(parentShell, null, null);
        }

        protected PEditDialog(Shell parentShell, String pname, String pvalue) {
            super(parentShell);
            this.pname = pname;
            this.pvalue = pvalue;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            composite.setLayout((Layout)new GridLayout(2, false));
            Label label = new Label(composite, 0);
            label.setText(Messages.PropertyListFieldEditor_newPropertyName);
            Text text = new Text(composite, 2048);
            text.setLayoutData((Object)new GridData(768));
            text.setText(Misc.nvl((Object)this.pname, (String)"net.sf.jasperreports."));
            new CustomAutoCompleteField((Control)text, (IControlContentAdapter)new TextContentAdapter(), pkeys.toArray(new String[pkeys.size()]));
            text.addModifyListener(e -> {
                this.pname = text.getText();
                this.pvalue = this.getPValue();
                boolean dispose = false;
                Control[] controlArray = composite.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control c = controlArray[n2];
                    if (dispose) {
                        c.dispose();
                    }
                    if (c == text) {
                        dispose = true;
                    }
                    ++n2;
                }
                this.refreshBottom(composite);
                composite.layout(true);
                composite.update();
            });
            this.refreshBottom(composite);
            return composite;
        }

        private void refreshBottom(Composite composite) {
            PropertyMetadata pm = pmMap.get(this.pname);
            if (pm != null) {
                TColumn tc = TColumnFactory.getTColumn(pm);
                tc.setLabel(Messages.PropertyListFieldEditor_newPropertyValue);
                this.pmap = new JRPropertiesMap();
                this.pmap.setProperty(this.pname, this.pvalue);
                AWidget w = TColumnFactory.addWidget(tc, composite, this.pmap, JasperReportsConfiguration.getDefaultInstance());
                w.getElement();
            } else {
                Label label = new Label(composite, 0);
                label.setText(Messages.PropertyListFieldEditor_newPropertyValue);
                Text tname = new Text(composite, 2048);
                tname.setLayoutData((Object)new GridData(768));
                tname.setText(Misc.nvl((Object)this.pvalue, (String)Messages.PropertyListFieldEditor_exampleValue));
                tname.addModifyListener(e -> {
                    String string = this.pvalue = tname.getText();
                });
            }
        }

        protected boolean isResizable() {
            return true;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setSize(500, 200);
            newShell.setText(Messages.PropertyListFieldEditor_newPropertyTitle);
        }

        public String getPName() {
            return this.pname;
        }

        public String getPValue() {
            if (this.pmap != null) {
                return this.pmap.getProperty(this.pname);
            }
            return this.pvalue;
        }
    }

    public static class Pair {
        private String key;
        private String value;

        public Pair(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Pair p = (Pair)obj;
            return this.key.equals(p.getKey()) && (this.value == null && p.getValue() == null || this.value != null && this.value.equals(p.getValue()));
        }

        public int hashCode() {
            int hash = 1;
            hash = hash * 17 + this.key.hashCode();
            hash = hash * 31 + (this.value != null ? this.value.hashCode() : 0);
            return hash;
        }
    }

    class PairColumnLabelProvider
    extends ColumnLabelProvider
    implements IColorProvider {
        private int index;
        private Font italicFont;

        public PairColumnLabelProvider(int index) {
            this.index = index;
        }

        public String getText(Object element) {
            Pair p = (Pair)element;
            if (this.index == 0) {
                return p.getKey();
            }
            if (this.index == 1) {
                String def;
                if (p.getValue() != null) {
                    return p.getValue();
                }
                PropertyMetadata pm = pmMap.get(p.getKey());
                if (pm != null && (def = pm.getDefaultValue()) != null) {
                    return def;
                }
            }
            return null;
        }

        public String getToolTipText(Object element) {
            Pair p = (Pair)element;
            String tt = p.key;
            PropertyMetadata pm = pmMap.get(p.getKey());
            if (pm != null) {
                tt = String.valueOf(tt) + HintsPropertiesList.getToolTip(pm);
            }
            return tt;
        }

        public Color getForeground(Object element) {
            Pair p = (Pair)element;
            if (p.getValue() == null) {
                String def;
                PropertyMetadata pm = pmMap.get(p.getKey());
                if (pm.isDeprecated() && this.index == 0) {
                    return SWTResourceManager.getColor((int)39);
                }
                if (this.index == 1 && (def = pm.getDefaultValue()) != null) {
                    return SWTResourceManager.getColor((int)39);
                }
            }
            return null;
        }

        public Font getFont(Object element) {
            Pair p = (Pair)element;
            PropertyMetadata pm = pmMap.get(p.getKey());
            if (pm != null && pm.isDeprecated()) {
                if (this.italicFont != null) {
                    this.italicFont.dispose();
                    this.italicFont = FontStyles.getItalicFont();
                }
                return this.italicFont;
            }
            return super.getFont(element);
        }

        public void dispose() {
            if (this.italicFont != null) {
                this.italicFont.dispose();
            }
            super.dispose();
        }
    }
}

