/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.preferences.editor.table;

import com.jaspersoft.studio.messages.Messages;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public abstract class TreeFieldEditor
extends FieldEditor {
    protected TreeViewer tree;
    private Composite buttonBox;
    protected Button addButton;
    protected Button duplicateButton;
    protected Button removeButton;
    protected Button upButton;
    protected Button downButton;
    protected SelectionListener selectionListener;

    public Tree getTable() {
        return this.tree.getTree();
    }

    protected TreeFieldEditor() {
    }

    protected TreeFieldEditor(String name, String labelText, Composite parent) {
        this.init(name, labelText);
        this.createControl(parent);
    }

    protected void createButtons(Composite box) {
        this.addButton = this.createPushButton(box, Messages.common_add);
        this.duplicateButton = this.createPushButton(box, Messages.common_duplicate);
        this.removeButton = this.createPushButton(box, Messages.common_delete);
        this.upButton = this.createPushButton(box, Messages.common_up);
        this.downButton = this.createPushButton(box, Messages.common_down);
    }

    protected Button getAddButton() {
        return this.addButton;
    }

    protected Button getDuplicateButton() {
        return this.duplicateButton;
    }

    protected Button getRemoveButton() {
        return this.removeButton;
    }

    protected Button getUpButton() {
        return this.upButton;
    }

    protected Button getDownButton() {
        return this.downButton;
    }

    protected Button createPushButton(Composite parent, String key) {
        Button button = new Button(parent, 8);
        button.setText(key);
        button.setFont(parent.getFont());
        GridData data = new GridData(768);
        int widthHint = this.convertHorizontalDLUsToPixels((Control)button, 61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        button.addSelectionListener(this.getSelectionListener());
        return button;
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        ((GridData)this.tree.getTree().getLayoutData()).horizontalSpan = numColumns - 1;
    }

    public void createSelectionListener() {
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Widget widget = event.widget;
                if (widget == TreeFieldEditor.this.addButton) {
                    TreeFieldEditor.this.addPressed();
                } else if (widget == TreeFieldEditor.this.duplicateButton) {
                    TreeFieldEditor.this.duplicatePressed();
                } else if (widget == TreeFieldEditor.this.removeButton) {
                    TreeFieldEditor.this.removePressed();
                } else if (widget == TreeFieldEditor.this.upButton) {
                    TreeFieldEditor.this.upPressed();
                } else if (widget == TreeFieldEditor.this.downButton) {
                    TreeFieldEditor.this.downPressed();
                } else if (widget == TreeFieldEditor.this.tree.getTree()) {
                    TreeFieldEditor.this.selectionChanged();
                }
            }
        };
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        control.setLayoutData((Object)gd);
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.minimumWidth = 500;
        gridData.heightHint = 500;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.tree = this.getTreeControl(composite);
        gd = new GridData(1808);
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = true;
        this.tree.getTree().setLayoutData((Object)gd);
        this.buttonBox = this.getButtonBoxControl(composite);
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.buttonBox.setLayoutData((Object)gd);
    }

    public Composite getButtonBoxControl(Composite parent) {
        if (this.buttonBox == null) {
            this.buttonBox = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            this.buttonBox.setLayout((Layout)layout);
            this.createButtons(this.buttonBox);
            this.buttonBox.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    TreeFieldEditor.this.addButton = null;
                    TreeFieldEditor.this.duplicateButton = null;
                    TreeFieldEditor.this.removeButton = null;
                    TreeFieldEditor.this.upButton = null;
                    TreeFieldEditor.this.downButton = null;
                    TreeFieldEditor.this.buttonBox = null;
                }
            });
        } else {
            this.checkParent((Control)this.buttonBox, parent);
        }
        this.selectionChanged();
        return this.buttonBox;
    }

    public TreeViewer getTreeControl(Composite parent) {
        return this.getTreeControl(parent, 770);
    }

    public TreeViewer getTreeControl(Composite parent, int style) {
        if (this.tree == null) {
            this.tree = new TreeViewer(parent, style);
            this.setupTree(this.tree);
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tree, (int)2);
            this.tree.getTree().addSelectionListener(this.getSelectionListener());
            this.tree.getTree().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    TreeFieldEditor.this.tree = null;
                }
            });
            this.tree.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    TreeFieldEditor.this.handleTableDoubleClick();
                }
            });
        }
        return this.tree;
    }

    protected abstract void setupTree(TreeViewer var1);

    protected void handleTableDoubleClick() {
    }

    protected boolean isFieldEditable(int col, int row) {
        return true;
    }

    public int getNumberOfControls() {
        return 2;
    }

    protected SelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.createSelectionListener();
        }
        return this.selectionListener;
    }

    protected Shell getShell() {
        if (this.addButton == null) {
            return null;
        }
        return this.addButton.getShell();
    }

    protected abstract void addPressed();

    protected abstract void duplicatePressed();

    protected abstract void removePressed();

    protected abstract void upPressed();

    protected abstract void downPressed();

    protected void selectionChanged() {
        StructuredSelection sel = (StructuredSelection)this.tree.getSelection();
        if (this.duplicateButton != null) {
            this.duplicateButton.setEnabled(!sel.isEmpty());
        }
        if (this.removeButton != null) {
            this.removeButton.setEnabled(!sel.isEmpty() && this.isRemovable(sel));
        }
        if (this.upButton != null) {
            this.upButton.setEnabled(!sel.isEmpty() && this.isSortable(sel) && this.canGoUp(sel));
        }
        if (this.downButton != null) {
            this.downButton.setEnabled(!sel.isEmpty() && this.isSortable(sel) && this.canGoDown(sel));
        }
    }

    protected boolean isRemovable(StructuredSelection sel) {
        return true;
    }

    protected boolean canGoUp(StructuredSelection sel) {
        return true;
    }

    protected boolean canGoDown(StructuredSelection sel) {
        return true;
    }

    protected boolean isSortable(StructuredSelection sel) {
        return true;
    }

    public void setFocus() {
        if (this.tree != null) {
            this.tree.getTree().setFocus();
        }
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.getTreeControl(parent).getTree().setEnabled(enabled);
        if (this.addButton != null) {
            this.addButton.setEnabled(enabled);
        }
        if (this.duplicateButton != null) {
            this.duplicateButton.setEnabled(enabled);
        }
        if (this.removeButton != null) {
            this.removeButton.setEnabled(enabled);
        }
        if (this.upButton != null) {
            this.upButton.setEnabled(enabled);
        }
        if (this.downButton != null) {
            this.downButton.setEnabled(enabled);
        }
    }
}

