/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.preferences.fonts;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.font.FontEditor;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.preferences.editor.table.TreeFieldEditor;
import com.jaspersoft.studio.preferences.fonts.FontPathWizard;
import com.jaspersoft.studio.preferences.fonts.FontSetDialog;
import com.jaspersoft.studio.preferences.fonts.FontSetFamilyDialog;
import com.jaspersoft.studio.preferences.fonts.FontURLWizard;
import com.jaspersoft.studio.preferences.fonts.SelectFontSetSetDialog;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.fonts.FontExtensionsCollector;
import net.sf.jasperreports.engine.fonts.FontExtensionsContainer;
import net.sf.jasperreports.engine.fonts.FontExtensionsReceiver;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.engine.fonts.FontSet;
import net.sf.jasperreports.engine.fonts.FontSetFamily;
import net.sf.jasperreports.engine.fonts.SimpleFontExtensionHelper;
import net.sf.jasperreports.engine.fonts.SimpleFontExtensionsContainer;
import net.sf.jasperreports.engine.fonts.SimpleFontFamily;
import net.sf.jasperreports.engine.fonts.SimpleFontSet;
import net.sf.jasperreports.engine.fonts.SimpleFontSetFamily;
import org.eclipse.core.commands.operations.OperationStatus;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class FontListFieldEditor
extends TreeFieldEditor {
    private Button editButton;
    private Button exportButton;
    private FontExtensionsCollector fontFamilies;
    private Button addURLButton;
    private Button addPathButton;
    private Button addSetButton;
    private Button addToSetButton;

    public FontListFieldEditor() {
    }

    public FontListFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
    }

    @Override
    protected void setupTree(TreeViewer tree) {
        tree.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof FontExtensionsCollector) {
                    ArrayList lst = new ArrayList();
                    lst.addAll(((FontExtensionsCollector)inputElement).getFontFamilies());
                    lst.addAll(((FontExtensionsCollector)inputElement).getFontSets());
                    return lst.toArray();
                }
                if (inputElement instanceof List) {
                    return ((List)inputElement).toArray();
                }
                return new Object[0];
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof SimpleFontSet) {
                    return ((SimpleFontSet)parentElement).getFamilies().toArray();
                }
                return null;
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return element instanceof SimpleFontSet && !Misc.isNullOrEmpty((Collection)((SimpleFontSet)element).getFamilies());
            }
        });
        tree.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new FontLabelProvider()));
    }

    protected void doLoadDefault() {
        if (this.tree != null) {
            this.fontFamilies = new FontExtensionsCollector();
            this.tree.setInput((Object)this.fontFamilies);
            String s = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
            if (Misc.isNullOrEmpty((String)s)) {
                return;
            }
            SimpleFontExtensionHelper.getInstance().loadFontExtensions((JasperReportsContext)JasperReportsConfiguration.getDefaultInstance(), (InputStream)new ByteArrayInputStream(s.getBytes()), (FontExtensionsReceiver)this.fontFamilies, false);
            this.tree.refresh(true);
        }
    }

    protected void doLoad() {
        if (this.tree != null) {
            this.fontFamilies = new FontExtensionsCollector();
            this.tree.setInput((Object)this.fontFamilies);
            String s = this.getPreferenceStore().getString(this.getPreferenceName());
            if (Misc.isNullOrEmpty((String)s)) {
                return;
            }
            SimpleFontExtensionHelper.getInstance().loadFontExtensions((JasperReportsContext)JasperReportsConfiguration.getDefaultInstance(), (InputStream)new ByteArrayInputStream(s.getBytes()), (FontExtensionsReceiver)this.fontFamilies, false);
            this.tree.refresh(true);
        }
    }

    protected void doStore() {
        String pname = this.getPreferenceName();
        if (this.fontFamilies != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                try {
                    SimpleFontExtensionHelper.writeFontExtensionsXml((OutputStream)baos, (FontExtensionsContainer)new SimpleFontExtensionsContainer(this.fontFamilies.getFontFamilies(), this.fontFamilies.getFontSets()));
                    this.getPreferenceStore().setValue(pname, new String(baos.toByteArray()));
                }
                catch (JRException e) {
                    UIUtils.showError((Throwable)e);
                    FileUtils.closeStream((Closeable)baos);
                }
            }
            finally {
                FileUtils.closeStream((Closeable)baos);
            }
        } else {
            this.getPreferenceStore().setValue(pname, this.getPreferenceStore().getDefaultString(pname));
        }
    }

    @Override
    protected void addPressed() {
        this.setPresentsDefaultValue(false);
        SimpleFontFamily ff = new SimpleFontFamily();
        ff.setName(Messages.FontListFieldEditor_newFontSuggestedName);
        FontFamily font = FontEditor.runDialog((FontFamily)ff);
        if (font != null) {
            this.fontFamilies.getFontFamilies().add(ff);
            this.tree.refresh(true);
            this.tree.setSelection((ISelection)new StructuredSelection((Object)ff), true);
            this.selectionChanged();
        }
    }

    @Override
    protected void removePressed() {
        if (UIUtils.showDeleteConfirmation()) {
            this.setPresentsDefaultValue(false);
            StructuredSelection sel = (StructuredSelection)this.tree.getSelection();
            for (Object obj : sel.toList()) {
                if (obj instanceof FontFamily) {
                    this.fontFamilies.getFontFamilies().remove(obj);
                    continue;
                }
                if (obj instanceof FontSet) {
                    this.fontFamilies.getFontSets().remove(obj);
                    continue;
                }
                if (!(obj instanceof FontSetFamily)) continue;
                for (FontSet fs : this.fontFamilies.getFontSets()) {
                    fs.getFamilies().remove(obj);
                }
            }
            this.tree.refresh(true);
            this.selectionChanged();
        }
    }

    @Override
    protected void duplicatePressed() {
        this.setPresentsDefaultValue(false);
        StructuredSelection sel = (StructuredSelection)this.tree.getSelection();
        for (Object obj : sel.toList()) {
            boolean exists;
            int i;
            String newname;
            SimpleFontFamily clone;
            if (obj instanceof FontFamily) {
                clone = (SimpleFontFamily)((SimpleFontFamily)obj).clone();
                newname = String.valueOf(((FontFamily)obj).getName()) + "_copy";
                i = 1;
                while (i < 1000) {
                    exists = false;
                    for (FontFamily f : this.fontFamilies.getFontFamilies()) {
                        if (!f.getName().equals(newname)) continue;
                        exists = true;
                        break;
                    }
                    if (!exists) break;
                    newname = String.valueOf(((FontFamily)obj).getName()) + "_copy" + i;
                    ++i;
                }
                clone.setName(newname);
                this.fontFamilies.getFontFamilies().add(clone);
                this.tree.refresh(true);
                this.tree.setSelection((ISelection)new StructuredSelection((Object)clone), true);
                this.selectionChanged();
                continue;
            }
            if (!(obj instanceof FontSet)) continue;
            clone = (SimpleFontSet)((SimpleFontSet)obj).clone();
            newname = String.valueOf(((FontSet)obj).getName()) + "_copy";
            i = 1;
            while (i < 1000) {
                exists = false;
                for (FontFamily f : this.fontFamilies.getFontSets()) {
                    if (!f.getName().equals(newname)) continue;
                    exists = true;
                    break;
                }
                if (!exists) break;
                newname = String.valueOf(((FontSet)obj).getName()) + "_copy" + i;
                ++i;
            }
            clone.setName(newname);
            this.fontFamilies.getFontSets().add(clone);
            this.tree.refresh(true);
            this.tree.setSelection((ISelection)new StructuredSelection((Object)clone), true);
            this.selectionChanged();
        }
    }

    protected void editPressed() {
        this.setPresentsDefaultValue(false);
        StructuredSelection sel = (StructuredSelection)this.tree.getSelection();
        if (sel.getFirstElement() instanceof SimpleFontFamily) {
            SimpleFontFamily font = (SimpleFontFamily)sel.getFirstElement();
            int index = this.fontFamilies.getFontFamilies().indexOf(font);
            if ((font = FontEditor.runDialog((FontFamily)font.clone())) != null) {
                this.fontFamilies.getFontFamilies().set(index, font);
                this.tree.refresh(true);
                this.tree.setSelection((ISelection)new StructuredSelection((Object)font), true);
                this.selectionChanged();
            }
        } else if (sel.getFirstElement() instanceof SimpleFontSet) {
            SimpleFontSet fset = (SimpleFontSet)sel.getFirstElement();
            FontSetDialog d = new FontSetDialog(UIUtils.getShell(), (SimpleFontSet)fset.clone());
            if (d.open() == 0) {
                fset.setName(d.getValue().getName());
                this.tree.refresh(true);
                this.tree.setSelection((ISelection)new StructuredSelection((Object)fset), true);
                this.selectionChanged();
            }
        } else if (sel.getFirstElement() instanceof SimpleFontSetFamily) {
            SimpleFontSetFamily fsetf = (SimpleFontSetFamily)sel.getFirstElement();
            for (FontSet fs : this.fontFamilies.getFontSets()) {
                FontSetFamilyDialog d;
                if (!fs.getFamilies().contains(fsetf) || (d = new FontSetFamilyDialog(UIUtils.getShell(), (SimpleFontSet)fs, (SimpleFontSetFamily)fsetf.clone())).open() != 0) continue;
                SimpleFontSetFamily v = d.getValue();
                fsetf.setPrimary(v.isPrimary());
                fsetf.setIncludedScripts(v.getIncludedScripts());
                fsetf.setExcludedScripts(v.getExcludedScripts());
                this.tree.refresh(true);
                this.tree.setSelection((ISelection)new StructuredSelection((Object)fsetf), true);
                this.selectionChanged();
            }
        }
    }

    protected void addSetPressed() {
        this.setPresentsDefaultValue(false);
        StructuredSelection sel = (StructuredSelection)this.tree.getSelection();
        SimpleFontSet fs = new SimpleFontSet();
        fs.setName("FontSet");
        FontSetDialog d = new FontSetDialog(UIUtils.getShell(), fs);
        if (d.open() == 0) {
            boolean first = true;
            for (Object obj : sel.toList()) {
                if (!(obj instanceof FontFamily)) continue;
                SimpleFontSetFamily fsf = new SimpleFontSetFamily();
                fsf.setFamilyName(((FontFamily)obj).getName());
                fsf.setPrimary(first);
                first = false;
                fs.addFamily((FontSetFamily)fsf);
            }
            this.fontFamilies.getFontSets().add(fs);
            this.tree.refresh(true);
            this.tree.setSelection((ISelection)new StructuredSelection((Object)fs), true);
            this.selectionChanged();
        }
    }

    protected void add2SetPressed() {
        this.setPresentsDefaultValue(false);
        StructuredSelection sel = (StructuredSelection)this.tree.getSelection();
        SelectFontSetSetDialog d = new SelectFontSetSetDialog(UIUtils.getShell(), this.fontFamilies.getFontSets());
        if (d.open() == 0) {
            SimpleFontSet fs = (SimpleFontSet)d.getValue();
            if (fs == null) {
                return;
            }
            for (Object obj : sel.toList()) {
                if (!(obj instanceof FontFamily)) continue;
                SimpleFontSetFamily fsf = new SimpleFontSetFamily();
                fsf.setFamilyName(((FontFamily)obj).getName());
                ((SimpleFontSet)d.getValue()).addFamily((FontSetFamily)fsf);
            }
            this.tree.refresh(true);
            this.tree.setSelection((ISelection)new StructuredSelection((Object)fs), true);
            this.selectionChanged();
        }
    }

    protected void exportPressed() {
        StructuredSelection sel = (StructuredSelection)this.tree.getSelection();
        if (sel.isEmpty()) {
            return;
        }
        ArrayList<FontFamily> ff = new ArrayList<FontFamily>();
        for (Object obj : sel.toList()) {
            if (!(obj instanceof FontFamily)) continue;
            ff.add((FontFamily)((JRCloneable)obj).clone());
        }
        ArrayList<FontSet> fs = new ArrayList<FontSet>();
        for (Object obj : sel.toList()) {
            if (!(obj instanceof FontSet)) continue;
            fs.add((FontSet)((JRCloneable)obj).clone());
            block2: for (FontSetFamily fsf : ((FontSet)obj).getFamilies()) {
                for (FontFamily f : this.fontFamilies.getFontFamilies()) {
                    if (!f.getName().equals(fsf.getFamilyName())) continue;
                    boolean exists = false;
                    for (FontFamily item : ff) {
                        if (!item.getName().equals(fsf.getFamilyName())) continue;
                        exists = true;
                        break;
                    }
                    if (exists) continue block2;
                    ff.add((FontFamily)((JRCloneable)f).clone());
                    continue block2;
                }
            }
        }
        final SimpleFontExtensionsContainer c = new SimpleFontExtensionsContainer(ff, fs);
        final IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        FileDialog fd = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
        fd.setText(Messages.FontListFieldEditor_exportToJar);
        FontEditor.setupLastLocation(fd);
        fd.setFilterExtensions(new String[]{"*.jar", "*.zip"});
        final String selected = fd.open();
        FontEditor.setLastLocation(fd, selected);
        if (selected != null) {
            Job job = new Job(Messages.FontListFieldEditor_exportToJar){

                protected IStatus run(IProgressMonitor monitor) {
                    monitor.beginTask(Messages.FontListFieldEditor_exportToJar, -1);
                    try {
                        try {
                            FontEditor.exportJAR(c, selected);
                            IFile[] resource = root.findFilesForLocationURI(new File(selected).toURI());
                            if (resource != null) {
                                IFile[] iFileArray = resource;
                                int n = resource.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IFile f = iFileArray[n2];
                                    f.refreshLocal(1, monitor);
                                    ++n2;
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            UIUtils.getDisplay().asyncExec(() -> {
                                OperationStatus status = new OperationStatus(4, JaspersoftStudioPlugin.getUniqueIdentifier(), 1, "Error saving file.", e.getCause());
                                ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.FontListFieldEditor_errorSave, null, (IStatus)status);
                            });
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(30);
            job.schedule();
        }
    }

    @Override
    protected void createButtons(Composite box) {
        this.addURLButton = this.createPushButton(box, Messages.JRVersionPage_3);
        this.addPathButton = this.createPushButton(box, Messages.JRVersionPage_4);
        this.addButton = this.createPushButton(box, Messages.common_add);
        ((GridData)this.addButton.getLayoutData()).verticalIndent = 20;
        this.duplicateButton = this.createPushButton(box, Messages.common_duplicate);
        this.editButton = this.createPushButton(box, Messages.FontListFieldEditor_editButton);
        this.removeButton = this.createPushButton(box, Messages.common_delete);
        this.upButton = this.createPushButton(box, Messages.common_up);
        this.downButton = this.createPushButton(box, Messages.common_down);
        this.addSetButton = this.createPushButton(box, Messages.FontListFieldEditor_6);
        ((GridData)this.addSetButton.getLayoutData()).verticalIndent = 20;
        this.addToSetButton = this.createPushButton(box, "Add To Set");
        this.exportButton = this.createPushButton(box, Messages.FontListFieldEditor_exportButton);
        ((GridData)this.exportButton.getLayoutData()).verticalIndent = 20;
    }

    @Override
    public void createSelectionListener() {
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Widget widget = event.widget;
                if (widget == FontListFieldEditor.this.addButton) {
                    FontListFieldEditor.this.addPressed();
                } else if (widget == FontListFieldEditor.this.addSetButton) {
                    FontListFieldEditor.this.addSetPressed();
                } else if (widget == FontListFieldEditor.this.addToSetButton) {
                    FontListFieldEditor.this.add2SetPressed();
                } else if (widget == FontListFieldEditor.this.duplicateButton) {
                    FontListFieldEditor.this.duplicatePressed();
                } else if (widget == FontListFieldEditor.this.removeButton) {
                    FontListFieldEditor.this.removePressed();
                } else if (widget == FontListFieldEditor.this.upButton) {
                    FontListFieldEditor.this.upPressed();
                } else if (widget == FontListFieldEditor.this.downButton) {
                    FontListFieldEditor.this.downPressed();
                } else if (widget == FontListFieldEditor.this.editButton) {
                    FontListFieldEditor.this.editPressed();
                } else if (widget == FontListFieldEditor.this.exportButton) {
                    FontListFieldEditor.this.exportPressed();
                } else if (widget == FontListFieldEditor.this.tree.getTree()) {
                    FontListFieldEditor.this.selectionChanged();
                } else if (widget == FontListFieldEditor.this.addURLButton) {
                    FontListFieldEditor.this.addURLPressed();
                } else if (widget == FontListFieldEditor.this.addPathButton) {
                    FontListFieldEditor.this.addPathPressed();
                }
            }
        };
    }

    protected void addURLPressed() {
        FontURLWizard wiz = new FontURLWizard(new ArrayList<FontFamily>(this.fontFamilies.getFontFamilies()));
        WizardDialog d = new WizardDialog(UIUtils.getShellForWizardDialog(), (IWizard)wiz);
        d.setPageSize(800, 50);
        if (d.open() == 0) {
            if (this.fontFamilies == null) {
                this.fontFamilies = new FontExtensionsCollector();
                this.tree.setInput((Object)this.fontFamilies);
            }
            this.fontFamilies.getFontFamilies().clear();
            this.fontFamilies.getFontFamilies().addAll(wiz.getFonts());
            this.tree.refresh(true);
            this.selectionChanged();
        }
    }

    protected void addPathPressed() {
        FontPathWizard wiz = new FontPathWizard(new ArrayList<FontFamily>(this.fontFamilies.getFontFamilies()));
        WizardDialog d = new WizardDialog(UIUtils.getShellForWizardDialog(), (IWizard)wiz);
        d.setPageSize(800, 50);
        if (d.open() == 0) {
            if (this.fontFamilies == null) {
                this.fontFamilies = new FontExtensionsCollector();
                this.tree.setInput((Object)this.fontFamilies);
            }
            this.fontFamilies.getFontFamilies().clear();
            this.fontFamilies.getFontFamilies().addAll(wiz.getFonts());
            this.tree.refresh(true);
            this.selectionChanged();
        }
    }

    @Override
    protected void selectionChanged() {
        boolean en;
        super.selectionChanged();
        StructuredSelection sel = (StructuredSelection)this.tree.getSelection();
        if (this.addButton != null) {
            this.addButton.setEnabled(sel.isEmpty() || !sel.isEmpty() && sel.size() == 1 && !(sel.getFirstElement() instanceof SimpleFontSetFamily));
        }
        if (this.editButton != null) {
            this.editButton.setEnabled(!sel.isEmpty() && sel.size() == 1);
        }
        if (this.duplicateButton != null) {
            this.duplicateButton.setEnabled(!sel.isEmpty() && !(sel.getFirstElement() instanceof SimpleFontSetFamily));
        }
        if (this.exportButton != null) {
            boolean bl = en = !sel.isEmpty();
            if (en) {
                for (Object obj : sel.toList()) {
                    if (!(obj instanceof FontSetFamily)) continue;
                    en = false;
                    break;
                }
            }
            this.exportButton.setEnabled(en);
        }
        if (this.addSetButton != null) {
            boolean bl = en = !sel.isEmpty();
            if (en) {
                for (Object obj : sel.toList()) {
                    if (obj instanceof FontFamily) continue;
                    en = false;
                    break;
                }
            }
            this.addSetButton.setEnabled(en);
        }
        if (this.addToSetButton != null) {
            boolean bl = en = !sel.isEmpty();
            if (en) {
                for (Object obj : sel.toList()) {
                    if (obj instanceof FontFamily) continue;
                    en = false;
                    break;
                }
            }
            this.addToSetButton.setEnabled(en);
        }
    }

    @Override
    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.editButton.setEnabled(enabled);
        this.exportButton.setEnabled(enabled);
        this.addPathButton.setEnabled(enabled);
        this.addURLButton.setEnabled(enabled);
        this.addSetButton.setEnabled(enabled);
        this.addToSetButton.setEnabled(enabled);
    }

    @Override
    public int getNumberOfControls() {
        return 1;
    }

    @Override
    protected boolean isFieldEditable(int col, int row) {
        return false;
    }

    @Override
    protected boolean canGoUp(StructuredSelection sel) {
        Object obj = sel.getFirstElement();
        if (obj instanceof FontFamily) {
            return this.fontFamilies.getFontFamilies().indexOf(obj) > 0;
        }
        if (obj instanceof FontSet) {
            return this.fontFamilies.getFontSets().indexOf(obj) > 0;
        }
        if (obj instanceof FontSetFamily) {
            for (FontSet fs : this.fontFamilies.getFontSets()) {
                if (!fs.getFamilies().contains(obj)) continue;
                return fs.getFamilies().indexOf(obj) > 0;
            }
        }
        return false;
    }

    @Override
    protected boolean canGoDown(StructuredSelection sel) {
        Object obj = sel.getFirstElement();
        if (obj instanceof FontFamily) {
            return this.fontFamilies.getFontFamilies().indexOf(obj) < this.fontFamilies.getFontFamilies().size() - 1;
        }
        if (obj instanceof FontSet) {
            return this.fontFamilies.getFontSets().indexOf(obj) < this.fontFamilies.getFontSets().size() - 1;
        }
        if (obj instanceof FontSetFamily) {
            for (FontSet fs : this.fontFamilies.getFontSets()) {
                if (!fs.getFamilies().contains(obj)) continue;
                return fs.getFamilies().indexOf(obj) < fs.getFamilies().size() - 1;
            }
        }
        return false;
    }

    @Override
    protected boolean isSortable(StructuredSelection sel) {
        return sel.size() == 1;
    }

    @Override
    protected void handleTableDoubleClick() {
        super.handleTableDoubleClick();
        if (this.editButton.isEnabled()) {
            this.editPressed();
        }
    }

    @Override
    protected void upPressed() {
        StructuredSelection sel = (StructuredSelection)this.tree.getSelection();
        Object obj = sel.getFirstElement();
        if (obj instanceof FontFamily) {
            int ind = this.fontFamilies.getFontFamilies().indexOf(obj);
            this.fontFamilies.getFontFamilies().remove(ind);
            this.fontFamilies.getFontFamilies().add(ind - 1, (FontFamily)obj);
        } else if (obj instanceof FontSet) {
            int ind = this.fontFamilies.getFontSets().indexOf(obj);
            this.fontFamilies.getFontSets().remove(ind);
            this.fontFamilies.getFontSets().add(ind - 1, (FontSet)obj);
        } else if (obj instanceof FontSetFamily) {
            for (FontSet fs : this.fontFamilies.getFontSets()) {
                if (!fs.getFamilies().contains(obj)) continue;
                int ind = fs.getFamilies().indexOf(obj);
                fs.getFamilies().remove(ind);
                fs.getFamilies().add(ind - 1, (FontSetFamily)obj);
                break;
            }
        }
        this.tree.refresh(true);
        this.tree.setSelection((ISelection)new StructuredSelection(obj), true);
        this.selectionChanged();
    }

    @Override
    protected void downPressed() {
        StructuredSelection sel = (StructuredSelection)this.tree.getSelection();
        Object obj = sel.getFirstElement();
        if (obj instanceof FontFamily) {
            int ind = this.fontFamilies.getFontFamilies().indexOf(obj);
            this.fontFamilies.getFontFamilies().remove(ind);
            this.fontFamilies.getFontFamilies().add(ind + 1, (FontFamily)obj);
        } else if (obj instanceof FontSet) {
            int ind = this.fontFamilies.getFontSets().indexOf(obj);
            this.fontFamilies.getFontSets().remove(ind);
            this.fontFamilies.getFontSets().add(ind + 1, (FontSet)obj);
        } else if (obj instanceof FontSetFamily) {
            for (FontSet fs : this.fontFamilies.getFontSets()) {
                if (!fs.getFamilies().contains(obj)) continue;
                int ind = fs.getFamilies().indexOf(obj);
                fs.getFamilies().remove(ind);
                fs.getFamilies().add(ind + 1, (FontSetFamily)obj);
                break;
            }
        }
        this.tree.refresh(true);
        this.tree.setSelection((ISelection)new StructuredSelection(obj), true);
        this.selectionChanged();
    }

    @Override
    public TreeViewer getTreeControl(Composite parent) {
        return this.getTreeControl(parent, 2818);
    }

    class FontLabelProvider
    extends ColumnLabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        FontLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof SimpleFontSet) {
                return ((SimpleFontSet)element).getName();
            }
            if (element instanceof SimpleFontFamily) {
                return ((SimpleFontFamily)element).getName();
            }
            if (element instanceof SimpleFontSetFamily) {
                return ((SimpleFontSetFamily)element).getFamilyName();
            }
            return "";
        }

        public Image getImage(Object element) {
            if (element instanceof SimpleFontSetFamily && ((SimpleFontSetFamily)element).isPrimary()) {
                return JaspersoftStudioPlugin.getInstance().getImage("icons/resources/check-16.png");
            }
            return null;
        }

        public StyledString getStyledText(Object element) {
            StyledString ss = new StyledString();
            if (element instanceof SimpleFontSet) {
                ss.append(((SimpleFontSet)element).getName(), StyledString.QUALIFIER_STYLER);
            } else if (element instanceof SimpleFontFamily) {
                ss.append(((SimpleFontFamily)element).getName());
            } else if (element instanceof SimpleFontSetFamily) {
                ss.append(((SimpleFontSetFamily)element).getFamilyName(), StyledString.DECORATIONS_STYLER);
            }
            return ss;
        }
    }
}

