/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.preferences.fonts;

import com.jaspersoft.studio.ConfigurationManager;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.preferences.fonts.FontImporter;
import com.jaspersoft.studio.preferences.fonts.FontPathPage;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.fonts.FontFamily;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class FontPathWizard
extends Wizard {
    private FontPathPage page0;
    protected List<FontFamily> fontFamilies = new ArrayList<FontFamily>();
    public static File storage = ConfigurationManager.getStorage("fonts");

    public FontPathWizard(List<FontFamily> fontFamilies) {
        this.setWindowTitle(Messages.FontPathWizard_0);
        this.setNeedsProgressMonitor(true);
        this.fontFamilies = fontFamilies;
    }

    public List<FontFamily> getFonts() {
        return this.fontFamilies;
    }

    public void addPages() {
        this.page0 = new FontPathPage();
        this.addPage((IWizardPage)this.page0);
    }

    public boolean performFinish() {
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(Messages.FontPathWizard_2, -1);
                    try {
                        File path = new File(FontPathWizard.this.page0.getValue());
                        if (path.exists()) {
                            FontImporter.analyzeFolder(FontPathWizard.this.fontFamilies, path, monitor);
                        } else {
                            new InterruptedException(String.format(Messages.FontPathWizard_3, path.getAbsolutePath()));
                        }
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            this.page0.setErrorMessage(e.getCause().getMessage());
            return false;
        }
        catch (InterruptedException e) {
            this.page0.setErrorMessage(e.getMessage());
            return false;
        }
        return true;
    }
}

