/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.preferences.fonts.utils;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.fonts.FontExtensionsCollector;
import net.sf.jasperreports.engine.fonts.FontExtensionsReceiver;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.engine.fonts.FontSet;
import net.sf.jasperreports.engine.fonts.SimpleFontExtensionHelper;
import net.sf.jasperreports.extensions.ExtensionsRegistry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class JSSFontExtensionRegistry
implements ExtensionsRegistry {
    private FontExtensionsCollector lst;
    private boolean fill = true;
    private PreferenceListener preferenceListener = new PreferenceListener();
    private JasperReportsContext jrContext;

    public JSSFontExtensionRegistry(JRPropertiesMap properties) {
        JaspersoftStudioPlugin.getInstance().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this.preferenceListener);
        this.setJrContext((JasperReportsContext)JasperReportsConfiguration.getDefaultInstance());
    }

    public void setJrContext(JasperReportsContext jrContext) {
        this.jrContext = jrContext;
    }

    public <T> List<T> getExtensions(Class<T> extensionType) {
        if (extensionType == FontFamily.class) {
            this.readFonts();
            if (!Misc.isNullOrEmpty((Collection)this.lst.getFontFamilies())) {
                return this.lst.getFontFamilies();
            }
        } else if (extensionType == FontSet.class) {
            this.readFonts();
            if (!Misc.isNullOrEmpty((Collection)this.lst.getFontSets())) {
                return this.lst.getFontSets();
            }
        }
        return null;
    }

    protected void readFonts() {
        if (this.fill) {
            this.lst = new FontExtensionsCollector();
            String strprop = this.jrContext.getProperty("FONT_LIST");
            if (strprop != null) {
                SimpleFontExtensionHelper.getInstance().loadFontExtensions(this.jrContext, (InputStream)new ByteArrayInputStream(strprop.getBytes()), (FontExtensionsReceiver)this.lst);
            }
            this.fill = false;
        }
    }

    private final class PreferenceListener
    implements IPropertyChangeListener {
        private PreferenceListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("FONT_LIST")) {
                JSSFontExtensionRegistry.this.fill = true;
            }
        }
    }
}

