/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.messages.MessagesByKeys;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.util.IIconDescriptor;
import com.jaspersoft.studio.properties.view.ITypeMapper;
import com.jaspersoft.studio.property.ElementTypeMapper;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;

public class ElementLabelProvider
extends LabelProvider {
    private ITypeMapper typeMapper = new ElementTypeMapper();

    public Image getImage(Object objects) {
        if (objects == null || objects.equals(StructuredSelection.EMPTY)) {
            return null;
        }
        boolean[] multiple = new boolean[1];
        Object object = this.getObject(objects, multiple);
        IIconDescriptor icon = null;
        if (object == null) {
            icon = MGraphicElement.getIconDescriptor();
        } else {
            ANode element = null;
            if (object instanceof EditPart) {
                element = (ANode)((EditPart)object).getModel();
            } else if (object instanceof ANode) {
                element = (ANode)object;
            }
            if (element != null) {
                try {
                    icon = (IIconDescriptor)element.getClass().getMethod("getIconDescriptor", new Class[0]).invoke(null, new Object[0]);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
            }
        }
        if (icon != null) {
            return JaspersoftStudioPlugin.getInstance().getImage(icon.getIcon16());
        }
        return null;
    }

    public String getText(Object objects) {
        if (objects == null || objects.equals(StructuredSelection.EMPTY)) {
            return Messages.ElementLabelProvider_no_items_selected;
        }
        boolean[] multiple = new boolean[1];
        Object object = this.getObject(objects, multiple);
        if (object == null || objects instanceof IStructuredSelection && ((IStructuredSelection)objects).size() > 1) {
            return String.valueOf(((IStructuredSelection)objects).size()) + " " + Messages.ElementLabelProvider_items_selected;
        }
        String name = this.typeMapper.mapType(object).getName();
        if (object instanceof EditPart) {
            ANode element = (ANode)((EditPart)object).getModel();
            if (element instanceof APropertyNode && ((APropertyNode)element).getCustomPropertyTitle() != null) {
                return ((APropertyNode)element).getCustomPropertyTitle();
            }
            String str = MessagesByKeys.getString(name.substring(name.lastIndexOf(46) + 2));
            String displayText = element.getDisplayText();
            if (displayText != null) {
                if ((displayText = displayText.replaceAll("(\\r|\\n)+", " ")).length() > 30) {
                    displayText = String.valueOf(displayText.substring(0, 30)) + "...";
                }
                return String.valueOf(str) + ": " + displayText;
            }
        }
        return MessagesByKeys.getString(name.substring(name.lastIndexOf(46) + 1));
    }

    private Object getObject(Object objects, boolean[] multiple) {
        Assert.isNotNull((Object)objects);
        Object object = null;
        if (objects instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)objects;
            object = selection.getFirstElement();
            if (selection.size() == 1) {
                multiple[0] = false;
                return object;
            }
            multiple[0] = true;
            Class firstClass = this.typeMapper.mapType(object);
            if (selection.size() > 1) {
                for (Object next : selection) {
                    Class nextClass = this.typeMapper.mapType(next);
                    if (nextClass.equals(firstClass)) continue;
                    multiple[0] = false;
                    object = null;
                    break;
                }
            }
        } else {
            multiple[0] = false;
            object = objects;
        }
        return object;
    }
}

