/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.property.CustomPropertySheetEntry;
import com.jaspersoft.studio.property.IJSSPropertySource;
import com.jaspersoft.studio.property.IRefreshableCellEditor;
import com.jaspersoft.studio.property.ISetValueCommandProvider;
import com.jaspersoft.studio.property.ResetEntryValueCommand;
import com.jaspersoft.studio.property.SetValueCommand;
import com.jaspersoft.studio.property.descriptor.checkbox.CheckBoxLabelProvider;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.ForwardUndoCompoundCommand;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySource;

public class JRPropertySheetEntry
extends CustomPropertySheetEntry {
    private PropertyChangeListener listener;
    private CommandStackListener commandStackListener;
    private ANode model;
    private CommandStack stack;
    private Object editValue;
    boolean isRefresh = false;

    public JRPropertySheetEntry(CommandStack stack, ANode model) {
        this(stack, model, true);
    }

    public JRPropertySheetEntry(CommandStack stack, ANode model, boolean addListener) {
        this.setCommandStack(stack, addListener);
        this.setModel(model);
    }

    @Override
    public IPropertyDescriptor getDescriptor() {
        return super.getDescriptor();
    }

    public void setModel(ANode model) {
        if (this.listener != null && this.model != null) {
            this.model.getPropertyChangeSupport().removePropertyChangeListener(this.listener);
        }
        if (model != null) {
            if (this.listener == null) {
                this.listener = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if (evt.getSource() instanceof IPropertySource) {
                            JRPropertySheetEntry.this.setValues(new Object[]{evt.getSource()});
                        }
                    }
                };
            }
            model.getPropertyChangeSupport().addPropertyChangeListener(this.listener);
        }
        this.model = model;
    }

    public ANode getModel() {
        return this.model;
    }

    @Override
    public void setValues(Object[] objects) {
        if (objects.length > 0) {
            if (objects[0] instanceof EditPart && ((EditPart)objects[0]).getModel() instanceof ANode) {
                this.setModel((ANode)((EditPart)objects[0]).getModel());
            }
        } else {
            this.setModel(null);
        }
        if (objects.length == 0) {
            this.editValue = null;
        } else {
            Object newValue = objects[0];
            IPropertySource source = this.getPropertySource(newValue);
            if (source != null) {
                newValue = source.getEditableValue();
            }
            this.editValue = newValue;
        }
        super.setValues(objects);
    }

    @Override
    protected JRPropertySheetEntry createChildEntry() {
        return new JRPropertySheetEntry(this.stack, this.model, false);
    }

    void setCommandStack(CommandStack stack, boolean addListener) {
        this.stack = stack;
        if (addListener) {
            if (this.commandStackListener != null) {
                stack.removeCommandStackListener(this.commandStackListener);
                this.commandStackListener = null;
            }
            this.commandStackListener = new CommandStackListener(){

                public void commandStackChanged(EventObject e) {
                    JRPropertySheetEntry.this.refreshFromRoot();
                }
            };
            stack.addCommandStackListener(this.commandStackListener);
        }
    }

    public CommandStack getCommandStack() {
        if (this.getParent() != null) {
            return ((JRPropertySheetEntry)this.getParent()).getCommandStack();
        }
        return this.stack;
    }

    @Override
    public void dispose() {
        if (this.stack != null) {
            this.stack.removeCommandStackListener(this.commandStackListener);
        }
        if (this.getModel() != null) {
            this.getModel().getPropertyChangeSupport().removePropertyChangeListener(this.listener);
        }
        super.dispose();
    }

    protected boolean resetPropertyValue(JSSCompoundCommand cc) {
        boolean change = false;
        if (this.getParent() != null) {
            Object[] objects = this.getParent().getValues();
            int i = 0;
            while (i < objects.length) {
                IJSSPropertySource sourceNode;
                IPropertySource source = this.getPropertySource(objects[i]);
                if (source.isPropertySet(this.getDescriptor().getId())) {
                    ResetEntryValueCommand restoreCmd = new ResetEntryValueCommand(this);
                    restoreCmd.setTarget(source);
                    restoreCmd.setPropertyId(this.getDescriptor().getId());
                    cc.add(restoreCmd);
                    cc.setReferenceNodeIfNull(source);
                    change = true;
                } else if (source instanceof IJSSPropertySource && (sourceNode = (IJSSPropertySource)source).forcePropertyChildrenReset(this.getDescriptor().getId())) {
                    IPropertySheetEntry[] iPropertySheetEntryArray = this.getChildEntries();
                    int n = iPropertySheetEntryArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPropertySheetEntry entry = iPropertySheetEntryArray[n2];
                        if (entry instanceof JRPropertySheetEntry) {
                            JRPropertySheetEntry jrEntry = (JRPropertySheetEntry)entry;
                            change = jrEntry.resetPropertyValue(cc) | change;
                        }
                        ++n2;
                    }
                }
                ++i;
            }
        }
        return change;
    }

    @Override
    public void resetPropertyValue() {
        JSSCompoundCommand cc;
        boolean change;
        Object[] objects = this.getParent().getValues();
        ANode node = null;
        if (objects != null) {
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof ANode) {
                    node = (ANode)object;
                    break;
                }
                ++n2;
            }
        }
        if (change = this.resetPropertyValue(cc = new JSSCompoundCommand(node))) {
            this.getCommandStack().execute((Command)cc);
            this.refreshFromRoot();
        }
    }

    @Override
    protected void valueChanged(CustomPropertySheetEntry child) {
        this.valueChanged((JRPropertySheetEntry)child, (CompoundCommand)new ForwardUndoCompoundCommand(), Arrays.asList(this.getValues()));
    }

    void valueChanged(JRPropertySheetEntry child, CompoundCommand command, List<?> selections) {
        if (!this.isRefresh && child.getValues().length > 0) {
            this.isRefresh = true;
            Object newval = child.getValues()[0];
            Object propid = child.getDescriptor().getId();
            ArrayList remainingSelection = new ArrayList(selections);
            for (Object obj : selections) {
                Object rawModel = null;
                if (obj instanceof EditPart) {
                    rawModel = ((EditPart)obj).getModel();
                } else if (obj instanceof ANode) {
                    rawModel = obj;
                }
                if (rawModel == null || !(rawModel instanceof APropertyNode)) continue;
                APropertyNode aNode = (APropertyNode)rawModel;
                IPropertySource propertySource = this.getPropertySource(aNode);
                Object oldval = aNode.getPropertyValue(propid);
                if (newval instanceof Command) {
                    command.add((Command)newval);
                    continue;
                }
                if (!(oldval instanceof INode) && (oldval != null && newval != null && oldval.equals(newval) || oldval == null && newval == null)) continue;
                ISetValueCommandProvider setCmdProvider = (ISetValueCommandProvider)aNode.getAdapter(ISetValueCommandProvider.class);
                if (setCmdProvider != null) {
                    command.add(setCmdProvider.getSetValueCommand(propertySource, child.getDisplayName(), propid, newval));
                } else {
                    SetValueCommand setCommand = new SetValueCommand(child.getDisplayName());
                    setCommand.setTarget(propertySource);
                    setCommand.setPropertyId(propid);
                    setCommand.setPropertyValue(newval);
                    command.add((Command)setCommand);
                }
                remainingSelection.remove(obj);
            }
            if (this.getParent() != null) {
                ((JRPropertySheetEntry)this.getParent()).valueChanged(this, command, remainingSelection);
                this.isRefresh = false;
            } else {
                this.stack.execute((Command)command);
                this.isRefresh = false;
            }
        }
    }

    @Override
    public String getValueAsString() {
        ILabelProvider provider = this.getDescriptor().getLabelProvider();
        if (provider instanceof CheckBoxLabelProvider) {
            return provider.getText(this.editValue);
        }
        if (provider == null) {
            return this.editValue.toString();
        }
        String text = provider.getText(this.editValue);
        if (text == null) {
            return "";
        }
        return text;
    }

    @Override
    protected void refreshCellEditor(CellEditor editor) {
        if (this.model != null && editor instanceof IRefreshableCellEditor) {
            ((IRefreshableCellEditor)editor).refresh(this.model);
        }
    }
}

