/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property;

import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import org.eclipse.gef.commands.Command;

public class SetPropertyValueCommand
extends Command {
    private JRPropertiesMap map;
    private String valueKey;
    private String newValue;
    private String oldValue;
    private boolean wasOldValuePresent = false;
    private JRPropertyChangeSupport pChangeSupport;

    public SetPropertyValueCommand(JRPropertiesMap map, String valueKey, String newValue) {
        this.map = map;
        this.valueKey = valueKey;
        this.newValue = newValue;
    }

    public SetPropertyValueCommand(JRPropertiesMap map, String valueKey, String newValue, JRPropertyChangeSupport pChangeSupport) {
        this(map, valueKey, newValue);
        this.pChangeSupport = pChangeSupport;
    }

    public void execute() {
        this.wasOldValuePresent = this.map.containsProperty(this.valueKey);
        this.oldValue = this.map.getProperty(this.valueKey);
        if (this.newValue == null) {
            this.map.removeProperty(this.valueKey);
        } else {
            this.map.setProperty(this.valueKey, this.newValue);
        }
        if (this.pChangeSupport != null) {
            this.pChangeSupport.firePropertyChange("PROPERTY_MAP", (Object)this.oldValue, (Object)this.newValue);
        }
    }

    public void undo() {
        if (!this.wasOldValuePresent) {
            this.map.removeProperty(this.valueKey);
        } else {
            this.map.setProperty(this.valueKey, this.oldValue);
        }
        if (this.pChangeSupport != null) {
            this.pChangeSupport.firePropertyChange("PROPERTY_MAP", (Object)this.newValue, (Object)this.oldValue);
        }
    }
}

