/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.utils.SelectionHelper;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.views.properties.IPropertySource;

public class SetValueCommand
extends Command {
    protected Object propertyValue;
    protected Object propertyName;
    protected Object undoValue;
    protected boolean resetOnUndo;
    protected IPropertySource target;
    private JSSCompoundCommand commands;
    private Object targetValue;

    public SetValueCommand() {
        super("");
    }

    public SetValueCommand(String propLabel) {
        super(MessageFormat.format(Messages.SetValueCommand_set_zero_property, propLabel).trim());
    }

    public boolean canExecute() {
        return true;
    }

    public IPropertySource getTarget() {
        ((ANode)this.target).setValue(this.targetValue);
        return this.target;
    }

    public void setTarget(IPropertySource aTarget) {
        this.target = aTarget;
        this.targetValue = ((ANode)aTarget).getValue();
    }

    public void setPropertyId(Object pName) {
        this.propertyName = pName;
    }

    public void setPropertyValue(Object val) {
        this.propertyValue = val;
    }

    public void execute() {
        this.undoValue = this.getTarget().getPropertyValue(this.propertyName);
        this.getTarget().setPropertyValue(this.propertyName, this.propertyValue);
        if (this.commands == null) {
            List<Command> commandsList = JaspersoftStudioPlugin.getPostSetValueManager().postSetValue(this.target, this.propertyName, this.propertyValue, this.undoValue);
            ANode startingNode = null;
            startingNode = this.target instanceof ANode ? (ANode)this.target : SelectionHelper.getOpenedRoot();
            this.commands = new JSSCompoundCommand(JSSCompoundCommand.getMainNode(startingNode));
            for (Command c : commandsList) {
                this.commands.add(c);
            }
        }
        if (this.commands != null) {
            this.commands.execute();
        }
    }

    public void undo() {
        if (this.commands != null) {
            this.commands.undo();
        }
        if (this.resetOnUndo) {
            this.getTarget().resetPropertyValue(this.propertyName);
        } else {
            this.getTarget().setPropertyValue(this.propertyName, this.undoValue);
        }
    }
}

