/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.color.chooser;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.property.color.chooser.AdvancedColorWidget;
import com.jaspersoft.studio.property.color.chooser.IColorProvider;
import com.jaspersoft.studio.property.color.chooser.LastUsedColorsWidget;
import com.jaspersoft.studio.property.color.chooser.WebColorsWidget;
import com.jaspersoft.studio.utils.AlfaRGB;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.PersistentLocationDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class ColorDialog
extends PersistentLocationDialog {
    public static int SHOW_ALL = 2;
    public static int SHOW_ADVANCED = 4;
    public static int SHOW_WEB = 6;
    public static int SHOW_HISTORY = 8;
    private String shellTitle = null;
    private AdvancedColorWidget advancedColors = null;
    private WebColorsWidget webColors = null;
    private LastUsedColorsWidget lastColors = null;
    private List<IColorProvider> colorsWidgets = new ArrayList<IColorProvider>();
    private TabFolder folder;
    private boolean hasAlpha = true;
    private int selectedTab = 0;
    private AlfaRGB oldColor = null;
    private int style;

    public ColorDialog(Shell parent) {
        super(parent);
        this.style = SHOW_ALL;
    }

    public ColorDialog(Shell parent, int style) {
        super(parent);
        this.style = style;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.shellTitle != null) {
            newShell.setText(this.shellTitle);
        }
        this.defheight = 500;
        this.defwidth = 600;
    }

    private void disposeControlsProvider() {
        for (IColorProvider provider : this.colorsWidgets) {
            provider.dispose();
        }
    }

    public AlfaRGB openAlfaRGB() {
        int returnCode = super.open();
        this.disposeControlsProvider();
        if (returnCode == 1) {
            return null;
        }
        AlfaRGB newColor = this.colorsWidgets.get(this.selectedTab).getSelectedColor();
        LastUsedColorsWidget.addColor(newColor);
        return newColor;
    }

    public RGB openRGB() {
        this.hasAlpha = false;
        int returnCode = super.open();
        this.disposeControlsProvider();
        if (returnCode == 1) {
            return null;
        }
        AlfaRGB newColor = this.colorsWidgets.get(this.selectedTab).getSelectedColor();
        LastUsedColorsWidget.addColor(newColor);
        return newColor != null ? newColor.getRgb() : null;
    }

    public void setText(String title) {
        this.shellTitle = title;
    }

    public void setRGB(RGB color) {
        if (color != null) {
            this.oldColor = new AlfaRGB(color, 255);
        }
    }

    public void setRGB(AlfaRGB color) {
        if (color != null) {
            this.oldColor = color;
        }
    }

    protected boolean isShowAdvanced() {
        return SHOW_ALL == this.style || SHOW_ADVANCED == this.style;
    }

    protected boolean isShowWeb() {
        return SHOW_ALL == this.style || SHOW_WEB == this.style;
    }

    protected boolean isShowHistory() {
        return SHOW_ALL == this.style || SHOW_HISTORY == this.style;
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        this.folder = new TabFolder(dialogArea, 0);
        this.folder.setLayoutData((Object)new GridData(1808));
        if (this.isShowAdvanced()) {
            this.advancedColors = new AdvancedColorWidget((Composite)this.folder, 0, this.oldColor, this.hasAlpha);
            this.advancedColors.setLayoutData(new GridData(1808));
            TabItem tab1 = new TabItem(this.folder, 0);
            tab1.setText(Messages.ColorDialog_advancedColorsLabel);
            tab1.setControl((Control)this.advancedColors);
            this.colorsWidgets.add(this.advancedColors);
        }
        if (this.isShowWeb()) {
            TabItem tab2 = new TabItem(this.folder, 0);
            tab2.setText(Messages.ColorDialog_webColorsLabel);
            this.webColors = new WebColorsWidget((Composite)this.folder, 0, this.oldColor);
            tab2.setControl((Control)this.webColors);
            this.colorsWidgets.add(this.webColors);
        }
        if (this.isShowHistory() && LastUsedColorsWidget.hasColors()) {
            this.lastColors = new LastUsedColorsWidget((Composite)this.folder, 0, this.oldColor);
            TabItem tab3 = new TabItem(this.folder, 0);
            tab3.setText(Messages.ColorDialog_lastUserdColorLabel);
            tab3.setControl((Control)this.lastColors);
            this.colorsWidgets.add(this.lastColors);
        }
        this.folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorDialog.this.selectedTab = ColorDialog.this.folder.getSelectionIndex();
            }
        });
        return this.folder;
    }
}

