/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.combomenu;

import com.jaspersoft.studio.help.HelpSystem;
import com.jaspersoft.studio.property.combomenu.ComboItem;
import com.jaspersoft.studio.property.combomenu.ComboItemAction;
import com.jaspersoft.studio.property.combomenu.ComboItemSeparator;
import com.jaspersoft.studio.property.combomenu.HelpProvider;
import com.jaspersoft.studio.property.combomenu.IMenuProvider;
import com.jaspersoft.studio.property.combomenu.SelectedComboItem;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.JSSTableCombo;
import net.sf.jasperreports.eclipse.ui.ValueChangedEvent;
import net.sf.jasperreports.eclipse.ui.ValueChangedListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class WritableComboTableViewer
implements IMenuProvider {
    private static final String ITEM_DATA = "itemData";
    public static final int NORMAL = 0;
    public static final int NO_TEXT = 1;
    public static final int NO_IMAGE = 2;
    private List<ComboItemAction> listeners;
    private JSSTableCombo dropDownHandle;
    private List<ComboItem> elementList = new ArrayList<ComboItem>();
    private SelectedComboItem selectedItem = null;
    private boolean disableSelectedItemEmphasis = false;
    private String longestName = null;

    public WritableComboTableViewer(Composite parent, int style) {
        this.dropDownHandle = new JSSTableCombo(parent, style){

            protected void setTableData(Table table) {
                WritableComboTableViewer.this.refreshTableItems(table);
            }

            protected int getTopItem(Table table) {
                return WritableComboTableViewer.this.computeTopItem(table);
            }

            protected String getLongestText() {
                return WritableComboTableViewer.this.computeLongestName();
            }
        };
        this.dropDownHandle.defineColumns(2);
        this.dropDownHandle.setDisplayColumnIndex(0);
        this.dropDownHandle.setShowTableHeader(false);
        this.listeners = new ArrayList<ComboItemAction>();
        this.dropDownHandle.addModifyListener(new ValueChangedListener(){

            public void valueChanged(ValueChangedEvent e) {
                if (e.isTyped()) {
                    WritableComboTableViewer.this.selectedItem = new SelectedComboItem(e.getText(), true, e.getText(), e.getText());
                } else {
                    ComboItem selectedItemData = (ComboItem)e.getSelectedItem().getData(WritableComboTableViewer.ITEM_DATA);
                    WritableComboTableViewer.this.selectedItem = new SelectedComboItem(e.getText(), false, selectedItemData.getItem(), selectedItemData.getValue());
                }
                for (ComboItemAction listener : WritableComboTableViewer.this.listeners) {
                    listener.exec();
                }
            }
        });
    }

    private void refreshTableItems(Table table) {
        table.removeAll();
        for (ComboItem item : this.elementList) {
            TableItem tableItem = new TableItem(table, 0);
            tableItem.setData(ITEM_DATA, (Object)item);
            if (item instanceof ComboItemSeparator) {
                tableItem.setText("______________");
                continue;
            }
            tableItem.setText(0, item.getText());
            tableItem.setImage(1, item.getImage());
        }
    }

    private String computeLongestName() {
        if (this.longestName == null) {
            this.longestName = "";
            for (ComboItem item : this.elementList) {
                if (item instanceof ComboItemSeparator) continue;
                String currentText = item.getText();
                if (this.longestName.length() >= currentText.length()) continue;
                this.longestName = currentText;
            }
        }
        return this.longestName;
    }

    private int computeTopItem(Table table) {
        int firstFullMatch = -1;
        int firstPartialMatch = -1;
        int index = 0;
        String text = this.dropDownHandle.getText().trim().toLowerCase();
        TableItem[] tableItemArray = table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            String itemText = item.getText().trim().toLowerCase();
            if (firstFullMatch == -1 && itemText.equals(text)) {
                firstFullMatch = index;
            }
            if (firstPartialMatch == -1 && itemText.startsWith(text)) {
                firstPartialMatch = index;
            }
            if (firstFullMatch != -1 && firstPartialMatch != -1) break;
            ++index;
            ++n2;
        }
        if (firstFullMatch != -1) {
            return firstFullMatch;
        }
        return firstPartialMatch;
    }

    public void disableSelectedEmphasis(boolean value) {
        this.disableSelectedItemEmphasis = value;
    }

    public void addSelectionListener(ComboItemAction listener) {
        this.listeners.add(listener);
    }

    public void setToolTipText(String text) {
        this.dropDownHandle.setToolTipText(text);
    }

    protected boolean hasNoElement() {
        return this.elementList.isEmpty();
    }

    protected int getItemCount() {
        return this.elementList.size();
    }

    public int getWidth() {
        return this.dropDownHandle.getSize().x;
    }

    public int getSelectionIndex() {
        if (this.hasNoElement()) {
            return 0;
        }
        return this.indexForElement(this.selectedItem);
    }

    public Object getSelectionValue() {
        if (this.hasNoElement()) {
            return null;
        }
        return this.getSelectedItem().getValue();
    }

    public ComboItem getItemAtPosition(int position) {
        return this.elementList.get(position);
    }

    public ComboItem getSelectedItem() {
        return this.selectedItem;
    }

    protected int indexForElement(ComboItem element) {
        return this.elementList.indexOf(element);
    }

    protected void inputChanged(Object input, Object oldInput) {
    }

    public Composite getControl() {
        return this.dropDownHandle;
    }

    public void setItems(List<ComboItem> newItems) {
        this.elementList = newItems;
        if (this.dropDownHandle.getTable() != null) {
            this.refreshTableItems(this.dropDownHandle.getTable());
        }
    }

    public void setHelp(String href) {
        HelpSystem.setHelp((Control)this.dropDownHandle, href);
        HelpProvider provider = new HelpProvider(this.dropDownHandle.getMenu());
        provider.setHelp(href);
    }

    protected void locatePopupMenu(Menu menu) {
        Rectangle r;
        if (this.getControl() instanceof Composite) {
            r = this.getControl().getClientArea();
        } else {
            r = this.getControl().getBounds();
            r.y = 0;
            r.x = 0;
        }
        Point loc = this.getControl().toDisplay(r.x, r.y);
        loc.y += r.height;
        menu.setLocation(loc);
    }

    protected void setSelectionToMenu(Menu menu) {
        if (!this.disableSelectedItemEmphasis) {
            int index = this.getSelectionIndex();
            if (menu != null && !menu.isDisposed()) {
                if (index < 0 || index >= menu.getItemCount()) {
                    menu.setDefaultItem(null);
                } else {
                    menu.setDefaultItem(menu.getItem(index));
                }
            }
        }
    }

    public void select(int index) {
        if (index >= 0 && index < this.elementList.size()) {
            ComboItem itemEntry = this.elementList.get(index);
            this.selectedItem = new SelectedComboItem(itemEntry.getText(), false, itemEntry.getItem(), itemEntry.getValue());
            this.dropDownHandle.setText(this.selectedItem.getText());
        }
    }

    public void select(ComboItem item) {
        this.dropDownHandle.setText(item.getText());
    }

    public void setText(String text) {
        this.dropDownHandle.setText(text);
    }

    protected void handleDispose(DisposeEvent event) {
        this.dropDownHandle.dispose();
    }

    public void setEnabled(boolean enabled) {
        this.dropDownHandle.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.dropDownHandle.isEnabled();
    }

    @Override
    public Menu getMenu() {
        return this.dropDownHandle.getMenu();
    }

    public void setData(Object data) {
        this.dropDownHandle.setData(data);
    }

    public void setData(String key, Object data) {
        this.dropDownHandle.setData(key, data);
    }

    public boolean isDisposed() {
        return this.dropDownHandle.isDisposed();
    }

    public String getText() {
        return this.dropDownHandle.getText();
    }

    public void setForeground(Color color) {
        this.dropDownHandle.setForeground(color);
    }

    public void setBackground(Color color) {
        this.dropDownHandle.setBackground(color);
    }

    public void setInherithed(boolean isInherited) {
        this.dropDownHandle.setInherithed(isInherited);
    }
}

