/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.dataset;

import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.editor.expression.IExpressionContextSetter;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.swt.events.ExpressionModifiedEvent;
import com.jaspersoft.studio.swt.events.ExpressionModifiedListener;
import com.jaspersoft.studio.swt.widgets.WTextExpression;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignDatasetRun;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class DatasetRunWidgetRadio
implements IExpressionContextSetter {
    protected JRDesignDatasetRun datasetrun;
    protected boolean ignoreUpdates = false;
    private boolean isReportConnection = false;
    private boolean isEmptyDatasource = false;
    private boolean isUseParentConnection = false;
    private boolean isUseConnectionExpression = false;
    private boolean isUseDatasourceExpression = false;
    private boolean isUseEmptyDatasource = false;
    private boolean isNoConnection = false;
    private Composite composite;
    private WTextExpression datasourceExpressionBox;
    private WTextExpression connectionExpressionBox;
    private Button radioUseParentConnection;
    private Button radioUseConnectionExpression;
    private Button radioUseDatasourceExpression;
    private Button radioUseEmptyDatasource;
    private Button radioNoConnection;
    private Listener listener;
    private ExpressionModifiedListener mlistener = new ExpressionModifiedListener(){

        @Override
        public void expressionModified(ExpressionModifiedEvent event) {
            if (DatasetRunWidgetRadio.this.connectionExpressionBox.isEnabled()) {
                JRDesignExpression exp = DatasetRunWidgetRadio.this.connectionExpressionBox.getExpression();
                if (exp != null) {
                    DatasetRunWidgetRadio.this.setConnection(exp.getText());
                } else {
                    DatasetRunWidgetRadio.this.setConnection(null);
                }
            } else {
                JRDesignExpression exp = DatasetRunWidgetRadio.this.datasourceExpressionBox.getExpression();
                if (exp != null) {
                    DatasetRunWidgetRadio.this.setDatasource(exp.getText());
                } else {
                    DatasetRunWidgetRadio.this.setDatasource(null);
                }
            }
        }
    };

    public DatasetRunWidgetRadio(Composite parent) {
        this.createControl(parent);
    }

    public void setData(JRDesignDatasetRun datasetrun) {
        this.datasetrun = datasetrun;
        this.removeListeners();
        this.isReportConnection = false;
        this.isEmptyDatasource = false;
        this.isUseParentConnection = false;
        this.isUseConnectionExpression = false;
        this.isUseDatasourceExpression = false;
        this.isUseEmptyDatasource = false;
        this.isNoConnection = false;
        if (datasetrun != null) {
            if (Misc.isNullOrEmpty((String)datasetrun.getDatasetName())) {
                this.isNoConnection = true;
            } else if (datasetrun.getConnectionExpression() != null) {
                this.isUseParentConnection = this.isReportConnection = datasetrun.getConnectionExpression().getText().equals("$P{REPORT_CONNECTION}");
                this.isUseConnectionExpression = !this.isReportConnection;
            } else if (datasetrun.getDataSourceExpression() != null) {
                this.isUseEmptyDatasource = this.isEmptyDatasource = datasetrun.getDataSourceExpression().getText().equals("new net.sf.jasperreports.engine.JREmptyDataSource()");
                this.isUseDatasourceExpression = !this.isEmptyDatasource;
            } else {
                this.isNoConnection = true;
            }
        } else {
            this.isNoConnection = true;
        }
        this.setEnabledWidgets();
        this.addListeners();
    }

    private void setEnabledWidgets() {
        DatasetRunWidgetRadio.setSelection4Widget(this.radioUseParentConnection, this.isUseParentConnection);
        DatasetRunWidgetRadio.setSelection4Widget(this.radioUseConnectionExpression, this.isUseConnectionExpression);
        DatasetRunWidgetRadio.setSelection4Widget(this.radioUseDatasourceExpression, this.isUseDatasourceExpression);
        DatasetRunWidgetRadio.setSelection4Widget(this.radioUseEmptyDatasource, this.isUseEmptyDatasource);
        DatasetRunWidgetRadio.setSelection4Widget(this.radioNoConnection, this.isNoConnection);
        DatasetRunWidgetRadio.setEnabled4Widget(this.connectionExpressionBox, this.isUseConnectionExpression);
        DatasetRunWidgetRadio.setEnabled4Widget(this.datasourceExpressionBox, this.isUseDatasourceExpression);
        if (this.isUseConnectionExpression || this.isUseParentConnection) {
            this.connectionExpressionBox.setExpression((JRDesignExpression)this.datasetrun.getConnectionExpression());
        } else {
            this.connectionExpressionBox.setExpression(null);
        }
        if (this.isUseDatasourceExpression || this.isUseEmptyDatasource) {
            this.datasourceExpressionBox.setExpression((JRDesignExpression)this.datasetrun.getDataSourceExpression());
        } else {
            this.datasourceExpressionBox.setExpression(null);
        }
    }

    private static void setEnabled4Widget(WTextExpression b, boolean value) {
        if (b.getEnabled() != value) {
            b.setEnabled(value);
        }
    }

    private static void setSelection4Widget(Button b, boolean value) {
        if (b.getSelection() != value) {
            b.setSelection(value);
        }
    }

    public Control getControl() {
        return this.composite;
    }

    public void setEnabled(boolean en) {
        this.composite.setEnabled(en);
        this.radioUseConnectionExpression.setEnabled(en);
        this.radioNoConnection.setEnabled(en);
        this.radioUseDatasourceExpression.setEnabled(en);
        this.radioUseEmptyDatasource.setEnabled(en);
        this.radioUseParentConnection.setEnabled(en);
    }

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new FormLayout());
        this.radioUseParentConnection = new Button(this.composite, 16);
        FormData fd_sameCon = new FormData();
        fd_sameCon.left = new FormAttachment(0, 10);
        fd_sameCon.top = new FormAttachment(0, 10);
        this.radioUseParentConnection.setLayoutData((Object)fd_sameCon);
        this.radioUseParentConnection.setText(Messages.WizardConnectionPage_mainreport_text);
        this.radioUseConnectionExpression = new Button(this.composite, 16);
        FormData fd_otherCon = new FormData();
        fd_otherCon.left = new FormAttachment(0, 10);
        fd_otherCon.top = new FormAttachment((Control)this.radioUseParentConnection, 6);
        this.radioUseConnectionExpression.setLayoutData((Object)fd_otherCon);
        this.radioUseConnectionExpression.setText(Messages.WizardConnectionPage_connection_text);
        this.connectionExpressionBox = new WTextExpression(this.composite, 0);
        FormData fd_otherExpr = new FormData();
        fd_otherExpr.bottom = new FormAttachment((Control)this.radioUseConnectionExpression, 69, 1024);
        fd_otherExpr.left = new FormAttachment(0, 10);
        fd_otherExpr.right = new FormAttachment(100, -5);
        fd_otherExpr.top = new FormAttachment((Control)this.radioUseConnectionExpression, 6);
        this.connectionExpressionBox.setLayoutData(fd_otherExpr);
        this.radioUseEmptyDatasource = new Button(this.composite, 16);
        FormData fd_emptyCon = new FormData();
        fd_emptyCon.left = new FormAttachment(0, 10);
        fd_emptyCon.top = new FormAttachment((Control)this.connectionExpressionBox, 6);
        this.radioUseEmptyDatasource.setLayoutData((Object)fd_emptyCon);
        this.radioUseEmptyDatasource.setText(Messages.WizardConnectionPage_empty_connection_text);
        this.radioUseDatasourceExpression = new Button(this.composite, 16);
        FormData fd_jrdCon = new FormData();
        fd_jrdCon.left = new FormAttachment(0, 10);
        fd_jrdCon.top = new FormAttachment((Control)this.radioUseEmptyDatasource, 6);
        this.radioUseDatasourceExpression.setLayoutData((Object)fd_jrdCon);
        this.radioUseDatasourceExpression.setText(Messages.WizardConnectionPage_datasource_text);
        this.datasourceExpressionBox = new WTextExpression(this.composite, 0);
        FormData fd_dsRunExpr = new FormData();
        fd_dsRunExpr.top = new FormAttachment((Control)this.radioUseDatasourceExpression, 6);
        fd_dsRunExpr.right = new FormAttachment((Control)this.connectionExpressionBox, 0, 131072);
        fd_dsRunExpr.left = new FormAttachment(0, 10);
        this.datasourceExpressionBox.setLayoutData(fd_dsRunExpr);
        this.radioNoConnection = new Button(this.composite, 16);
        FormData fd_noCon = new FormData();
        fd_noCon.left = new FormAttachment((Control)this.radioUseParentConnection, 0, 16384);
        fd_noCon.bottom = new FormAttachment(100, 0);
        this.radioNoConnection.setLayoutData((Object)fd_noCon);
        this.radioNoConnection.setText(Messages.WizardConnectionPage_noconnection_text);
        fd_dsRunExpr.bottom = new FormAttachment((Control)this.radioNoConnection, -6, 128);
        fd_dsRunExpr.height = 69;
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                if (DatasetRunWidgetRadio.this.radioNoConnection.getSelection()) {
                    DatasetRunWidgetRadio.this.setNoConnection();
                } else if (DatasetRunWidgetRadio.this.radioUseConnectionExpression.getSelection()) {
                    DatasetRunWidgetRadio.this.setConnection("$P{REPORT_CONNECTION} ");
                } else if (DatasetRunWidgetRadio.this.radioUseParentConnection.getSelection()) {
                    DatasetRunWidgetRadio.this.setConnection("$P{REPORT_CONNECTION}");
                } else if (DatasetRunWidgetRadio.this.radioUseDatasourceExpression.getSelection()) {
                    DatasetRunWidgetRadio.this.setDatasource("new net.sf.jasperreports.engine.JREmptyDataSource() ");
                } else if (DatasetRunWidgetRadio.this.radioUseEmptyDatasource.getSelection()) {
                    DatasetRunWidgetRadio.this.setDatasource("new net.sf.jasperreports.engine.JREmptyDataSource()");
                }
                DatasetRunWidgetRadio.this.connectionExpressionBox.setEnabled(DatasetRunWidgetRadio.this.radioUseConnectionExpression.getSelection());
                DatasetRunWidgetRadio.this.datasourceExpressionBox.setEnabled(DatasetRunWidgetRadio.this.radioUseDatasourceExpression.getSelection());
            }
        };
        this.addListeners();
        this.listener.handleEvent(new Event());
    }

    protected void removeListeners() {
        this.radioUseParentConnection.removeListener(13, this.listener);
        this.radioUseConnectionExpression.removeListener(13, this.listener);
        this.connectionExpressionBox.removeModifyListener(this.mlistener);
        this.radioUseDatasourceExpression.removeListener(13, this.listener);
        this.datasourceExpressionBox.removeModifyListener(this.mlistener);
        this.radioUseEmptyDatasource.removeListener(13, this.listener);
        this.radioNoConnection.removeListener(13, this.listener);
    }

    protected void addListeners() {
        this.radioUseParentConnection.addListener(13, this.listener);
        this.radioUseConnectionExpression.addListener(13, this.listener);
        this.connectionExpressionBox.addModifyListener(this.mlistener);
        this.radioUseDatasourceExpression.addListener(13, this.listener);
        this.datasourceExpressionBox.addModifyListener(this.mlistener);
        this.radioUseEmptyDatasource.addListener(13, this.listener);
        this.radioNoConnection.addListener(13, this.listener);
    }

    protected void setNoConnection() {
        if (this.datasetrun != null) {
            this.datasetrun.setConnectionExpression(null);
            this.datasetrun.setDataSourceExpression(null);
            this.removeListeners();
            this.connectionExpressionBox.setExpression(null);
            this.datasourceExpressionBox.setExpression(null);
            this.addListeners();
        }
    }

    protected void setDatasource(String exTxt) {
        if (this.datasetrun != null) {
            JRDesignExpression jde = (JRDesignExpression)this.datasetrun.getDataSourceExpression();
            if (jde == null) {
                jde = new JRDesignExpression();
            }
            jde.setText(exTxt);
            this.datasetrun.setConnectionExpression(null);
            this.datasetrun.setDataSourceExpression((JRExpression)jde);
            this.removeListeners();
            this.connectionExpressionBox.setExpression(null);
            this.datasourceExpressionBox.setExpression(jde);
            this.addListeners();
        }
    }

    protected void setConnection(String exTxt) {
        if (this.datasetrun != null) {
            JRDesignExpression jde = (JRDesignExpression)this.datasetrun.getConnectionExpression();
            if (jde == null) {
                jde = new JRDesignExpression();
            }
            jde.setText(exTxt);
            this.datasetrun.setConnectionExpression((JRExpression)jde);
            this.datasetrun.setDataSourceExpression(null);
            this.removeListeners();
            this.datasourceExpressionBox.setExpression(null);
            this.connectionExpressionBox.setExpression(jde);
            this.addListeners();
        }
    }

    @Override
    public void setExpressionContext(ExpressionContext expContext) {
        this.datasourceExpressionBox.setExpressionContext(expContext);
        this.connectionExpressionBox.setExpressionContext(expContext);
    }
}

