/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.dataset;

import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.DataAdapterManager;
import com.jaspersoft.studio.data.storage.ADataAdapterStorage;
import com.jaspersoft.studio.data.storage.JRDefaultDataAdapterStorage;
import com.jaspersoft.studio.property.metadata.PropertyMetadataRegistry;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.data.DataAdapter;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.properties.PropertiesMetadataUtil;
import net.sf.jasperreports.properties.PropertyMetadata;
import org.eclipse.core.resources.IFile;

public class DatasetUtil {
    private static DataAdapter da;
    private static Map<JasperReportsConfiguration, Map<String, PropertyMetadata>> pmap;

    static {
        pmap = new HashMap<JasperReportsConfiguration, Map<String, PropertyMetadata>>();
    }

    public static DataAdapter refreshDataAdapter(JasperDesign jDesign, JRDesignDataset dataset, JasperReportsConfiguration jConfig) {
        DataAdapterDescriptor defaultDA;
        String d = dataset.getPropertiesMap().getProperty("com.jaspersoft.studio.data.defaultdataadapter");
        if (d == null && dataset.isMainDataset()) {
            d = jDesign.getProperty("com.jaspersoft.studio.data.defaultdataadapter");
        }
        ADataAdapterStorage[] dastorages = DataAdapterManager.getDataAdapter((IFile)jConfig.get("ifile"), jConfig);
        if (d != null && dastorages != null) {
            ADataAdapterStorage[] aDataAdapterStorageArray = dastorages;
            int n = dastorages.length;
            int n2 = 0;
            while (n2 < n) {
                ADataAdapterStorage das = aDataAdapterStorageArray[n2];
                for (DataAdapterDescriptor dad : das.getDataAdapterDescriptors()) {
                    if (!dad.getName().equals(d)) continue;
                    da = dad.getDataAdapter();
                    DatasetUtil.refreshPropertiesMap(jConfig);
                    return da;
                }
                ++n2;
            }
        }
        JRDefaultDataAdapterStorage defaultStorage = DataAdapterManager.getJRDefaultStorage(jConfig);
        JRDesignDataset currentDataset = dataset;
        if (currentDataset != null && (defaultDA = defaultStorage.getDefaultJRDataAdapter(currentDataset)) != null) {
            da = defaultDA.getDataAdapter();
            DatasetUtil.refreshPropertiesMap(jConfig);
            return da;
        }
        da = null;
        DatasetUtil.refreshPropertiesMap(jConfig);
        return null;
    }

    public static Map<String, PropertyMetadata> getPmap(JasperReportsConfiguration jConfig) {
        return pmap.get((Object)jConfig);
    }

    public static void refreshPropertiesMap(JasperReportsConfiguration jConfig) {
        Map<String, PropertyMetadata> m = DatasetUtil.getPmap(jConfig);
        if (m == null) {
            m = new HashMap<String, PropertyMetadata>();
            pmap.put(jConfig, m);
        } else {
            m.clear();
        }
        if (da != null) {
            PropertiesMetadataUtil pmu = PropertiesMetadataUtil.getInstance((JasperReportsContext)jConfig);
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(JRLoader.class.getClassLoader());
                List props = pmu.getParameterProperties(da);
                for (PropertyMetadata pm : props) {
                    m.put(pm.getName(), pm);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCl);
            }
        }
        m.putAll(PropertyMetadataRegistry.getPropertiesMetadata());
    }

    public static void removeProperty(JRDesignDataset dataset, String p) {
        JRParameter[] jRParameterArray = dataset.getParameters();
        int n = jRParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            JRParameter prm = jRParameterArray[n2];
            if (!prm.isSystemDefined()) {
                prm.getPropertiesMap().removeProperty(p);
            }
            ++n2;
        }
    }

    public static DataAdapter getDataAdapter(JasperReportsConfiguration jConfig, JRDesignDataset ds) {
        String name;
        DataAdapter da = null;
        String dapath = ds.getPropertiesMap().getProperty("net.sf.jasperreports.data.adapter");
        if (!Misc.isNullOrEmpty((String)dapath)) {
            ADataAdapterStorage[] das;
            ADataAdapterStorage[] aDataAdapterStorageArray = das = DataAdapterManager.getDataAdapter((IFile)jConfig.get("ifile"), jConfig);
            int n = das.length;
            int n2 = 0;
            while (n2 < n) {
                ADataAdapterStorage s = aDataAdapterStorageArray[n2];
                for (DataAdapterDescriptor dad : s.getDataAdapterDescriptors()) {
                    if (!s.getUrl(dad).equals(dapath)) continue;
                    da = dad.getDataAdapter();
                    break;
                }
                if (da != null) break;
                ++n2;
            }
        }
        if (da == null && !Misc.isNullOrEmpty((String)(name = ds.getPropertiesMap().getProperty("com.jaspersoft.studio.data.defaultdataadapter")))) {
            JRDefaultDataAdapterStorage storage = DataAdapterManager.getJRDefaultStorage(jConfig);
            for (DataAdapterDescriptor dad : ((ADataAdapterStorage)storage).getDataAdapterDescriptors()) {
                if (!dad.getDataAdapter().getName().equals(name)) continue;
                da = dad.getDataAdapter();
                break;
            }
        }
        return da;
    }
}

