/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.dataset.da;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.parameter.MParameter;
import com.jaspersoft.studio.property.dataset.da.HttpParameterDialog;
import com.jaspersoft.studio.property.dataset.da.IDataAdapterQueryEditorUI;
import com.jaspersoft.studio.property.dataset.da.widgets.ParameterPropertyWidget;
import com.jaspersoft.studio.property.dataset.fields.table.TColumn;
import com.jaspersoft.studio.property.dataset.fields.table.TColumnFactory;
import com.jaspersoft.studio.property.dataset.fields.table.column.PropertyColumnSupport;
import com.jaspersoft.studio.property.descriptor.EditableDialogCellEditor;
import com.jaspersoft.studio.swt.widgets.table.DeleteButton;
import com.jaspersoft.studio.swt.widgets.table.ListContentProvider;
import com.jaspersoft.studio.swt.widgets.table.NewButton;
import com.jaspersoft.studio.utils.UIUtil;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.data.http.HttpDataLocation;
import net.sf.jasperreports.data.http.HttpLocationParameter;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.events.CollectionElementAddedEvent;
import net.sf.jasperreports.engine.design.events.CollectionElementRemovedEvent;
import net.sf.jasperreports.engine.type.ParameterEvaluationTimeEnum;
import net.sf.jasperreports.engine.util.JRClassLoader;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public abstract class ADataAdapterQueryEditorUI
implements IDataAdapterQueryEditorUI {
    protected boolean refresh = false;
    protected List<PropertiesTable> pTables = new ArrayList<PropertiesTable>();
    protected List<ParameterPropertyWidget> ppwTable = new ArrayList<ParameterPropertyWidget>();
    private PropertyChangeListener listener = evt -> {
        if (this.refresh) {
            return;
        }
        for (PropertiesTable pt : this.pTables) {
            pt.refresh();
        }
        for (ParameterPropertyWidget ppw : this.ppwTable) {
            ppw.refresh();
        }
    };
    protected JRDesignDataset dataset;
    protected HttpDataLocation dloc;
    protected Image icon;

    public boolean isRefresh() {
        return this.refresh;
    }

    public void setRefresh(boolean refresh) {
        this.refresh = refresh;
    }

    public Composite createPropertiesTable(Composite parent, List<HttpLocationParameter> lparams, String pname) {
        PropertiesTable pt = new PropertiesTable();
        this.pTables.add(pt);
        ArrayList<HttpLocationParameter> prms = new ArrayList<HttpLocationParameter>();
        if (lparams != null) {
            prms.addAll(lparams);
        }
        return pt.create(parent, prms, pname);
    }

    public void createPropertyWidget(String p, Composite parent, String daValue, int width, JasperReportsConfiguration jConfig) {
        ParameterPropertyWidget ppw = TColumnFactory.createParameterPropertyWidget(p, parent, this.icon, daValue, this.dataset, width, jConfig);
        if (ppw != null) {
            this.ppwTable.add(ppw);
        }
    }

    public void listenDataset(JRDesignDataset dataset) {
        dataset.getEventSupport().addPropertyChangeListener(evt -> {
            if (evt.getPropertyName().equals("parameters")) {
                if (evt instanceof CollectionElementRemovedEvent) {
                    JRDesignParameter prm = (JRDesignParameter)evt.getOldValue();
                    prm.getEventSupport().removePropertyChangeListener(this.listener);
                    prm.getPropertiesMap().getEventSupport().removePropertyChangeListener(this.listener);
                } else if (evt instanceof CollectionElementAddedEvent) {
                    JRDesignParameter prm = (JRDesignParameter)evt.getNewValue();
                    prm.getEventSupport().addPropertyChangeListener(this.listener);
                    prm.getPropertiesMap().getEventSupport().addPropertyChangeListener(this.listener);
                }
                this.listener.propertyChange(evt);
            }
        });
        for (JRParameter p : dataset.getParametersList()) {
            ((JRDesignParameter)p).getPropertiesMap().getEventSupport().addPropertyChangeListener(this.listener);
        }
    }

    class PropertiesTable {
        private List<HttpLocationParameter> input;
        private Map<String, JRParameter> fParam;
        private TableViewer tviewer;
        private List<HttpLocationParameter> lparams;
        private String pname;

        PropertiesTable() {
        }

        public Composite create(Composite parent, final List<HttpLocationParameter> lparams, final String pname) {
            this.lparams = lparams;
            this.pname = pname;
            Composite sectionClient = new Composite(parent, 0);
            sectionClient.setLayout((Layout)new GridLayout(3, false));
            sectionClient.setBackgroundMode(2);
            this.tviewer = new TableViewer(sectionClient, 68098);
            this.tviewer.setContentProvider((IContentProvider)new ListContentProvider());
            UIUtil.setViewerCellEditingOnDblClick(this.tviewer);
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tviewer, (int)2);
            GridData gd = new GridData(1808);
            gd.widthHint = 100;
            this.tviewer.getTable().setLayoutData((Object)gd);
            this.tviewer.getTable().setHeaderVisible(true);
            this.tviewer.getTable().setLinesVisible(true);
            this.tviewer.getTable().setLayout((Layout)new TableLayout());
            TColumn c = new TColumn();
            c.setPropertyName("name");
            c.setLabel(Messages.ParametersTable_name);
            TColumnFactory.addColumn(c, this.tviewer, new PropertyColumnSupport((ColumnViewer)this.tviewer, c){

                @Override
                protected boolean canEdit(Object element) {
                    HttpLocationParameter hlp = (HttpLocationParameter)element;
                    for (HttpLocationParameter p : lparams) {
                        if (!p.getName().equals(hlp.getName())) continue;
                        return false;
                    }
                    return super.canEdit(element);
                }

                @Override
                protected void setValue(Object element, Object value) {
                    HttpLocationParameter hlp = (HttpLocationParameter)element;
                    JRDesignParameter p = (JRDesignParameter)PropertiesTable.this.fParam.get(hlp.getName());
                    if (p != null) {
                        String v = (String)value;
                        String error = null;
                        if (Misc.isNullOrEmpty((String)v)) {
                            error = "Name can't be empty";
                        } else {
                            for (HttpLocationParameter item : PropertiesTable.this.input) {
                                if (!item.getName().equals(v)) continue;
                                error = "This name is already used";
                                break;
                            }
                        }
                        if (error == null) {
                            PropertiesTable.this.fParam.remove(hlp.getName());
                            PropertiesTable.this.fParam.put(v, (JRParameter)p);
                            try {
                                ((PropertiesTable)PropertiesTable.this).ADataAdapterQueryEditorUI.this.refresh = true;
                                p.getPropertiesMap().setProperty(pname, (String)value);
                            }
                            finally {
                                ((PropertiesTable)PropertiesTable.this).ADataAdapterQueryEditorUI.this.refresh = false;
                            }
                            hlp.setName(v);
                            this.viewer.update(element, null);
                        } else {
                            UIUtils.showWarning((String)error);
                        }
                    }
                }
            });
            c = new TColumn();
            c.setPropertyName("value");
            c.setLabel("Value");
            TColumnFactory.addColumn(c, this.tviewer, new PropertyColumnSupport((ColumnViewer)this.tviewer, c){

                @Override
                protected CellEditor getCellEditor(Object element) {
                    return new PropertyValueCellEditor((Composite)PropertiesTable.this.tviewer.getTable(), pname, lparams, PropertiesTable.this.fParam, this.c, PropertiesTable.this.tviewer);
                }

                @Override
                protected void setValue(Object element, Object value) {
                    if (value instanceof HttpLocationParameter) {
                        System.out.println(element);
                    } else {
                        super.setValue(element, value);
                    }
                }

                @Override
                protected Object getValue(Object element) {
                    return element;
                }

                @Override
                public String getText(Object element) {
                    HttpLocationParameter hlp = (HttpLocationParameter)element;
                    JRParameter prm = PropertiesTable.this.fParam.get(hlp.getName());
                    if (prm != null) {
                        return prm.getName();
                    }
                    for (HttpLocationParameter p : lparams) {
                        if (!p.getName().equals(hlp.getName())) continue;
                        return Misc.nvl((Object)p.getValue(), (String)"");
                    }
                    return "";
                }

                @Override
                public Image getImage(Object element) {
                    HttpLocationParameter hlp = (HttpLocationParameter)element;
                    JRParameter prm = PropertiesTable.this.fParam.get(hlp.getName());
                    if (prm != null) {
                        return JaspersoftStudioPlugin.getInstance().getImage(MParameter.getIconDescriptor().getIcon16());
                    }
                    for (HttpLocationParameter p : lparams) {
                        if (!p.getName().equals(hlp.getName())) continue;
                        return ((PropertiesTable)PropertiesTable.this).ADataAdapterQueryEditorUI.this.icon;
                    }
                    return JaspersoftStudioPlugin.getInstance().getImage(MParameter.getIconDescriptor().getIcon16());
                }
            });
            Composite bGroup = new Composite(sectionClient, 0);
            bGroup.setLayout((Layout)new GridLayout(1, false));
            bGroup.setLayoutData((Object)new GridData(1040));
            bGroup.setBackgroundMode(2);
            new NewButton().createNewButtons(bGroup, this.tviewer, (in, pos) -> {
                HttpParameterDialog d = new HttpParameterDialog(parent.getShell(), ADataAdapterQueryEditorUI.this.dataset, this.input, pname);
                if (d.open() == 0) {
                    this.fParam.put(d.getName(), (JRParameter)d.getPrm());
                    try {
                        ADataAdapterQueryEditorUI.this.refresh = true;
                        d.getPrm().getPropertiesMap().setProperty(pname, d.getName());
                    }
                    finally {
                        ADataAdapterQueryEditorUI.this.refresh = false;
                    }
                    return new HttpLocationParameter(d.getName(), null);
                }
                return null;
            });
            new DeleteButton(){

                @Override
                protected void afterElementDeleted(Object element) {
                    PropertiesTable.this.input.remove(element);
                    JRDesignParameter p = (JRDesignParameter)PropertiesTable.this.fParam.get(((HttpLocationParameter)element).getName());
                    if (p != null) {
                        try {
                            ((PropertiesTable)PropertiesTable.this).ADataAdapterQueryEditorUI.this.refresh = true;
                            p.getPropertiesMap().removeProperty(pname);
                        }
                        finally {
                            ((PropertiesTable)PropertiesTable.this).ADataAdapterQueryEditorUI.this.refresh = false;
                        }
                    }
                    PropertiesTable.this.fParam.remove(((HttpLocationParameter)element).getName());
                }

                @Override
                protected boolean canRemove(Object obj) {
                    return !lparams.contains(obj);
                }
            }.createDeleteButton(bGroup, this.tviewer);
            this.refresh();
            return sectionClient;
        }

        public void refresh() {
            this.input = new ArrayList<HttpLocationParameter>(this.lparams);
            this.fParam = new HashMap<String, JRParameter>();
            for (JRParameter p : ADataAdapterQueryEditorUI.this.dataset.getParametersList()) {
                if (p.isSystemDefined() || !p.getPropertiesMap().containsProperty(this.pname)) continue;
                String pp = p.getPropertiesMap().getProperty(this.pname);
                this.fParam.put(pp, p);
                boolean exists = false;
                for (HttpLocationParameter hlp : this.lparams) {
                    if (!hlp.getName().equals(pp)) continue;
                    exists = true;
                    break;
                }
                if (exists) continue;
                this.input.add(new HttpLocationParameter(pp, null));
            }
            if (!this.tviewer.getControl().isDisposed()) {
                this.tviewer.setInput(this.input);
            }
        }
    }

    private class PropertyValueCellEditor
    extends EditableDialogCellEditor {
        private String pname;
        private Map<String, JRParameter> fParam;
        private TColumn c;
        private List<HttpLocationParameter> lparams;
        public TableViewer tviewer;

        public PropertyValueCellEditor(Composite parent, String pname, List<HttpLocationParameter> lparams, Map<String, JRParameter> fParam, TColumn c, TableViewer tviewer) {
            super(parent);
            this.pname = pname;
            this.fParam = fParam;
            this.lparams = lparams;
            this.tviewer = tviewer;
            this.c = c;
        }

        @Override
        protected Control createControl(Composite parent) {
            final Composite cmp = (Composite)super.createControl(parent);
            this.getDefaultLabel().addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    PropertyValueCellEditor.this.openDialogBox((Control)cmp);
                }
            });
            return cmp;
        }

        protected Object openDialogBox(Control cellEditorWindow) {
            Menu menu = new Menu((Decorations)cellEditorWindow.getShell(), 8);
            final HttpLocationParameter v = (HttpLocationParameter)this.getValue();
            if (this.lparams.contains(v)) {
                MenuItem mid = new MenuItem(menu, 8);
                mid.setText(Misc.nvl((Object)v.getValue(), (String)"< NULL >"));
                mid.setImage(ADataAdapterQueryEditorUI.this.icon);
                mid.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        JRParameter[] jRParameterArray = ((PropertyValueCellEditor)PropertyValueCellEditor.this).ADataAdapterQueryEditorUI.this.dataset.getParameters();
                        int n = jRParameterArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            JRParameter prm = jRParameterArray[n2];
                            if (!prm.isSystemDefined()) {
                                try {
                                    ((PropertyValueCellEditor)PropertyValueCellEditor.this).ADataAdapterQueryEditorUI.this.refresh = true;
                                    prm.getPropertiesMap().removeProperty(PropertyValueCellEditor.this.pname);
                                }
                                finally {
                                    ((PropertyValueCellEditor)PropertyValueCellEditor.this).ADataAdapterQueryEditorUI.this.refresh = false;
                                }
                            }
                            ++n2;
                        }
                        PropertyValueCellEditor.this.fParam.remove(v.getName());
                        PropertyValueCellEditor.this.tviewer.refresh();
                    }
                });
                new MenuItem(menu, 2);
            }
            JRParameter[] jRParameterArray = ADataAdapterQueryEditorUI.this.dataset.getParameters();
            int n = jRParameterArray.length;
            int n2 = 0;
            while (n2 < n) {
                block8: {
                    final JRParameter p = jRParameterArray[n2];
                    if (!p.isSystemDefined()) {
                        block7: {
                            String cn = JRClassLoader.getClassRealName((String)this.c.getPropertyType());
                            try {
                                if (p.getValueClass().isAssignableFrom(JRClassLoader.loadClassForName((String)cn))) break block7;
                                break block8;
                            }
                            catch (ClassNotFoundException e) {
                                e.printStackTrace();
                            }
                        }
                        if (!this.fParam.values().contains(p)) {
                            MenuItem mi = new MenuItem(menu, 8);
                            mi.setText(p.getName());
                            mi.setImage(JaspersoftStudioPlugin.getInstance().getImage(MParameter.getIconDescriptor().getIcon16()));
                            String def = p.getDefaultValueExpression() != null ? p.getDefaultValueExpression().getText() : null;
                            String tt = "Default: " + (def == null ? "" : "null");
                            if (!Misc.isNullOrEmpty((String)p.getDescription())) {
                                tt = String.valueOf(tt) + "\n\n" + p.getDescription();
                            }
                            UIUtil.safeApplyMenuItemTooltip(mi, tt);
                            p.getPropertiesMap().getEventSupport();
                            mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                public void widgetSelected(SelectionEvent e) {
                                    try {
                                        ((PropertyValueCellEditor)PropertyValueCellEditor.this).ADataAdapterQueryEditorUI.this.refresh = true;
                                        JRParameter[] jRParameterArray = ((PropertyValueCellEditor)PropertyValueCellEditor.this).ADataAdapterQueryEditorUI.this.dataset.getParameters();
                                        int n = jRParameterArray.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            JRParameter prm = jRParameterArray[n2];
                                            if (!prm.isSystemDefined()) {
                                                prm.getPropertiesMap().removeProperty(v.getName());
                                            }
                                            ++n2;
                                        }
                                        PropertyValueCellEditor.this.fParam.put(v.getName(), p);
                                        p.getPropertiesMap().setProperty(PropertyValueCellEditor.this.pname, v.getName());
                                        ((JRDesignParameter)p).setEvaluationTime(ParameterEvaluationTimeEnum.EARLY);
                                    }
                                    finally {
                                        ((PropertyValueCellEditor)PropertyValueCellEditor.this).ADataAdapterQueryEditorUI.this.refresh = false;
                                    }
                                    PropertyValueCellEditor.this.tviewer.refresh();
                                }
                            });
                        }
                    }
                }
                ++n2;
            }
            Rectangle bounds = this.getDefaultLabel().getBounds();
            Point point = this.getDefaultLabel().toDisplay(bounds.x, bounds.y + bounds.height);
            menu.setLocation(point);
            menu.setVisible(true);
            return null;
        }

        protected void updateContents(Object value) {
            Label dl = this.getDefaultLabel();
            if (dl == null) {
                return;
            }
            if (value instanceof HttpLocationParameter) {
                HttpLocationParameter hdl = (HttpLocationParameter)value;
                JRParameter p = this.fParam.get(hdl.getName());
                if (p != null) {
                    dl.setText(Misc.nvl((Object)p.getName(), (String)""));
                } else {
                    dl.setText(Misc.nvl((Object)hdl.getValue(), (String)""));
                }
            } else {
                dl.setText(Misc.nvl((Object)value, (String)""));
            }
        }
    }
}

