/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.dataset.dialog;

import com.jaspersoft.studio.editor.AbstractJRXMLEditor;
import com.jaspersoft.studio.editor.report.AbstractVisualEditor;
import com.jaspersoft.studio.editor.report.ReportEditor;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MPage;
import com.jaspersoft.studio.model.MReport;
import com.jaspersoft.studio.model.dataset.MDataset;
import com.jaspersoft.studio.property.dataset.dialog.DatasetDialog;
import com.jaspersoft.studio.utils.SelectionHelper;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.wb.swt.ResourceManager;

public class DatasetAction
extends SelectionAction {
    public static final String ID = "datasetAction";
    private IWorkbenchPart part;
    private static boolean dialogExists = false;

    public DatasetAction(IWorkbenchPart part) {
        super(part);
        this.setLazyEnablementCalculation(false);
        this.part = part;
    }

    protected void init() {
        super.init();
        this.setText(Messages.DatasetAction_Title);
        this.setToolTipText(Messages.DatasetAction_Tooltip);
        this.setImageDescriptor(ResourceManager.getPluginImageDescriptor((String)"com.jaspersoft.studio", (String)"icons/resources/dataset-16.png"));
        this.setId(ID);
        this.setEnabled(false);
    }

    public void run() {
        if (dialogExists) {
            return;
        }
        dialogExists = true;
        IEditorPart editor = this.part.getSite().getPage().getActiveEditor();
        boolean old = true;
        try {
            try {
                MDataset mdataset = this.getMDatasetToShow();
                if (mdataset != null) {
                    if (editor instanceof AbstractJRXMLEditor) {
                        old = ((AbstractJRXMLEditor)editor).isPartActivated();
                        ((AbstractJRXMLEditor)editor).setPartActivated(false);
                    }
                    new DatasetDialog(UIUtils.getShell(), mdataset, mdataset.getJasperConfiguration(), this.getCommandStack()).open();
                }
            }
            catch (Exception e) {
                UIUtils.showError((String)Messages.DatasetAction_ErrorMsg, (Throwable)e);
                dialogExists = false;
                if (editor instanceof AbstractJRXMLEditor) {
                    ((AbstractJRXMLEditor)editor).setPartActivated(old);
                }
            }
        }
        finally {
            dialogExists = false;
            if (editor instanceof AbstractJRXMLEditor) {
                ((AbstractJRXMLEditor)editor).setPartActivated(old);
            }
        }
    }

    protected MDataset getMDatasetToShow() {
        ANode mroot;
        IEditorPart activeJRXMLEditor;
        INode firstChild;
        Object firstElement;
        AbstractVisualEditor part = (AbstractVisualEditor)this.getWorkbenchPart();
        part.getAdapter(IContentOutlinePage.class);
        ISelection selection = part.getOutlineSelection();
        if (selection.isEmpty()) {
            selection = this.getSelection();
        }
        if (selection instanceof IStructuredSelection && (firstElement = ((IStructuredSelection)selection).getFirstElement()) instanceof EditPart && ((EditPart)firstElement).getModel() instanceof ANode) {
            ANode currentNode = (ANode)((EditPart)firstElement).getModel();
            while (currentNode != null) {
                if (currentNode instanceof MDataset) {
                    return (MDataset)currentNode;
                }
                currentNode = currentNode.getParent();
            }
        }
        if (part.getModel() != null && !part.getModel().getChildren().isEmpty() && part instanceof ReportEditor) {
            MReport mreport = (MReport)part.getModel().getChildren().get(0);
            return (MDataset)mreport.getPropertyValue("mainDataset");
        }
        if (part.getModel() != null && !part.getModel().getChildren().isEmpty() && (firstChild = part.getModel().getChildren().get(0)) instanceof MPage) {
            for (INode c : firstChild.getChildren()) {
                if (!(c instanceof MDataset)) continue;
                return (MDataset)c;
            }
        }
        if ((activeJRXMLEditor = SelectionHelper.getActiveJRXMLEditor()) != null && activeJRXMLEditor instanceof AbstractJRXMLEditor && (mroot = (ANode)((AbstractJRXMLEditor)activeJRXMLEditor).getModel()) != null) {
            ANode mreport = (ANode)mroot.getChildren().get(0);
            return (MDataset)((MReport)mreport).getPropertyValue("mainDataset");
        }
        return null;
    }

    protected boolean calculateEnabled() {
        return true;
    }
}

