/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.dataset.dialog;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.IDataPreviewInfoProvider;
import com.jaspersoft.studio.data.IFieldSetter;
import com.jaspersoft.studio.data.designer.QueryStatus;
import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.MQuery;
import com.jaspersoft.studio.model.MReport;
import com.jaspersoft.studio.model.MRoot;
import com.jaspersoft.studio.model.dataset.MDataset;
import com.jaspersoft.studio.model.field.MField;
import com.jaspersoft.studio.model.field.command.CreateFieldCommand;
import com.jaspersoft.studio.model.field.command.DeleteFieldCommand;
import com.jaspersoft.studio.model.field.command.ReplaceAllFieldsCommand;
import com.jaspersoft.studio.model.parameter.MParameter;
import com.jaspersoft.studio.model.parameter.MParameterSystem;
import com.jaspersoft.studio.model.parameter.MParameters;
import com.jaspersoft.studio.model.parameter.command.CreateParameterCommand;
import com.jaspersoft.studio.model.parameter.command.DeleteParameterCommand;
import com.jaspersoft.studio.model.parameter.command.ReplaceAllParametersCommand;
import com.jaspersoft.studio.model.sortfield.command.ReplaceAllSortFieldsCommand;
import com.jaspersoft.studio.property.SetValueCommand;
import com.jaspersoft.studio.property.dataset.dialog.DataQueryAdapters;
import com.jaspersoft.studio.property.dataset.fields.FieldsTable;
import com.jaspersoft.studio.property.dataset.preview.DataPreviewTable;
import com.jaspersoft.studio.property.dataset.prm.ParametersTable;
import com.jaspersoft.studio.property.dataset.sort.SortFieldsTable;
import com.jaspersoft.studio.swt.events.ExpressionModifiedEvent;
import com.jaspersoft.studio.swt.events.ExpressionModifiedListener;
import com.jaspersoft.studio.swt.widgets.CSashForm;
import com.jaspersoft.studio.swt.widgets.WTextExpression;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.wizards.ContextHelpIDs;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.ui.util.PersistentLocationFormDialog;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import net.sf.jasperreports.engine.design.JRDesignSortField;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.IPropertySource;

public class DatasetDialog
extends PersistentLocationFormDialog
implements IFieldSetter,
IDataPreviewInfoProvider {
    private static boolean INITIAL_JDBCMETADATA_LOADING = true;
    private MDataset mdataset;
    private JasperReportsConfiguration jConfig;
    private Map<JRField, JRField> mapfields;
    private Map<JRParameter, JRParameter> mapparam;
    private CommandStack cmdStack;
    private JRDesignDataset newdataset;
    private FieldsTable ftable;
    private ParametersTable ptable;
    private SortFieldsTable sftable;
    private DataQueryAdapters dataquery;
    private WTextExpression filterExpression;
    private DataPreviewTable dataPreviewTable;
    private Composite body;
    private JSSCompoundCommand command;
    private Color background;
    private PropertyChangeListener prmListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent arg0) {
            MRoot mroot = new MRoot(null, null);
            mroot.setJasperConfiguration(DatasetDialog.this.jConfig);
            MReport mrep = new MReport((ANode)mroot, DatasetDialog.this.jConfig);
            MDataset mdts = new MDataset((ANode)mrep, DatasetDialog.this.newdataset, -1);
            MParameters<JRDesignDataset> mprms = new MParameters<JRDesignDataset>((ANode)mdts, DatasetDialog.this.newdataset, "parameters");
            MParameter mprm = new MParameter((ANode)mprms, (JRDesignParameter)arg0.getSource(), -1);
            List<Command> cmds = JaspersoftStudioPlugin.getPostSetValueManager().postSetValue(mprm, "name", arg0.getNewValue(), arg0.getOldValue());
            for (Command c : cmds) {
                c.execute();
            }
            DatasetDialog.this.dataquery.setDataset(DatasetDialog.this.jConfig.getJasperDesign(), DatasetDialog.this.newdataset);
        }
    };
    private CSashForm sf;

    public DatasetDialog(Shell shell, MDataset mdataset, JasperReportsConfiguration jConfig, CommandStack cmdStack) {
        super(shell);
        INITIAL_JDBCMETADATA_LOADING = true;
        this.cmdStack = cmdStack;
        this.mdataset = mdataset;
        this.jConfig = jConfig;
        this.newdataset = (JRDesignDataset)mdataset.getValue().clone();
        this.mapfields = new HashMap<JRField, JRField>();
        List newFieldsList = this.newdataset.getFieldsList();
        List oldFieldsList = mdataset.getValue().getFieldsList();
        int i = 0;
        while (i < oldFieldsList.size()) {
            this.mapfields.put((JRField)oldFieldsList.get(i), (JRField)newFieldsList.get(i));
            ++i;
        }
        this.mapparam = new HashMap<JRParameter, JRParameter>();
        List newParamList = this.newdataset.getParametersList();
        List oldParamList = mdataset.getValue().getParametersList();
        int i2 = 0;
        while (i2 < oldParamList.size()) {
            this.mapparam.put((JRParameter)oldParamList.get(i2), (JRParameter)newParamList.get(i2));
            ++i2;
        }
    }

    public static boolean isInitialJDBCMetadataLoading() {
        return INITIAL_JDBCMETADATA_LOADING;
    }

    public static void initialJDBCMetadataPerformed() {
        INITIAL_JDBCMETADATA_LOADING = false;
    }

    protected boolean canHandleShellCloseEvent() {
        this.createCommand();
        if (!this.command.canExecute()) {
            return true;
        }
        return UIUtils.showConfirmation((String)Messages.DatasetDialog_0, (String)Messages.DatasetDialog_1);
    }

    protected boolean isResizable() {
        return true;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.DatasetDialog_title);
    }

    public boolean close() {
        if (this.getReturnCode() == 0) {
            this.createCommand();
            if (this.cmdStack != null) {
                this.cmdStack.execute((Command)this.command);
            }
        }
        this.dataquery.dispose();
        this.ptable.getPropertyChangeSupport().removePropertyChangeListener(this.prmListener);
        return super.close();
    }

    protected void setHelpControl(Control newControl) {
        newControl.addListener(28, event -> this.performHelp());
    }

    public void performHelp() {
        String child = this.dataquery.getContextHelpId();
        if (child == null) {
            child = ContextHelpIDs.WIZARD_QUERY_DIALOG;
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.body, child);
        PlatformUI.getWorkbench().getHelpSystem().displayHelp(child);
    }

    protected void createFormContent(IManagedForm mform) {
        FormToolkit toolkit = mform.getToolkit();
        this.body = mform.getForm().getBody();
        this.setHelpControl((Control)this.body);
        this.body.setLayout((Layout)new GridLayout(1, true));
        this.background = this.body.getBackground();
        UIUtils.getDisplay().asyncExec(() -> {
            this.body.setBackground(this.sf.getBackground());
            this.body.getParent().update();
            this.body.getParent().layout(true);
        });
        this.dataquery = new DataQueryAdapters(this.body, this.jConfig, this.newdataset, this.background){

            @Override
            protected void createStatusBar(Composite comp) {
                this.qStatus = new QueryStatus(comp);
            }

            @Override
            public void setFields(List<JRDesignField> fields) {
                DatasetDialog.this.setFields(fields);
            }

            @Override
            public List<JRDesignField> getCurrentFields() {
                return DatasetDialog.this.getCurrentFields();
            }

            @Override
            public void setParameters(List<JRParameter> params) {
                DatasetDialog.this.setParameters(params);
            }

            @Override
            public int getContainerType() {
                return 2;
            }
        };
        this.dataquery.createToolbar(this.body);
        this.sf = new CSashForm(this.body, 512);
        GridData gd = new GridData(1808);
        gd.heightHint = 600;
        gd.minimumHeight = 400;
        gd.widthHint = 800;
        this.sf.setLayoutData(gd);
        this.sf.setLayout((Layout)new GridLayout());
        this.dataquery.createTop((Composite)this.sf, this);
        this.createBottom((Composite)this.sf, toolkit);
        JasperDesign jd = this.mdataset.getJasperDesign();
        if (jd == null) {
            jd = this.mdataset.getMreport().getJasperDesign();
        }
        this.setDataset(jd, this.newdataset);
    }

    protected void initSashForm(CSashForm sashform, final JRDesignDataset jDataset) {
        final String SASH_W1 = String.valueOf(this.getClass().getCanonicalName()) + ".sash.w1";
        final String SASH_W2 = String.valueOf(this.getClass().getCanonicalName()) + ".sash.w2";
        int w1 = 450;
        int w2 = 250;
        if (jDataset != null) {
            try {
                String sw1 = jDataset.getPropertiesMap().getProperty(SASH_W1);
                if (sw1 != null) {
                    w1 = Integer.parseInt(sw1);
                }
            }
            catch (NumberFormatException numberFormatException) {}
            try {
                String sw2 = jDataset.getPropertiesMap().getProperty(SASH_W2);
                if (sw2 != null) {
                    w2 = Integer.parseInt(sw2);
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        sashform.setWeights(new int[]{w1, w2});
        sashform.addCustomSashFormListener(new CSashForm.ICustomSashFormListener(){

            @Override
            public void dividerMoved(int firstControlWeight, int secondControlWeight) {
                jDataset.getPropertiesMap().setProperty(SASH_W1, Integer.toString(firstControlWeight));
                jDataset.getPropertiesMap().setProperty(SASH_W2, Integer.toString(secondControlWeight));
            }
        });
    }

    @Override
    public void setFields(List<JRDesignField> fields) {
        this.ftable.setFields(fields);
    }

    @Override
    public void addFields(List<JRDesignField> fields) {
        List<JRDesignField> allFields = this.ftable.getFields();
        for (JRDesignField f : fields) {
            String newName = ModelUtils.getNameForField(allFields, f.getName());
            f.setName(newName);
            allFields.add(f);
        }
        this.ftable.setFields(allFields);
    }

    @Override
    public void clearFields() {
        this.ftable.setFields(new ArrayList(0));
    }

    public void setParameters(List<JRParameter> fields) {
        this.ptable.setFields(fields);
    }

    public List<JRDesignField> getCurrentFields() {
        return this.ftable.getFields();
    }

    private void createBottom(Composite parent, FormToolkit toolkit) {
        CTabFolder tabFolder = new CTabFolder(parent, 3072);
        GridData gd = new GridData(768);
        gd.heightHint = 250;
        tabFolder.setLayoutData((Object)gd);
        this.createFields(toolkit, tabFolder);
        this.createParameters(toolkit, tabFolder);
        this.createSortFields(toolkit, tabFolder);
        this.createFilterExpression(toolkit, tabFolder);
        this.createDataPreview(toolkit, tabFolder);
        tabFolder.setSelection(0);
        tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatasetDialog.this.sftable.refresh();
            }
        });
    }

    private void createDataPreview(FormToolkit toolkit, CTabFolder tabFolder) {
        CTabItem dataPreviewtab = new CTabItem(tabFolder, 0);
        dataPreviewtab.setText(Messages.DatasetDialog_DataPreviewTab);
        this.dataPreviewTable = new DataPreviewTable(this.dataquery, (Composite)tabFolder, this, this.background);
        dataPreviewtab.setControl((Control)this.dataPreviewTable.getControl());
    }

    private void createParameters(FormToolkit toolkit, CTabFolder tabFolder) {
        CTabItem bptab = new CTabItem(tabFolder, 0);
        bptab.setText(Messages.DatasetDialog_ParametersTab);
        this.ptable = new ParametersTable((Composite)tabFolder, this.newdataset, this.background, this.mdataset.isMainDataset(), this.mdataset);
        this.ptable.getPropertyChangeSupport().addPropertyChangeListener(this.prmListener);
        bptab.setControl((Control)this.ptable.getControl());
    }

    private void createFields(FormToolkit toolkit, CTabFolder tabFolder) {
        CTabItem bptab = new CTabItem(tabFolder, 0);
        bptab.setText(Messages.DatasetDialog_fieldstab);
        this.ftable = new FieldsTable((Composite)tabFolder, this.newdataset, this.background, this.mdataset);
        bptab.setControl((Control)this.ftable.getControl());
    }

    private void createSortFields(FormToolkit toolkit, CTabFolder tabFolder) {
        CTabItem bptab = new CTabItem(tabFolder, 0);
        bptab.setText(Messages.DatasetDialog_sortingtab);
        this.sftable = new SortFieldsTable((Composite)tabFolder, this.newdataset, this.background);
        bptab.setControl((Control)this.sftable.getControl());
    }

    private void createFilterExpression(FormToolkit toolkit, CTabFolder tabFolder) {
        CTabItem bptab = new CTabItem(tabFolder, 0);
        bptab.setText(Messages.DatasetDialog_filterexpression);
        Composite sectionClient = toolkit.createComposite((Composite)tabFolder);
        FillLayout fLayout = new FillLayout();
        fLayout.marginHeight = 5;
        fLayout.marginWidth = 5;
        sectionClient.setLayout((Layout)fLayout);
        this.filterExpression = new WTextExpression(sectionClient, 0);
        this.filterExpression.setBackground(sectionClient.getBackground());
        this.filterExpression.setExpressionContext(new ExpressionContext(this.newdataset, this.mdataset.getJasperConfiguration()));
        this.filterExpression.setExpression((JRDesignExpression)this.newdataset.getFilterExpression());
        this.filterExpression.addModifyListener(new ExpressionModifiedListener(){

            @Override
            public void expressionModified(ExpressionModifiedEvent event) {
                DatasetDialog.this.newdataset.setFilterExpression(event.modifiedExpression);
            }
        });
        bptab.setControl((Control)sectionClient);
    }

    public JSSCompoundCommand getCommand() {
        return this.command;
    }

    public void setDataset(JasperDesign jDesign, JRDesignDataset ds) {
        this.initSashForm(this.sf, ds);
        this.dataquery.setDataset(jDesign, ds);
    }

    /*
     * WARNING - void declaration
     */
    public void createCommand() {
        JRDesignDataset ds = this.mdataset.getParent() == null ? this.mdataset.getJasperConfiguration().getJasperDesign().getMainDesignDataset() : this.mdataset.getValue();
        this.command = new JSSCompoundCommand(this.mdataset.getMreport());
        String lang = this.newdataset.getQuery().getLanguage();
        ((JRDesignQuery)this.newdataset.getQuery()).setText(this.dataquery.getQuery());
        String qtext = this.newdataset.getQuery().getText();
        if (ds.getQuery() == null) {
            JRDesignQuery jrQuery = new JRDesignQuery();
            jrQuery.setLanguage(lang);
            jrQuery.setText(qtext);
            this.command.add(this.setValueCommand("query", new MQuery((JRQuery)jrQuery, this.mdataset), this.mdataset));
        } else {
            IPropertySource mquery = (IPropertySource)this.mdataset.getPropertyValue("query");
            String language = ds.getQuery().getLanguage();
            if (language == null || !language.equalsIgnoreCase(lang)) {
                this.command.add(this.setValueCommand("language", lang, mquery));
            }
            if (!ds.getQuery().getText().equals(qtext)) {
                this.command.add(this.setValueCommand("text", qtext, mquery));
            }
        }
        String fexprtext = this.filterExpression.getText();
        if (fexprtext.trim().equals("")) {
            fexprtext = null;
        }
        this.addSetValueCommand(this.command, "filterExpression", fexprtext, this.mdataset);
        this.addSetValueCommand(this.command, "PROPERTY_MAP", this.newdataset.getPropertiesMap(), this.mdataset);
        List oldfields = ds.getFieldsList();
        List<JRDesignField> newfields = this.ftable.getFields();
        for (JRField f : oldfields) {
            Boolean canceled = null;
            for (JRDesignField newf : newfields) {
                if (!newf.getName().equals(f.getName()) && this.mapfields.get(f) != newf) continue;
                canceled = Boolean.TRUE;
                break;
            }
            if (canceled != null) continue;
            this.command.add(new DeleteFieldCommand(this.jConfig, ds, (JRDesignField)f, canceled));
        }
        for (JRDesignField newf : newfields) {
            boolean notexists = true;
            for (JRField f : oldfields) {
                MField mfield;
                if (newf.getName().equals(f.getName())) {
                    mfield = this.mdataset.getField(newf.getName());
                    if (mfield != null) {
                        this.addSetValueCommand(this.command, "valueClassName", newf.getValueClassName(), mfield);
                        this.addSetValueCommand(this.command, "description", newf.getDescription(), mfield);
                        this.addSetValueCommand(this.command, "propertyExpressions", newf.getPropertyExpressionsList(), mfield);
                        this.addSetValueCommand(this.command, "PROPERTY_MAP", newf.getPropertiesMap(), mfield);
                    }
                    notexists = false;
                } else if (this.mapfields.containsValue(newf)) {
                    mfield = null;
                    for (JRField p : this.mapfields.keySet()) {
                        if (this.mapfields.get(p) != newf) continue;
                        mfield = this.mdataset.getField(p.getName());
                        break;
                    }
                    if (mfield != null) {
                        this.addSetValueCommand(this.command, "name", newf.getName(), mfield);
                        this.addSetValueCommand(this.command, "valueClassName", newf.getValueClassName(), mfield);
                        this.addSetValueCommand(this.command, "description", newf.getDescription(), mfield);
                        this.addSetValueCommand(this.command, "propertyExpressions", newf.getPropertyExpressionsList(), mfield);
                        this.addSetValueCommand(this.command, "PROPERTY_MAP", newf.getPropertiesMap(), mfield);
                    }
                    notexists = false;
                }
                if (!notexists) break;
            }
            if (!notexists) continue;
            this.command.add(new CreateFieldCommand(ds, newf, -1));
        }
        if (oldfields.size() == newfields.size()) {
            int i = 0;
            while (i < newfields.size()) {
                if (!ModelUtils.areFieldsEquals((JRField)oldfields.get(i), (JRField)newfields.get(i))) {
                    this.command.add(new ReplaceAllFieldsCommand(newfields, this.mdataset.getMFields()));
                    break;
                }
                ++i;
            }
        } else {
            this.command.add(new ReplaceAllFieldsCommand(newfields, this.mdataset.getMFields()));
        }
        List oldSortFields = ds.getSortFieldsList();
        List<JRDesignSortField> newSortFields = this.sftable.getFields();
        if (oldSortFields.size() == newSortFields.size()) {
            int i = 0;
            while (i < newSortFields.size()) {
                if (!ModelUtils.areSortFieldsEquals((JRSortField)oldSortFields.get(i), (JRSortField)newSortFields.get(i))) {
                    this.command.add(new ReplaceAllSortFieldsCommand(newSortFields, this.mdataset.getMSortFields()));
                    break;
                }
                ++i;
            }
        } else {
            this.command.add(new ReplaceAllSortFieldsCommand(newSortFields, this.mdataset.getMSortFields()));
        }
        List oldparams = ds.getParametersList();
        List<JRDesignParameter> newparams = this.ptable.getParameters();
        for (JRParameter jRParameter : oldparams) {
            if (jRParameter.isSystemDefined()) continue;
            Boolean canceled = null;
            for (JRParameter jRParameter2 : newparams) {
                if (!jRParameter2.getName().equals(jRParameter.getName()) && this.mapparam.get(jRParameter) != jRParameter2) continue;
                canceled = Boolean.TRUE;
                break;
            }
            if (canceled != null) continue;
            this.command.add(new DeleteParameterCommand(this.jConfig, ds, jRParameter, canceled));
        }
        for (JRParameter jRParameter : newparams) {
            if (jRParameter.isSystemDefined()) continue;
            boolean notexists = true;
            for (JRParameter jRParameter3 : oldparams) {
                MParameterSystem mparam;
                JRDesignParameter prm = (JRDesignParameter)this.newdataset.getParametersMap().get(jRParameter.getName());
                if (prm == null) break;
                if (jRParameter.getName().equals(jRParameter3.getName())) {
                    mparam = this.mdataset.getParamater(jRParameter.getName());
                    if (mparam != null) {
                        this.addSetValueCommand(this.command, "valueClassName", prm.getValueClassName(), mparam);
                        this.addSetValueCommand(this.command, "description", prm.getDescription(), mparam);
                        this.addSetValueCommand(this.command, "defaultValueExpression", prm.getDefaultValueExpression(), mparam);
                        this.addSetValueCommand(this.command, "isForPrompting", prm.isForPrompting(), mparam);
                        this.addSetValueCommand(this.command, "evaluationTime", prm.getEvaluationTime(), mparam);
                        this.addSetValueCommand(this.command, "PROPERTY_MAP", prm.getPropertiesMap(), mparam);
                    }
                    notexists = false;
                } else if (this.mapparam.containsValue(jRParameter)) {
                    mparam = null;
                    for (JRParameter p : this.mapparam.keySet()) {
                        if (this.mapparam.get(p) != jRParameter) continue;
                        mparam = this.mdataset.getParamater(p.getName());
                        break;
                    }
                    if (mparam != null) {
                        this.addSetValueCommand(this.command, "name", prm.getName(), mparam);
                        this.addSetValueCommand(this.command, "valueClassName", prm.getValueClassName(), mparam);
                        this.addSetValueCommand(this.command, "description", prm.getDescription(), mparam);
                        this.addSetValueCommand(this.command, "defaultValueExpression", prm.getDefaultValueExpression(), mparam);
                        this.addSetValueCommand(this.command, "evaluationTime", prm.getEvaluationTime(), mparam);
                        this.addSetValueCommand(this.command, "isForPrompting", prm.isForPrompting(), mparam);
                        this.addSetValueCommand(this.command, "PROPERTY_MAP", prm.getPropertiesMap(), mparam);
                    }
                    notexists = false;
                }
                if (!notexists) break;
            }
            if (!notexists) continue;
            this.command.add(new CreateParameterCommand(ds, jRParameter, this.jConfig, -1));
        }
        if (oldparams.size() == newparams.size()) {
            void var11_25;
            boolean bl = false;
            while (var11_25 < newparams.size()) {
                if (!ModelUtils.areParametersEquals((JRParameter)oldparams.get((int)var11_25), (JRParameter)newparams.get((int)var11_25))) {
                    this.command.add(new ReplaceAllParametersCommand(newparams, this.mdataset.getMParameters()));
                    break;
                }
                ++var11_25;
            }
        } else {
            this.command.add(new ReplaceAllParametersCommand(newparams, this.mdataset.getMParameters()));
        }
    }

    private void addSetValueCommand(JSSCompoundCommand cc, String property, Object value, IPropertySource target) {
        if (!this.extendedEquals(value, target.getPropertyValue((Object)property))) {
            SetValueCommand cmd = new SetValueCommand();
            cmd.setTarget(target);
            cmd.setPropertyId(property);
            cmd.setPropertyValue(value);
            cc.add(cmd);
        }
    }

    private boolean extendedEquals(Object value1, Object value2) {
        if (value1 instanceof JRExpression && value2 instanceof JRExpression) {
            JRExpression exp1 = (JRExpression)value1;
            JRExpression exp2 = (JRExpression)value2;
            return ModelUtils.safeEquals(exp1.getText(), exp2.getText());
        }
        if (value1 instanceof JRPropertiesMap && value2 instanceof JRPropertiesMap) {
            JRPropertiesMap map1 = (JRPropertiesMap)value1;
            JRPropertiesMap map2 = (JRPropertiesMap)value2;
            return ModelUtils.jrPropertiesMapEquals(map1, map2);
        }
        return ModelUtils.safeEquals(value1, value2);
    }

    private Command setValueCommand(String property, Object value, IPropertySource target) {
        SetValueCommand cmd = new SetValueCommand();
        cmd.setTarget(target);
        cmd.setPropertyId(property);
        cmd.setPropertyValue(value);
        return cmd;
    }

    @Override
    public JasperReportsConfiguration getJasperReportsConfig() {
        return this.jConfig;
    }

    @Override
    public DataAdapterDescriptor getDataAdapterDescriptor() {
        return this.dataquery.getDataAdapter();
    }

    @Override
    public JRDesignDataset getDesignDataset() {
        return this.newdataset;
    }

    @Override
    public List<JRDesignField> getFieldsForPreview() {
        return this.getCurrentFields();
    }

    public static interface JDBC_METADATA_LOADING {
        public static final String DISABLED = "ALWAYS_DISABLED";
        public static final String DISABLED_ON_STARTUP = "DISABLED_ON_STARTUP";
        public static final String ENABLED = "ALWAYS_ENABLED";
        public static final String P_JDBC_METADATA_LOADING = "com.jaspersoft.studio.data.sql.prefs.JDBCMETADATALOADING";
    }
}

