/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.dataset.fields;

import com.jaspersoft.studio.dnd.NodeDragListener;
import com.jaspersoft.studio.dnd.NodeTableDropAdapter;
import com.jaspersoft.studio.dnd.NodeTransfer;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.dataset.MDataset;
import com.jaspersoft.studio.model.field.MField;
import com.jaspersoft.studio.property.dataset.dialog.AbstractModifyTable;
import com.jaspersoft.studio.property.dataset.fields.PropertiesDialog;
import com.jaspersoft.studio.property.dataset.fields.table.TColumn;
import com.jaspersoft.studio.property.dataset.fields.table.TColumnFactory;
import com.jaspersoft.studio.swt.widgets.table.DeleteButton;
import com.jaspersoft.studio.swt.widgets.table.EditButton;
import com.jaspersoft.studio.swt.widgets.table.IEditElement;
import com.jaspersoft.studio.swt.widgets.table.INewElement;
import com.jaspersoft.studio.swt.widgets.table.ListContentProvider;
import com.jaspersoft.studio.swt.widgets.table.ListOrderButtons;
import com.jaspersoft.studio.swt.widgets.table.NewButton;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.UIUtil;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.properties.PropertiesMetadataUtil;
import net.sf.jasperreports.properties.PropertyMetadata;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.part.PluginTransfer;

public class FieldsTable
extends AbstractModifyTable {
    private TableViewer tviewer;
    private Composite composite;
    private JRDesignDataset dataset;
    private Color background;
    private MDataset mdataset;
    private List<TableViewerColumn> columns = new ArrayList<TableViewerColumn>();
    private List<TColumn> tcolumns = new ArrayList<TColumn>();

    public FieldsTable(Composite parent, JRDesignDataset dataset, Color background, MDataset mdataset) {
        this.mdataset = mdataset;
        this.dataset = dataset;
        this.background = background;
        this.createControl(parent);
        if (dataset.getQuery() != null) {
            ((JRDesignQuery)dataset.getQuery()).getEventSupport().addPropertyChangeListener("language", evt -> this.refreshFields((String)evt.getNewValue()));
        }
    }

    public Composite getControl() {
        return this.composite;
    }

    private void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout(2, false));
        this.composite.setBackground(this.background);
        this.composite.setBackgroundMode(2);
        this.wtable = new Table(this.composite, 68098);
        GridData gd = new GridData(1808);
        gd.widthHint = 100;
        this.wtable.setLayoutData((Object)gd);
        this.wtable.setHeaderVisible(true);
        this.wtable.setLinesVisible(true);
        this.tviewer = new TableViewer(this.wtable);
        this.tviewer.setContentProvider((IContentProvider)new ListContentProvider());
        UIUtil.setViewerCellEditingOnDblClick(this.tviewer);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tviewer, (int)2);
        this.addDropSupport();
        this.refreshFields(this.dataset.getQuery() == null ? "" : this.dataset.getQuery().getLanguage());
        Composite bGroup = new Composite(this.composite, 0);
        bGroup.setLayout((Layout)new GridLayout(1, false));
        bGroup.setLayoutData((Object)new GridData(1040));
        new NewButton(){

            @Override
            protected void afterElementAdded(Object selement) {
                try {
                    FieldsTable.this.dataset.addField((JRField)selement);
                    FieldsTable.this.fireModifyListeners();
                }
                catch (JRException e) {
                    e.printStackTrace();
                }
            }
        }.createNewButtons(bGroup, this.tviewer, new INewElement(){

            @Override
            public Object newElement(List<?> input, int pos) {
                JRDesignField f = new JRDesignField();
                f.setName(this.getName());
                f.setValueClass(String.class);
                return f;
            }

            private String getName() {
                List list = (List)FieldsTable.this.tviewer.getInput();
                String name = "Field";
                boolean match = false;
                String tmp = name;
                int i = 1;
                while (i < 100000) {
                    tmp = ModelUtils.getNameFormat(name, i);
                    for (JRDesignField f : list) {
                        match = f.getName().equals(tmp);
                        if (match) break;
                    }
                    if (!match) break;
                    ++i;
                }
                return tmp;
            }
        });
        EditButton<JRDesignField> eb = new EditButton<JRDesignField>();
        eb.createEditButtons(bGroup, this.tviewer, new IEditElement<JRDesignField>(){

            @Override
            public void editElement(List<JRDesignField> input, int pos) {
                JRDesignField oldF = input.get(pos);
                JasperReportsConfiguration jConf = FieldsTable.this.mdataset.getJasperConfiguration();
                jConf.put("com.jaspersoft.studio.dataset.language", FieldsTable.this.dataset.getQuery() != null ? FieldsTable.this.dataset.getQuery().getLanguage() : null);
                PropertiesDialog<JRDesignField> d = new PropertiesDialog<JRDesignField>(FieldsTable.this.tviewer.getTable().getShell(), (JRDesignField)oldF.clone(), FieldsTable.this.tcolumns, MField.getIconDescriptor().getDescription(), jConf);
                if (d.open() == 0) {
                    FieldsTable.this.dataset.removeField((JRField)oldF);
                    try {
                        FieldsTable.this.dataset.addField((JRField)d.getElement());
                        input.set(pos, d.getElement());
                    }
                    catch (JRException e) {
                        UIUtils.showError((Throwable)e);
                    }
                }
                jConf.remove("com.jaspersoft.studio.dataset.language");
            }
        });
        eb.editOnDoubleClick();
        new DeleteButton(){

            @Override
            protected void afterElementDeleted(Object element) {
                if (element != null) {
                    FieldsTable.this.dataset.removeField(((JRDesignField)element).getName());
                    FieldsTable.this.fireModifyListeners();
                }
            }
        }.createDeleteButton(bGroup, this.tviewer);
        new ListOrderButtons().createOrderButtons(bGroup, this.tviewer);
        ArrayList fields = this.dataset.getFieldsList();
        if (fields == null) {
            fields = new ArrayList();
        }
        this.setFields(fields);
    }

    private void createPropertiesColumn() {
        TColumn c = new TColumn();
        c.setPropertyName("properties");
        c.setLabel(Messages.common_properties);
        c.setPropertyType(JRPropertiesMap.class.getName());
        c.setType("properties");
        c.setValue(this.mdataset);
        this.columns.add(TColumnFactory.addColumn(c, this.tviewer));
        this.tcolumns.add(c);
    }

    private void createDescriptionColumn() {
        TColumn c = new TColumn();
        c.setPropertyName("description");
        c.setLabel(Messages.common_descriptionLabel);
        this.columns.add(TColumnFactory.addColumn(c, this.tviewer));
        this.tcolumns.add(c);
    }

    private void createTypeColumn() {
        TColumn c = new TColumn();
        c.setPropertyName("valueClassName");
        c.setLabel(Messages.common_classTypeLabel);
        c.setPropertyType(Class.class.getName());
        this.columns.add(TColumnFactory.addColumn(c, this.tviewer));
        this.tcolumns.add(c);
    }

    private void createNameColumn() {
        TColumn c = new TColumn();
        c.setPropertyName("name");
        c.setLabel(Messages.common_fieldNameLabel);
        c.setValue(this.dataset);
        this.columns.add(TColumnFactory.addColumn(c, this.tviewer));
        this.tcolumns.add(c);
    }

    private void addDropSupport() {
        int ops = 3;
        Transfer[] transfers = new Transfer[]{TemplateTransfer.getInstance(), NodeTransfer.getInstance(), PluginTransfer.getInstance()};
        this.tviewer.addDragSupport(ops, transfers, (DragSourceListener)new NodeDragListener((StructuredViewer)this.tviewer));
        transfers = new Transfer[]{NodeTransfer.getInstance()};
        NodeTableDropAdapter dropAdapter = new NodeTableDropAdapter(this.tviewer){

            @Override
            public boolean performDrop(Object data) {
                if (data instanceof ANode[]) {
                    ANode[] nodes = (ANode[])data;
                    List fields = (List)FieldsTable.this.tviewer.getInput();
                    ANode[] aNodeArray = nodes;
                    int n = nodes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ANode n3 = aNodeArray[n2];
                        JRDesignField f = (JRDesignField)n3.getAdapter(JRDesignField.class);
                        if (f != null) {
                            f.setName(ModelUtils.getNameForField((List)FieldsTable.this.tviewer.getInput(), f.getName()));
                            fields.add(f);
                        }
                        ++n2;
                    }
                    FieldsTable.this.setFields(fields);
                    return true;
                }
                return false;
            }
        };
        this.tviewer.addDropSupport(ops, transfers, (DropTargetListener)dropAdapter);
    }

    public <T extends JRField> void setFields(List<T> fields) {
        JRField f;
        fields = new ArrayList<T>(fields);
        HashMap<String, JRField> oldFieldsMap = new HashMap<String, JRField>();
        JRField[] jRFieldArray = this.dataset.getFields();
        int n = jRFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            f = jRFieldArray[n2];
            oldFieldsMap.put(f.getName(), f);
            ++n2;
        }
        jRFieldArray = this.dataset.getFields();
        n = jRFieldArray.length;
        n2 = 0;
        while (n2 < n) {
            f = jRFieldArray[n2];
            this.dataset.removeField(f);
            ++n2;
        }
        ArrayList<JRField> newfields = new ArrayList<JRField>();
        for (JRField f2 : fields) {
            try {
                JRField oldField = (JRField)oldFieldsMap.get(f2.getName());
                if (oldField != null) {
                    JRPropertiesMap oldProperties = oldField.getPropertiesMap();
                    JRPropertiesMap newProperties = f2.getPropertiesMap();
                    String[] stringArray = oldProperties.getOwnPropertyNames();
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String property = stringArray[n4];
                        if (Misc.isNullOrEmpty((String)newProperties.getProperty(property))) {
                            newProperties.setProperty(property, oldProperties.getProperty(property));
                        }
                        ++n4;
                    }
                    if (Misc.isNullOrEmpty((String)f2.getDescription())) {
                        f2.setDescription(oldField.getDescription());
                    }
                }
                this.dataset.addField(f2);
                newfields.add(f2);
            }
            catch (JRException e) {
                e.printStackTrace();
            }
        }
        this.tviewer.setInput(newfields);
        this.tviewer.refresh();
    }

    public List<JRDesignField> getFields() {
        return (List)this.tviewer.getInput();
    }

    private void refreshFields(String newLang) {
        block7: {
            for (TableViewerColumn tvc : this.columns) {
                tvc.getColumn().dispose();
            }
            this.columns.clear();
            this.tviewer.setColumnProperties(new String[0]);
            this.tviewer.setCellEditors(new CellEditor[0]);
            this.tviewer.getTable().setLayout((Layout)new TableLayout());
            this.tcolumns.clear();
            this.createNameColumn();
            this.createTypeColumn();
            this.createDescriptionColumn();
            PropertiesMetadataUtil pmu = PropertiesMetadataUtil.getInstance((JasperReportsContext)this.mdataset.getJasperConfiguration());
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            try {
                try {
                    Thread.currentThread().setContextClassLoader(JRLoader.class.getClassLoader());
                    List props = pmu.getQueryExecuterFieldProperties(newLang);
                    for (PropertyMetadata pm : props) {
                        TColumn c = TColumnFactory.getTColumn(pm);
                        c.setValue(this.dataset);
                        this.columns.add(TColumnFactory.addColumn(c, this.tviewer));
                        this.tcolumns.add(c);
                    }
                }
                catch (JRException e) {
                    e.printStackTrace();
                    Thread.currentThread().setContextClassLoader(oldCl);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                Thread.currentThread().setContextClassLoader(oldCl);
                throw throwable;
            }
            Thread.currentThread().setContextClassLoader(oldCl);
        }
        this.createPropertiesColumn();
        this.tviewer.getTable().layout(true);
        this.tviewer.refresh();
    }
}

