/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.dataset.fields.table.column;

import com.jaspersoft.studio.model.dataset.MDataset;
import com.jaspersoft.studio.model.field.MField;
import com.jaspersoft.studio.model.parameter.MParameter;
import com.jaspersoft.studio.property.dataset.fields.table.TColumn;
import com.jaspersoft.studio.property.dataset.fields.table.column.PropertyColumnSupport;
import com.jaspersoft.studio.property.descriptor.propexpr.JPropertyExpressionsCellEditor;
import com.jaspersoft.studio.property.descriptor.propexpr.PropertyExpressionDTO;
import com.jaspersoft.studio.property.descriptor.propexpr.PropertyExpressionsDTO;
import com.jaspersoft.studio.utils.ModelUtils;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRPropertyExpression;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JRDesignPropertyExpression;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.swt.widgets.Composite;

public class JRPropertiesColumnSupport
extends PropertyColumnSupport {
    private MDataset mdataset;

    public JRPropertiesColumnSupport(ColumnViewer viewer, TColumn c) {
        super(viewer, c);
        this.mdataset = (MDataset)c.getValue();
    }

    @Override
    protected CellEditor createCellEditor() {
        return new JPropertyExpressionsCellEditor((Composite)this.viewer.getControl());
    }

    @Override
    protected void setValue(Object element, Object value) {
        if (element != null && value instanceof PropertyExpressionsDTO) {
            JRDesignField field;
            PropertyExpressionsDTO dto = (PropertyExpressionsDTO)value;
            if (element instanceof JRDesignField) {
                field = (JRDesignField)element;
                JRPropertyExpression[] expr = field.getPropertyExpressions();
                if (expr != null) {
                    JRPropertyExpression[] jRPropertyExpressionArray = expr;
                    int n = expr.length;
                    int n2 = 0;
                    while (n2 < n) {
                        JRPropertyExpression ex = jRPropertyExpressionArray[n2];
                        field.removePropertyExpression(ex);
                        ++n2;
                    }
                }
                for (PropertyExpressionDTO p : dto.getProperties()) {
                    if (!p.isExpression()) continue;
                    JRDesignPropertyExpression newExp = new JRDesignPropertyExpression();
                    newExp.setName(p.getName());
                    newExp.setValueExpression(p.getValueAsExpression());
                    field.addPropertyExpression((JRPropertyExpression)newExp);
                }
            }
            if (element instanceof JRPropertiesHolder) {
                field = (JRPropertiesHolder)element;
                String[] names = field.getPropertiesMap().getPropertyNames();
                int i = 0;
                while (i < names.length) {
                    field.getPropertiesMap().removeProperty(names[i]);
                    ++i;
                }
                for (PropertyExpressionDTO p : dto.getProperties()) {
                    if (p.isExpression()) continue;
                    field.getPropertiesMap().setProperty(p.getName(), p.getValue());
                }
            }
            this.viewer.update(element, null);
        }
    }

    @Override
    protected Object getValue(Object element) {
        if (element instanceof JRDesignField) {
            JRDesignField prop = (JRDesignField)element;
            JRPropertyExpression[] propertyExpressions = prop.getPropertyExpressions();
            if (propertyExpressions != null) {
                propertyExpressions = (JRPropertyExpression[])propertyExpressions.clone();
            }
            return new PropertyExpressionsDTO(propertyExpressions, MField.getPropertiesMapClone(prop), element, ModelUtils.getExpressionContext(this.mdataset));
        }
        if (element instanceof JRDesignParameter) {
            JRDesignParameter prop = (JRDesignParameter)element;
            return new PropertyExpressionsDTO(null, MParameter.getPropertiesMapClone((JRPropertiesHolder)prop), element, ModelUtils.getExpressionContext(this.mdataset));
        }
        return null;
    }

    @Override
    public String getText(Object element) {
        if (element instanceof JRDesignField) {
            JRPropertyExpression[] pexp;
            JRDesignField field = (JRDesignField)element;
            int size = 0;
            JRPropertiesMap pmap = field.getPropertiesMap();
            if (pmap != null && pmap.getPropertyNames() != null) {
                size += pmap.getPropertyNames().length;
            }
            if ((pexp = field.getPropertyExpressions()) != null) {
                size += field.getPropertyExpressions().length;
            }
            return size == 0 ? "" : (size == 1 ? "1 Property" : String.valueOf(size) + " Properties");
        }
        if (element instanceof JRDesignParameter) {
            JRDesignParameter field = (JRDesignParameter)element;
            int size = 0;
            JRPropertiesMap pmap = field.getPropertiesMap();
            if (pmap != null && pmap.getPropertyNames() != null) {
                size += pmap.getPropertyNames().length;
            }
            return size == 0 ? "" : (size == 1 ? "1 Property" : String.valueOf(size) + " Properties");
        }
        return "";
    }
}

