/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.dataset.fields.table.column;

import com.jaspersoft.studio.property.dataset.fields.table.TColumn;
import com.jaspersoft.studio.property.dataset.fields.table.column.PropertyColumnSupport;
import com.jaspersoft.studio.property.descriptor.propexpr.PropertyExpressionDTO;
import com.jaspersoft.studio.property.descriptor.propexpr.cell.JRPropertyExpressionCellEditor;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertyExpression;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignPropertyExpression;
import net.sf.jasperreports.engine.type.ExpressionTypeEnum;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.swt.widgets.Composite;

public class JRPropertyColumnSupport
extends PropertyColumnSupport {
    public JRPropertyColumnSupport(ColumnViewer viewer, TColumn c) {
        super(viewer, c);
    }

    @Override
    protected CellEditor createCellEditor() {
        return new JRPropertyExpressionCellEditor((Composite)this.viewer.getControl());
    }

    @Override
    protected void setValue(Object element, Object value) {
        if (element instanceof JRPropertiesHolder) {
            JRPropertiesHolder field = (JRPropertiesHolder)element;
            if (element instanceof JRDesignField && value instanceof PropertyExpressionDTO) {
                JRDesignField f = (JRDesignField)element;
                PropertyExpressionDTO dto = (PropertyExpressionDTO)value;
                if (dto.isExpression()) {
                    if (dto.getValue() == null || dto.getValue().isEmpty()) {
                        f.removePropertyExpression(this.c.getPropertyName());
                    } else {
                        JRDesignPropertyExpression pe = new JRDesignPropertyExpression();
                        pe.setName(this.c.getPropertyName());
                        pe.setValueExpression(dto.getValueAsExpression());
                        f.removePropertyExpression(this.c.getPropertyName());
                        f.addPropertyExpression((JRPropertyExpression)pe);
                    }
                } else {
                    f.removePropertyExpression(this.c.getPropertyName());
                    if (dto.getValue() == null || dto.getValue().isEmpty()) {
                        field.getPropertiesMap().removeProperty(this.c.getPropertyName());
                    } else {
                        field.getPropertiesMap().setProperty(this.c.getPropertyName(), dto.getValue());
                    }
                }
            } else if (value == null || value.toString().isEmpty()) {
                field.getPropertiesMap().removeProperty(this.c.getPropertyName());
            } else {
                field.getPropertiesMap().setProperty(this.c.getPropertyName(), value.toString());
            }
            this.viewer.update(element, null);
        }
    }

    @Override
    protected Object getValue(Object element) {
        if (element instanceof JRPropertiesHolder) {
            JRDesignField f;
            JRPropertiesHolder field = (JRPropertiesHolder)element;
            boolean isExpression = false;
            String value = field.getPropertiesMap().getProperty(this.c.getPropertyName());
            boolean isSimpleText = false;
            if (element instanceof JRDesignField && (f = (JRDesignField)element).getPropertyExpressionsList() != null) {
                for (JRPropertyExpression pe : f.getPropertyExpressionsList()) {
                    if (!pe.getName().equals(this.c.getPropertyName()) || pe.getValueExpression() == null) continue;
                    isExpression = true;
                    isSimpleText = ExpressionTypeEnum.SIMPLE_TEXT == pe.getValueExpression().getType();
                    value = pe.getValueExpression().getText();
                }
            }
            return new PropertyExpressionDTO(isExpression, this.c.getPropertyName(), value, isSimpleText);
        }
        return new PropertyExpressionDTO(false, this.c.getPropertyName(), "", false);
    }
}

