/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.dataset.fields.table.widget;

import com.jaspersoft.studio.property.dataset.fields.table.TColumn;
import com.jaspersoft.studio.property.dataset.fields.table.widget.AWControl;
import com.jaspersoft.studio.property.dataset.fields.table.widget.WBoolean;
import com.jaspersoft.studio.property.dataset.fields.table.widget.WBooleanNative;
import com.jaspersoft.studio.property.dataset.fields.table.widget.WClassName;
import com.jaspersoft.studio.property.dataset.fields.table.widget.WColorProperty;
import com.jaspersoft.studio.property.dataset.fields.table.widget.WEnum;
import com.jaspersoft.studio.property.dataset.fields.table.widget.WExpression;
import com.jaspersoft.studio.property.dataset.fields.table.widget.WLocaleProperty;
import com.jaspersoft.studio.property.dataset.fields.table.widget.WNumber;
import com.jaspersoft.studio.property.dataset.fields.table.widget.WProperties;
import com.jaspersoft.studio.property.dataset.fields.table.widget.WText;
import com.jaspersoft.studio.property.dataset.fields.table.widget.WTimeZoneProperty;
import com.jaspersoft.studio.property.descriptor.propexpr.dialog.HintsPropertiesList;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import org.eclipse.swt.widgets.Composite;

public abstract class AWidget {
    private static Map<String, Class<? extends AWControl>> wmap = new HashMap<String, Class<? extends AWControl>>();
    protected TColumn c;
    protected Object element;
    protected AWControl control;
    protected JasperReportsConfiguration jConfig;

    static {
        wmap.put(Class.class.getName(), WClassName.class);
        wmap.put(Boolean.class.getName(), WBoolean.class);
        wmap.put(Boolean.TYPE.getName(), WBooleanNative.class);
        wmap.put(JRDesignExpression.class.getName(), WExpression.class);
        wmap.put(JRPropertiesMap.class.getName(), WProperties.class);
        wmap.put(Integer.class.getName(), WNumber.class);
        wmap.put(BigInteger.class.getName(), WNumber.class);
        wmap.put(Long.class.getName(), WNumber.class);
        wmap.put(Short.class.getName(), WNumber.class);
        wmap.put(Byte.class.getName(), WNumber.class);
        wmap.put(Double.class.getName(), WNumber.class);
        wmap.put(Float.class.getName(), WNumber.class);
        wmap.put(BigDecimal.class.getName(), WNumber.class);
        wmap.put(Color.class.getName(), WColorProperty.class);
        wmap.put(Locale.class.getName(), WLocaleProperty.class);
        wmap.put(TimeZone.class.getName(), WTimeZoneProperty.class);
        wmap.put(File.class.getName(), WText.class);
        wmap.put(Path.class.getName(), WText.class);
    }

    public static void addControlValueType(String key, Class<? extends AWControl> wcnt) {
        wmap.put(key, wcnt);
    }

    public AWidget(Composite parent, TColumn c, Object element, JasperReportsConfiguration jConfig) {
        this.c = c;
        this.element = element;
        this.jConfig = jConfig;
        this.initControl(parent, c);
        PropertyChangeListener l = evt -> {
            if (evt.getPropertyName().equals(c.getPropertyName()) && this.control != null) {
                this.control.fillValue();
            }
        };
        if (element instanceof JRChangeEventsSupport) {
            ((JRChangeEventsSupport)element).getEventSupport().addPropertyChangeListener(l);
        }
        if (element instanceof JRPropertiesHolder) {
            ((JRPropertiesHolder)element).getPropertiesMap().getEventSupport().addPropertyChangeListener(l);
        }
        if (this.control != null) {
            this.control.addDisposeListener(e -> {
                if (element instanceof JRChangeEventsSupport) {
                    ((JRChangeEventsSupport)element).getEventSupport().removePropertyChangeListener(l);
                }
                if (element instanceof JRPropertiesHolder) {
                    ((JRPropertiesHolder)element).getPropertiesMap().getEventSupport().removePropertyChangeListener(l);
                }
            });
        }
    }

    public AWControl getControl() {
        return this.control;
    }

    protected void initControl(Composite parent, TColumn c) {
        if (wmap.containsKey(c.getPropertyType())) {
            try {
                Constructor<? extends AWControl> constr = wmap.get(c.getPropertyType()).getConstructor(AWidget.class);
                this.control = constr.newInstance(this);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {}
        } else if (c.getType().equals("classTypeCombo")) {
            this.control = new WClassName(this);
        } else if (c.getType().equals("checkbox")) {
            this.control = new WBoolean(this);
        } else {
            try {
                Class<?> clazz = Class.forName(c.getPropertyType());
                if (clazz.isEnum()) {
                    this.control = new WEnum(this, clazz);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        if (this.control == null) {
            this.control = new WText(this);
        }
        this.control.createLabel(parent, c);
        this.control.createControl(parent);
        this.control.fillValue();
    }

    public JasperReportsConfiguration getjConfig() {
        return this.jConfig;
    }

    public TColumn getTColumn() {
        return this.c;
    }

    protected String getToolTipText() {
        String tt = this.control.getText();
        if (!Misc.isNullOrEmpty((String)tt)) {
            tt = String.valueOf(tt) + "\n\n";
        }
        return String.valueOf(tt) + HintsPropertiesList.getToolTip(this.c.getPropertyMetadata());
    }

    protected abstract Object getValue();

    public abstract void setValue(Object var1);

    public Object getElement() {
        return this.element;
    }

    public void setElement(Object element) {
        this.element = element;
    }

    public void dispose() {
    }
}

