/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.dataset.fields.table.widget;

import com.jaspersoft.studio.model.dataset.MDataset;
import com.jaspersoft.studio.model.field.MField;
import com.jaspersoft.studio.model.parameter.MParameter;
import com.jaspersoft.studio.property.dataset.fields.table.TColumn;
import com.jaspersoft.studio.property.dataset.fields.table.widget.AWidget;
import com.jaspersoft.studio.property.descriptor.propexpr.PropertyExpressionDTO;
import com.jaspersoft.studio.property.descriptor.propexpr.PropertyExpressionsDTO;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRPropertyExpression;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignPropertyExpression;
import org.eclipse.swt.widgets.Composite;

public class WJRProperties
extends AWidget {
    private MDataset mdataset;

    public WJRProperties(Composite parent, TColumn c, Object element, JasperReportsConfiguration jConfig) {
        super(parent, c, element, jConfig);
        this.mdataset = (MDataset)c.getValue();
    }

    @Override
    public void setValue(Object value) {
        if (this.element != null && value instanceof PropertyExpressionsDTO) {
            JRDesignField field;
            PropertyExpressionsDTO dto = (PropertyExpressionsDTO)value;
            if (this.element instanceof JRDesignField) {
                field = (JRDesignField)this.element;
                JRPropertyExpression[] expr = field.getPropertyExpressions();
                if (expr != null) {
                    JRPropertyExpression[] jRPropertyExpressionArray = expr;
                    int n = expr.length;
                    int n2 = 0;
                    while (n2 < n) {
                        JRPropertyExpression ex = jRPropertyExpressionArray[n2];
                        field.removePropertyExpression(ex);
                        ++n2;
                    }
                }
                for (PropertyExpressionDTO p : dto.getProperties()) {
                    if (!p.isExpression()) continue;
                    JRDesignPropertyExpression newExp = new JRDesignPropertyExpression();
                    newExp.setName(p.getName());
                    newExp.setValueExpression(p.getValueAsExpression());
                    field.addPropertyExpression((JRPropertyExpression)newExp);
                }
            }
            if (this.element instanceof JRPropertiesHolder) {
                field = (JRPropertiesHolder)this.element;
                String[] names = field.getPropertiesMap().getPropertyNames();
                int i = 0;
                while (i < names.length) {
                    field.getPropertiesMap().removeProperty(names[i]);
                    ++i;
                }
                for (PropertyExpressionDTO p : dto.getProperties()) {
                    if (p.isExpression()) continue;
                    field.getPropertiesMap().setProperty(p.getName(), p.getValue());
                }
            }
        }
    }

    @Override
    protected Object getValue() {
        if (this.element instanceof JRDesignField) {
            JRDesignField prop = (JRDesignField)this.element;
            JRPropertyExpression[] propertyExpressions = prop.getPropertyExpressions();
            if (propertyExpressions != null) {
                propertyExpressions = (JRPropertyExpression[])propertyExpressions.clone();
            }
            return new PropertyExpressionsDTO(propertyExpressions, MField.getPropertiesMapClone(prop), this.element, ModelUtils.getExpressionContext(this.mdataset));
        }
        if (this.element instanceof JRPropertiesHolder) {
            return new PropertyExpressionsDTO(null, MParameter.getPropertiesMapClone((JRPropertiesHolder)this.element), this.element, ModelUtils.getExpressionContext(this.mdataset));
        }
        if (this.element instanceof JRPropertiesMap) {
            return new PropertyExpressionsDTO(null, ((JRPropertiesMap)this.element).cloneProperties(), this.element, ModelUtils.getExpressionContext(this.mdataset));
        }
        return null;
    }
}

