/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.dataset.preview;

import com.jaspersoft.studio.data.IDataPreviewInfoProvider;
import com.jaspersoft.studio.data.designer.AQueryDesignerContainer;
import com.jaspersoft.studio.data.reader.DatasetReader;
import com.jaspersoft.studio.data.reader.DatasetReaderListener;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.property.dataset.dialog.CopyDataDialog;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignField;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class DataPreviewTable
implements DatasetReaderListener {
    private static final int FILLER_THREAD_SLEEPTIME = 30;
    private static final int RECORDS_NUM_ALL = -1;
    private static final int RECORDS_NUM_1000 = 1000;
    private static final int RECORDS_NUM_500 = 500;
    private static final int RECORDS_NUM_100 = 100;
    private static final int RECORDS_NUM_10 = 10;
    private TableViewer tviewer;
    private Table wtable;
    private Composite composite;
    private Composite tableContainer;
    private Combo recordsNumCombo;
    private Button cancelPreviewBtn;
    private ProgressBar progressBar;
    private Label infoMsg;
    private Composite infoComposite;
    private Color background;
    private IDataPreviewInfoProvider previewInfoProvider;
    private Job refreshPrevieDataJob;
    private DatasetReader dataReader;
    private boolean statusOK;
    private List<DataPreviewBean> previewItems;
    private TableFillerThread tableFiller;
    private int readItems = 0;
    private AQueryDesignerContainer designer;
    private static SimpleDateFormat TIMESTAMP = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSZ");
    private static SimpleDateFormat TIME = new SimpleDateFormat("HH:mm:ss.SSSS");
    private ToolBar toolbar;

    public DataPreviewTable(AQueryDesignerContainer designer, Composite parent, IDataPreviewInfoProvider previewInfoProvider, Color background) {
        this.previewInfoProvider = previewInfoProvider;
        this.designer = designer;
        this.previewItems = new ArrayList<DataPreviewBean>(100);
        this.background = background;
        this.createControl(parent);
    }

    private ToolBar getRunPreviewToolbar() {
        if (UIUtils.isMacOSX()) {
            ToolBar toolbar = new ToolBar(this.composite, 0x800800);
            toolbar.setForeground(UIUtils.getDisplay().getSystemColor(21));
            return toolbar;
        }
        return new ToolBar(this.composite, 0x800000);
    }

    private void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setBackground(this.background);
        this.composite.setLayout((Layout)new GridLayout(4, false));
        this.composite.addDisposeListener(e -> {
            this.statusOK = false;
            if (this.refreshPrevieDataJob != null) {
                this.refreshPrevieDataJob.cancel();
            }
        });
        this.toolbar = this.getRunPreviewToolbar();
        final ToolItem itemDrop = new ToolItem(this.toolbar, 4);
        itemDrop.setText(Messages.DataPreviewTable_PreviewButton);
        itemDrop.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private Menu dropMenu = null;
            private boolean getFields = false;

            public void widgetSelected(SelectionEvent e) {
                if (this.dropMenu == null) {
                    this.dropMenu = new Menu((Control)DataPreviewTable.this.composite);
                    DataPreviewTable.this.composite.setMenu(this.dropMenu);
                    MenuItem itemRadio = new MenuItem(this.dropMenu, 16);
                    itemRadio.setText(Messages.DataPreviewTable_PreviewButton);
                    itemRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            itemDrop.setText(Messages.DataPreviewTable_PreviewButton);
                            (this).DataPreviewTable.this.composite.update();
                            (this).DataPreviewTable.this.composite.layout(true);
                            getFields = false;
                            this.refresh();
                        }
                    });
                    MenuItem itemRadio2 = new MenuItem(this.dropMenu, 16);
                    itemRadio2.setText("Get Fields And Refresh Data");
                    itemRadio2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            itemDrop.setText("Get Fields And Refresh Data");
                            (this).DataPreviewTable.this.composite.update();
                            (this).DataPreviewTable.this.composite.layout(true);
                            getFields = true;
                            (this).DataPreviewTable.this.designer.doGetFields();
                            this.refresh();
                        }
                    });
                }
                if (e.detail == 4) {
                    ToolItem toolItem = (ToolItem)e.widget;
                    ToolBar toolBar = toolItem.getParent();
                    Point point = toolBar.toDisplay(new Point(e.x, e.y));
                    this.dropMenu.setLocation(point.x, point.y);
                    this.dropMenu.setVisible(true);
                } else {
                    if (this.getFields) {
                        DataPreviewTable.this.designer.doGetFields();
                    }
                    this.refresh();
                }
            }

            private boolean canRefreshDataPreview() {
                if (DataPreviewTable.this.composite.isDisposed()) {
                    return false;
                }
                if (DataPreviewTable.this.previewInfoProvider.getFieldsForPreview() == null || DataPreviewTable.this.previewInfoProvider.getFieldsForPreview().isEmpty()) {
                    MessageDialog.openError((Shell)DataPreviewTable.this.composite.getShell(), (String)Messages.DataPreviewTable_ErrorTitle, (String)Messages.DataPreviewTable_ErrorMsgNoFields);
                    return false;
                }
                if (DataPreviewTable.this.previewInfoProvider.getDataAdapterDescriptor() == null) {
                    MessageDialog.openError((Shell)DataPreviewTable.this.composite.getShell(), (String)Messages.DataPreviewTable_ErrorTitle, (String)Messages.DataPreviewTable_ErrorMsgNoDataAdapter);
                    return false;
                }
                return true;
            }

            protected void refresh() {
                if (this.canRefreshDataPreview()) {
                    DataPreviewTable.this.refreshDataPreview();
                    DataPreviewTable.this.toolbar.setEnabled(false);
                    DataPreviewTable.this.cancelPreviewBtn.setEnabled(true);
                }
            }
        });
        this.cancelPreviewBtn = new Button(this.composite, 8);
        this.cancelPreviewBtn.setText(Messages.DataPreviewTable_CancelButton);
        this.cancelPreviewBtn.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.cancelPreviewBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataPreviewTable.this.cancelDataPreview();
                DataPreviewTable.this.cancelPreviewBtn.setEnabled(false);
                DataPreviewTable.this.toolbar.setEnabled(true);
            }
        });
        this.cancelPreviewBtn.setEnabled(false);
        this.recordsNumCombo = new Combo(this.composite, 8);
        this.recordsNumCombo.setItems(new String[]{Messages.DataPreviewTable_0, Messages.DataPreviewTable_RecordsNum100, Messages.DataPreviewTable_RecordsNum500, Messages.DataPreviewTable_RecordsNum1000, Messages.DataPreviewTable_RecordsNumAll});
        this.recordsNumCombo.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.recordsNumCombo.select(0);
        this.infoComposite = new Composite(this.composite, 0);
        GridLayout infoCmpGL = new GridLayout(2, false);
        infoCmpGL.marginHeight = 0;
        infoCmpGL.marginWidth = 0;
        this.infoComposite.setBackground(this.background);
        this.infoComposite.setLayout((Layout)infoCmpGL);
        this.infoComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.infoMsg = new Label(this.infoComposite, 0);
        this.infoMsg.setBackground(this.background);
        this.infoMsg.setText(Messages.DataPreviewTable_Ready);
        this.infoMsg.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        this.progressBar = new ProgressBar(this.infoComposite, 2050);
        GridData progBarGD = new GridData(131072, 0x1000000, false, false);
        progBarGD.horizontalIndent = 5;
        progBarGD.widthHint = 100;
        progBarGD.exclude = true;
        this.progressBar.setLayoutData((Object)progBarGD);
        this.progressBar.setVisible(false);
        this.tableContainer = new Composite(this.composite, 0);
        this.tableContainer.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        this.tableContainer.setLayout((Layout)new TableColumnLayout());
        this.tviewer = new TableViewer(this.tableContainer, 68098);
        this.wtable = this.tviewer.getTable();
        this.wtable.setHeaderVisible(true);
        this.wtable.setLinesVisible(true);
        this.tviewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        Menu menu = new Menu((Control)this.tviewer.getTable());
        MenuItem mitem = new MenuItem(menu, 0);
        mitem.setText(Messages.DataPreviewTable_1);
        mitem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new CopyDataDialog(DataPreviewTable.this.tableContainer.getShell(), DataPreviewTable.this).open();
            }
        });
        this.tviewer.getTable().setMenu(menu);
    }

    public Composite getControl() {
        return this.composite;
    }

    private void refreshDataPreview() {
        this.updateTableLayout();
        final int recordsCountSelected = this.getRecordsCountSelected();
        this.refreshPrevieDataJob = new Job(Messages.DataPreviewTable_PreviewDataJobTitle){

            protected IStatus run(IProgressMonitor monitor) {
                if (DataPreviewTable.this.dataReader != null) {
                    DataPreviewTable.this.dataReader.removeDatasetReaderListener(DataPreviewTable.this);
                    DataPreviewTable.this.dataReader = null;
                }
                DataPreviewTable.this.dataReader = new DatasetReader();
                DataPreviewTable.this.dataReader.setColumns(DataPreviewTable.this.getColumns());
                DataPreviewTable.this.dataReader.setDataAdapterDescriptor(DataPreviewTable.this.previewInfoProvider.getDataAdapterDescriptor());
                JRDesignDataset clonedDS = (JRDesignDataset)DataPreviewTable.this.previewInfoProvider.getDesignDataset().clone();
                clonedDS.getFieldsList().clear();
                clonedDS.getFieldsMap().clear();
                for (JRDesignField f : DataPreviewTable.this.previewInfoProvider.getFieldsForPreview()) {
                    try {
                        clonedDS.addField((JRField)f);
                    }
                    catch (JRException e) {
                        e.printStackTrace();
                    }
                }
                DataPreviewTable.this.dataReader.setDesignDataset(clonedDS);
                DataPreviewTable.this.dataReader.setMaxRecords(recordsCountSelected);
                DataPreviewTable.this.dataReader.addDatasetReaderListener(DataPreviewTable.this);
                DataPreviewTable.this.dataReader.start(DataPreviewTable.this.previewInfoProvider.getJasperReportsConfig(), monitor);
                return Status.OK_STATUS;
            }
        };
        this.tableFiller = new TableFillerThread();
        this.statusOK = true;
        this.infoMsg.setText(Messages.DataPreviewTable_GettingData);
        ((GridData)this.progressBar.getLayoutData()).exclude = false;
        this.progressBar.setVisible(true);
        this.refreshPrevieDataJob.schedule();
        this.tableFiller.start();
        this.infoComposite.layout();
    }

    private void cancelDataPreview() {
        this.invalidate();
        if (this.refreshPrevieDataJob != null) {
            this.refreshPrevieDataJob.cancel();
        }
        if (this.dataReader.isRunning()) {
            this.dataReader.stop();
        }
        this.infoMsg.setText(Messages.DataPreviewTable_Ready);
        ((GridData)this.progressBar.getLayoutData()).exclude = true;
        this.progressBar.setVisible(false);
    }

    private int getRecordsCountSelected() {
        switch (this.recordsNumCombo.getSelectionIndex()) {
            case 0: {
                return 10;
            }
            case 1: {
                return 100;
            }
            case 2: {
                return 500;
            }
            case 3: {
                return 1000;
            }
            case 4: {
                return -1;
            }
        }
        return 10;
    }

    public List<String> getColumns() {
        ArrayList<String> columns = new ArrayList<String>();
        for (JRDesignField f : this.previewInfoProvider.getFieldsForPreview()) {
            columns.add(f.getName());
        }
        return columns;
    }

    public List<JRDesignField> getFields() {
        return this.previewInfoProvider.getFieldsForPreview();
    }

    private void updateTableLayout() {
        if (this.composite.isVisible()) {
            this.wtable.removeAll();
            this.tviewer.setInput(null);
            TableColumn[] tableColumnArray = this.wtable.getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn col = tableColumnArray[n2];
                col.dispose();
                ++n2;
            }
            TableColumnLayout tColLayout = new TableColumnLayout();
            this.tableContainer.setLayout((Layout)tColLayout);
            List<JRDesignField> fields = this.previewInfoProvider.getFieldsForPreview();
            if (!fields.isEmpty()) {
                for (JRDesignField f : fields) {
                    TableViewerColumn tvc = new TableViewerColumn(this.tviewer, 0);
                    tvc.getColumn().setText(f.getName());
                    tvc.setLabelProvider((CellLabelProvider)new ColumnLabelProvider());
                    tColLayout.setColumnData((Widget)tvc.getColumn(), (ColumnLayoutData)new ColumnWeightData(1, 20, true));
                    tvc.setLabelProvider(new CellLabelProvider(){

                        public void update(ViewerCell cell) {
                            DataPreviewBean element = (DataPreviewBean)cell.getElement();
                            Object value = element.getValue(cell.getColumnIndex());
                            if (value != null) {
                                if (value instanceof Time) {
                                    cell.setText(TIME.format(value));
                                } else if (value instanceof Timestamp) {
                                    cell.setText(TIMESTAMP.format(value));
                                } else {
                                    cell.setText(value.toString());
                                }
                            } else {
                                cell.setText("");
                            }
                        }
                    });
                }
            }
            this.tableContainer.layout();
        }
    }

    @Override
    public void newRecord(Object[] values) {
        this.previewItems.add(new DataPreviewBean(values));
        ++this.readItems;
    }

    @Override
    public void finished() {
        UIUtils.getDisplay().syncExec(() -> {
            if (this.progressBar.isDisposed()) {
                return;
            }
            if (this.tableFiller != null) {
                this.tableFiller.done();
                this.tableFiller = null;
            }
            this.flushPreviewItems();
            this.progressBar.setVisible(false);
            this.cancelPreviewBtn.setEnabled(false);
            ((GridData)this.progressBar.getLayoutData()).exclude = true;
            if (this.isValidStatus()) {
                this.infoMsg.setText(MessageFormat.format(Messages.DataPreviewTable_ReadyReadData, this.readItems));
            }
            this.toolbar.setEnabled(true);
            this.infoComposite.layout();
            this.readItems = 0;
        });
    }

    @Override
    public boolean isValidStatus() {
        return this.statusOK;
    }

    @Override
    public void invalidate() {
        this.statusOK = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushPreviewItems() {
        Object[] tmpItems = null;
        List<DataPreviewBean> list = this.previewItems;
        synchronized (list) {
            tmpItems = this.previewItems.toArray();
            this.previewItems.clear();
        }
        Object[] items = tmpItems;
        UIUtils.getDisplay().syncExec(() -> {
            if (!this.wtable.isDisposed() && this.statusOK) {
                this.tviewer.add(items);
            }
        });
    }

    public List<DataPreviewBean> getPreviewItems() {
        ArrayList<DataPreviewBean> res = new ArrayList<DataPreviewBean>();
        TableItem[] tableItemArray = this.tviewer.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem ti = tableItemArray[n2];
            res.add((DataPreviewBean)ti.getData());
            ++n2;
        }
        return res;
    }

    public class DataPreviewBean {
        private Object[] values;

        public DataPreviewBean(Object[] values) {
            this.values = values;
        }

        public Object getValue(int index) {
            return this.values[index];
        }
    }

    private class TableFillerThread
    extends Thread {
        private boolean done = false;

        private TableFillerThread() {
        }

        public void done() {
            this.done = true;
        }

        @Override
        public void run() {
            while (!this.done) {
                DataPreviewTable.this.flushPreviewItems();
                try {
                    TableFillerThread.sleep(30L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

