/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.descriptor;

import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.property.IRefreshableCellEditor;
import java.text.MessageFormat;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class JSSDialogCellEditor
extends CellEditor
implements IRefreshableCellEditor {
    public static final String CELL_EDITOR_IMG_DOTS_BUTTON = "cell_editor_dots_button_image";
    private Composite editor;
    private Control contents;
    private Label defaultLabel;
    private Button button;
    private boolean allowNullValue;
    private FocusListener buttonFocusListener;
    private Object value = null;
    private static final int defaultStyle = 0;

    static {
        ImageRegistry reg = JFaceResources.getImageRegistry();
        reg.put(CELL_EDITOR_IMG_DOTS_BUTTON, ImageDescriptor.createFromFile(DialogCellEditor.class, (String)"images/dots_button.gif"));
    }

    public JSSDialogCellEditor() {
        this.setStyle(0);
        this.allowNullValue = false;
    }

    protected JSSDialogCellEditor(Composite parent, boolean allowNullValue) {
        this(parent, 0, allowNullValue);
    }

    protected JSSDialogCellEditor(Composite parent, int style, boolean allowNullValue) {
        super(parent, style);
        this.allowNullValue = allowNullValue;
    }

    protected Button createButton(Composite parent) {
        Button result = new Button(parent, 1024);
        result.setText("...");
        return result;
    }

    protected Control createContents(Composite cell) {
        this.defaultLabel = new Label(cell, 16384);
        this.defaultLabel.setFont(cell.getFont());
        this.defaultLabel.setBackground(cell.getBackground());
        return this.defaultLabel;
    }

    protected Control createControl(Composite parent) {
        Font font = parent.getFont();
        Color bg = parent.getBackground();
        this.editor = new Composite(parent, this.getStyle());
        this.editor.setFont(font);
        this.editor.setBackground(bg);
        this.editor.setLayout((Layout)new DialogCellLayout());
        this.contents = this.createContents(this.editor);
        this.updateContents(this.value);
        this.button = this.createButton(this.editor);
        this.button.setFont(font);
        this.button.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\u001b') {
                    JSSDialogCellEditor.this.fireCancelEditor();
                }
            }
        });
        this.button.addFocusListener(this.getButtonFocusListener());
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JSSDialogCellEditor.this.button.removeFocusListener(JSSDialogCellEditor.this.getButtonFocusListener());
                Object newValue = JSSDialogCellEditor.this.openDialogBox((Control)JSSDialogCellEditor.this.editor);
                JSSDialogCellEditor.this.button.addFocusListener(JSSDialogCellEditor.this.getButtonFocusListener());
                if (newValue != null || JSSDialogCellEditor.this.allowNullValue) {
                    boolean newValidState = JSSDialogCellEditor.this.isCorrect(newValue);
                    if (newValidState) {
                        JSSDialogCellEditor.this.markDirty();
                        JSSDialogCellEditor.this.doSetValue(newValue);
                    } else {
                        JSSDialogCellEditor.this.setErrorMessage(MessageFormat.format(JSSDialogCellEditor.this.getErrorMessage(), newValue.toString()));
                    }
                    JSSDialogCellEditor.this.fireApplyEditorValue();
                }
            }
        });
        this.setValueValid(true);
        return this.editor;
    }

    public void deactivate() {
        if (this.button != null && !this.button.isDisposed()) {
            this.button.removeFocusListener(this.getButtonFocusListener());
        }
        super.deactivate();
    }

    protected Object doGetValue() {
        return this.value;
    }

    protected void doSetFocus() {
        this.button.setFocus();
        this.button.addFocusListener(this.getButtonFocusListener());
    }

    private FocusListener getButtonFocusListener() {
        if (this.buttonFocusListener == null) {
            this.buttonFocusListener = new FocusListener(){

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                    JSSDialogCellEditor.this.focusLost();
                }
            };
        }
        return this.buttonFocusListener;
    }

    protected void doSetValue(Object value) {
        this.value = value;
        this.updateContents(value);
    }

    protected Label getDefaultLabel() {
        return this.defaultLabel;
    }

    protected abstract Object openDialogBox(Control var1);

    protected void updateContents(Object value) {
        if (this.defaultLabel == null) {
            return;
        }
        String text = "";
        if (value != null) {
            text = value.toString();
        }
        this.defaultLabel.setText(text);
    }

    @Override
    public void refresh(ANode selectedModel) {
        if (this.editor != null && !this.editor.isDisposed()) {
            this.editor.setEnabled(selectedModel.isEditable());
        }
        if (this.button != null && !this.button.isDisposed()) {
            this.button.setEnabled(selectedModel.isEditable());
        }
    }

    private class DialogCellLayout
    extends Layout {
        private DialogCellLayout() {
        }

        public void layout(Composite editor, boolean force) {
            Rectangle bounds = editor.getClientArea();
            Point size = JSSDialogCellEditor.this.button.computeSize(-1, -1, force);
            if (JSSDialogCellEditor.this.contents != null) {
                JSSDialogCellEditor.this.contents.setBounds(0, 0, bounds.width - size.x, bounds.height);
            }
            JSSDialogCellEditor.this.button.setBounds(bounds.width - size.x, 0, size.x, bounds.height);
        }

        public Point computeSize(Composite editor, int wHint, int hHint, boolean force) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            Point contentsSize = JSSDialogCellEditor.this.contents.computeSize(-1, -1, force);
            Point buttonSize = JSSDialogCellEditor.this.button.computeSize(-1, -1, force);
            Point result = new Point(buttonSize.x, Math.max(contentsSize.y, buttonSize.y));
            return result;
        }
    }
}

