/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.descriptor.checkbox;

import com.jaspersoft.studio.help.HelpSystem;
import com.jaspersoft.studio.help.IHelp;
import com.jaspersoft.studio.help.IHelpRefBuilder;
import com.jaspersoft.studio.jface.BooleanCellEditorValidator;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.property.descriptor.checkbox.BCheckBoxCellEditor;
import com.jaspersoft.studio.property.descriptor.checkbox.CheckBoxLabelProvider;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.widgets.ASPropertyWidget;
import com.jaspersoft.studio.property.section.widgets.IPropertyDescriptorWidget;
import com.jaspersoft.studio.property.section.widgets.SP3Boolean;
import com.jaspersoft.studio.property.section.widgets.SPBoolean;
import com.jaspersoft.studio.property.section.widgets.SPBooleanNoText;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class CheckBoxPropertyDescriptor
extends PropertyDescriptor
implements IPropertyDescriptorWidget,
IHelp {
    private NullEnum canBeNull;
    private boolean showTextOnButton = true;
    private IHelpRefBuilder refBuilder;

    public CheckBoxPropertyDescriptor(Object id, String displayName, NullEnum canBeNull) {
        super(id, displayName);
        this.setValidator(new BooleanCellEditorValidator(canBeNull));
        this.canBeNull = canBeNull;
    }

    public CheckBoxPropertyDescriptor(Object id, String displayName) {
        this(id, displayName, NullEnum.NOTNULL);
    }

    public CellEditor createPropertyEditor(Composite parent) {
        BCheckBoxCellEditor editor = new BCheckBoxCellEditor(parent, this.canBeNull);
        if (this.getValidator() != null) {
            editor.setValidator(this.getValidator());
        }
        HelpSystem.bindToHelp((IPropertyDescriptor)this, editor.getControl());
        return editor;
    }

    public void setShowTextOnButton(boolean value) {
        this.showTextOnButton = value;
    }

    public ILabelProvider getLabelProvider() {
        if (this.isLabelProviderSet()) {
            return super.getLabelProvider();
        }
        return new CheckBoxLabelProvider(this.canBeNull, false);
    }

    public ASPropertyWidget<CheckBoxPropertyDescriptor> createWidget(Composite parent, AbstractSection section) {
        if (!this.showTextOnButton && this.canBeNull == NullEnum.NOTNULL) {
            return new SPBooleanNoText<CheckBoxPropertyDescriptor>(parent, section, this);
        }
        if (this.canBeNull == NullEnum.NOTNULL) {
            return new SPBoolean<CheckBoxPropertyDescriptor>(parent, section, this);
        }
        return new SP3Boolean<CheckBoxPropertyDescriptor>(parent, section, this);
    }

    @Override
    public void setHelpRefBuilder(IHelpRefBuilder refBuilder) {
        this.refBuilder = refBuilder;
    }

    @Override
    public String getHelpReference() {
        if (this.refBuilder != null) {
            return this.refBuilder.getHelpReference();
        }
        return null;
    }
}

