/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.descriptor.classname.dialog;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.preferences.editor.table.TableLabelProvider;
import com.jaspersoft.studio.swt.widgets.table.DeleteButton;
import com.jaspersoft.studio.swt.widgets.table.INewElement;
import com.jaspersoft.studio.swt.widgets.table.ListContentProvider;
import com.jaspersoft.studio.swt.widgets.table.NewButton;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.jasperreports.eclipse.ui.util.PersistentLocationDialog;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.StringUtils;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.dialogs.SelectionDialog;

public class ImportDialog
extends PersistentLocationDialog {
    private String value;
    private TableViewer tableViewer;
    private List<String> imports;
    private NotEmptyValidator importValidator = new NotEmptyValidator();

    public ImportDialog(Shell parentShell, String value) {
        super(parentShell);
        this.value = value;
    }

    public String getImports() {
        this.value = "";
        for (String str : this.imports) {
            this.value = String.valueOf(this.value) + str + ";";
        }
        return this.value;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.ImportDialog_2);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.buildTable(composite);
        Composite bGroup = new Composite(composite, 0);
        bGroup.setLayout((Layout)new GridLayout(1, false));
        bGroup.setLayoutData((Object)new GridData(1040));
        bGroup.setBackground(parent.getBackground());
        NewButton bnew = new NewButton();
        bnew.createNewButtons(bGroup, this.tableViewer, new INewElement(){

            @Override
            public Object newElement(List<?> input, int pos) {
                Object[] objects;
                String[] results = null;
                SelectionDialog dialog = JavaUI.createPackageDialog((Shell)ImportDialog.this.getShell(), (IRunnableContext)new ProgressMonitorDialog(ImportDialog.this.getShell()), (IJavaSearchScope)SearchEngine.createWorkspaceScope(), (boolean)true, (boolean)true, null);
                dialog.setTitle(Messages.ImportDialog_3);
                if (dialog.open() == 0 && (objects = dialog.getResult()) != null && objects.length > 0) {
                    results = new String[objects.length];
                    int i = 0;
                    while (i < objects.length) {
                        JavaElement jpf = (JavaElement)objects[i];
                        results[i] = String.valueOf(jpf.getElementName()) + ".*";
                        ++i;
                    }
                }
                return results;
            }
        });
        bnew.setButtonText(Messages.ImportDialog_4);
        bnew = new NewButton();
        bnew.createNewButtons(bGroup, this.tableViewer, new INewElement(){

            @Override
            public Object newElement(List<?> input, int pos) {
                try {
                    String[] results = null;
                    IJavaSearchScope searchScope = SearchEngine.createWorkspaceScope();
                    SelectionDialog dialog = JavaUI.createTypeDialog((Shell)ImportDialog.this.getShell(), (IRunnableContext)new ProgressMonitorDialog(ImportDialog.this.getShell()), (IJavaSearchScope)searchScope, (int)256, (boolean)true);
                    dialog.setTitle(Messages.ClassTypeCellEditor_open_type);
                    dialog.setMessage(Messages.ClassTypeCellEditor_dialog_message);
                    if (dialog.open() == 0) {
                        Object[] objects = dialog.getResult();
                        if (objects != null && objects.length > 0) {
                            results = new String[objects.length];
                            int i = 0;
                            while (i < objects.length) {
                                if (objects[i] instanceof IType) {
                                    IType bt = (IType)objects[i];
                                    results[i] = bt.getFullyQualifiedName('.');
                                }
                                ++i;
                            }
                        }
                        return results;
                    }
                }
                catch (JavaModelException e) {
                    UIUtils.showError((Throwable)e);
                }
                return null;
            }
        });
        bnew.setButtonText(Messages.ImportDialog_5);
        NewButton customBtn = new NewButton();
        customBtn.createNewButtons(bGroup, this.tableViewer, new INewElement(){

            @Override
            public Object newElement(List<?> input, int pos) {
                InputDialog id = new InputDialog(ImportDialog.this.getShell(), Messages.ImportDialog_AddCustomTitle, Messages.ImportDialog_AddCustomMsg, null, (IInputValidator)ImportDialog.this.importValidator);
                if (id.open() == 0) {
                    return new String[]{id.getValue()};
                }
                return null;
            }
        });
        customBtn.setButtonText(Messages.ImportDialog_AddCustomBtn);
        DeleteButton bdel = new DeleteButton();
        bdel.createDeleteButton(bGroup, this.tableViewer);
        this.imports = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(this.value, ";");
        while (st.hasMoreTokens()) {
            this.imports.add(st.nextToken());
        }
        this.tableViewer.setInput(this.imports);
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TableItem[] selection = ImportDialog.this.tableViewer.getTable().getSelection();
                TableItem selectedItem = null;
                if (selection != null && selection.length == 1) {
                    selectedItem = selection[0];
                }
                if (selectedItem != null) {
                    int selectionIndex = ImportDialog.this.tableViewer.getTable().getSelectionIndex();
                    InputDialog id = new InputDialog(ImportDialog.this.getShell(), Messages.ImportDialog_EditCustomTitle, Messages.ImportDialog_EditCustomMsg, selectedItem.getText(), (IInputValidator)ImportDialog.this.importValidator);
                    if (id.open() == 0) {
                        ImportDialog.this.imports.remove(selectionIndex);
                        ImportDialog.this.imports.add(selectionIndex, id.getValue());
                        ImportDialog.this.tableViewer.setInput(ImportDialog.this.imports);
                    }
                }
            }
        });
        return composite;
    }

    private void buildTable(Composite composite) {
        Table table = new Table(composite, 67586);
        GridData gd = new GridData(1808);
        gd.minimumHeight = 400;
        gd.minimumWidth = 400;
        table.setLayoutData((Object)gd);
        table.setHeaderVisible(false);
        table.setLinesVisible(true);
        this.tableViewer = new TableViewer(table);
        this.attachContentProvider(this.tableViewer);
        this.attachLabelProvider(this.tableViewer);
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        table.setLayout((Layout)tlayout);
        TableColumn[] column = new TableColumn[]{new TableColumn(table, 0)};
        int i = 0;
        int n = column.length;
        while (i < n) {
            column[i].pack();
            ++i;
        }
    }

    private void attachLabelProvider(TableViewer viewer) {
        viewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
    }

    private void attachContentProvider(TableViewer viewer) {
        viewer.setContentProvider((IContentProvider)new ListContentProvider());
    }

    private class NotEmptyValidator
    implements IInputValidator {
        private NotEmptyValidator() {
        }

        public String isValid(String newText) {
            if (StringUtils.isNullOrEmpty((String)newText)) {
                return Messages.ImportDialog_EmptyImportErrorMsg;
            }
            return null;
        }
    }
}

