/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.descriptor.parameter.dialog;

import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.editor.expression.IExpressionContextSetter;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.property.descriptor.parameter.dialog.GenericJSSParameter;
import com.jaspersoft.studio.property.descriptor.parameter.dialog.InputParameterDialog;
import com.jaspersoft.studio.swt.widgets.table.ListContentProvider;
import com.jaspersoft.studio.swt.widgets.table.ListOrderButtons;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ParameterPage
extends WizardPage
implements IExpressionContextSetter {
    protected List<GenericJSSParameter> values = new ArrayList<GenericJSSParameter>();
    private Table table;
    protected TableViewer tableViewer;
    private ExpressionContext expContext;
    private Button editButton;
    private Button deleteButton;
    private Button addButton;

    public ParameterPage() {
        super("parameterseditorpage");
        this.setTitle(this.getPageTitle());
        this.setDescription(this.getPageDescription());
    }

    public List<GenericJSSParameter> getValue() {
        return this.values;
    }

    public void setValue(List<GenericJSSParameter> values) {
        this.values.clear();
        this.values.addAll(values);
        if (this.table != null) {
            this.fillTable();
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        this.setControl((Control)composite);
        this.buildTable(composite);
        GridData gd = new GridData(1808);
        gd.heightHint = 400;
        this.table.setLayoutData((Object)gd);
        Composite bGroup = new Composite(composite, 0);
        bGroup.setLayout((Layout)new GridLayout(1, false));
        bGroup.setLayoutData((Object)new GridData(1040));
        this.generateButtons(bGroup);
    }

    protected void generateButtons(Composite bGroup) {
        this.addButton = new Button(bGroup, 8);
        this.addButton.setText(Messages.common_add);
        this.addButton.setLayoutData((Object)new GridData(768));
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputParameterDialog inputDialog = ParameterPage.this.getEditDialog(new GenericJSSParameter(), ParameterPage.this.values);
                inputDialog.setExpressionContext(ParameterPage.this.expContext);
                if (inputDialog.open() == 0) {
                    ParameterPage.this.values.add(inputDialog.getValue());
                    ParameterPage.this.tableViewer.refresh();
                }
            }
        });
        this.editButton = new Button(bGroup, 8);
        this.editButton.setText(Messages.common_edit);
        this.editButton.setLayoutData((Object)new GridData(768));
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection selection = (StructuredSelection)ParameterPage.this.tableViewer.getSelection();
                if (selection.size() > 0) {
                    GenericJSSParameter selectedValue = (GenericJSSParameter)selection.getFirstElement();
                    ParameterPage.this.editElement(selectedValue);
                }
            }
        });
        this.editButton.setEnabled(false);
        this.deleteButton = new Button(bGroup, 8);
        this.deleteButton.setText(Messages.common_delete);
        this.deleteButton.setLayoutData((Object)new GridData(768));
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection selection = (StructuredSelection)ParameterPage.this.tableViewer.getSelection();
                if (selection.size() > 0) {
                    GenericJSSParameter selectedValue = (GenericJSSParameter)selection.getFirstElement();
                    int index = ParameterPage.this.values.indexOf(selectedValue);
                    ParameterPage.this.values.remove(index);
                    ParameterPage.this.tableViewer.refresh();
                }
            }
        });
        this.deleteButton.setEnabled(false);
        new ListOrderButtons().createOrderButtons(bGroup, this.tableViewer);
    }

    private void editElement(GenericJSSParameter edited) {
        GenericJSSParameter result = edited.clone();
        InputParameterDialog inputDialog = this.getEditDialog(result, this.values);
        inputDialog.setExpressionContext(this.expContext);
        if (inputDialog.open() == 0) {
            int index = this.values.indexOf(edited);
            this.values.set(index, result);
            this.tableViewer.refresh();
        }
    }

    private void buildTable(Composite composite) {
        this.table = new Table(composite, 68100);
        this.table.setHeaderVisible(true);
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TLabelProvider());
        this.attachCellEditors(this.tableViewer);
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 75, true));
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 75, true));
        this.table.setLayout((Layout)tlayout);
        TableColumn[] column = new TableColumn[2];
        column[0] = new TableColumn(this.table, 0);
        column[0].setText(Messages.common_name);
        column[1] = new TableColumn(this.table, 0);
        column[1].setText(Messages.common_expression);
        int i = 0;
        int n = column.length;
        while (i < n) {
            column[i].pack();
            ++i;
        }
        this.fillTable();
    }

    private void attachCellEditors(TableViewer viewer) {
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                int selectedIndex = ParameterPage.this.table.getSelectionIndex();
                if (selectedIndex != -1) {
                    GenericJSSParameter selectedElement = ParameterPage.this.values.get(selectedIndex);
                    ParameterPage.this.editElement(selectedElement);
                }
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                int selectedIndex = ParameterPage.this.table.getSelectionIndex();
                boolean buttonEnabled = selectedIndex != -1;
                ParameterPage.this.editButton.setEnabled(buttonEnabled);
                ParameterPage.this.deleteButton.setEnabled(buttonEnabled);
            }
        });
        viewer.setColumnProperties(new String[]{"NAME", "VALUE"});
        viewer.setLabelProvider((IBaseLabelProvider)new TLabelProvider());
    }

    protected void fillTable() {
        if (this.values != null) {
            this.tableViewer.setInput(this.values);
        }
    }

    @Override
    public void setExpressionContext(ExpressionContext expContext) {
        this.expContext = expContext;
    }

    public String getPageTitle() {
        return Messages.ParameterPage_dataset_parameters;
    }

    public String getPageDescription() {
        return Messages.ParameterPage_description;
    }

    protected InputParameterDialog getEditDialog(GenericJSSParameter editedParameter, List<GenericJSSParameter> prevParams) {
        return new InputParameterDialog(this.getShell(), editedParameter, prevParams);
    }

    private final class TLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ((GenericJSSParameter)element).getName();
                }
                case 1: {
                    GenericJSSParameter value2 = (GenericJSSParameter)element;
                    if (value2 == null || value2.getExpression() == null) break;
                    return value2.getExpression().getText();
                }
            }
            return "";
        }
    }
}

