/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.descriptor.pattern.dialog;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.property.descriptor.pattern.dialog.APattern;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;

public class NumericPattern
extends APattern {
    private Spinner zeroes;
    private Spinner decimals;
    private Button sep;
    private boolean isRefreshing = false;
    protected List<String> dList;
    protected org.eclipse.swt.widgets.List list;

    public NumericPattern(Composite parent, String value) {
        this(parent, NumberFormat.getNumberInstance(), value);
    }

    public NumericPattern(Composite parent, Format formatter, String value) {
        super(parent, formatter, new BigDecimal("-10023.1234567654"), value);
        this.setDescription(Messages.NumericPattern_description);
    }

    @Override
    public void setValue(String value) {
        super.setValue(value);
        this.backparsePattern();
    }

    private void backparsePattern() {
        if (!this.value.isEmpty()) {
            this.isRefreshing = true;
            try {
                DecimalFormat backParser = new DecimalFormat(this.value);
                this.zeroes.setSelection(backParser.getMinimumIntegerDigits());
                this.decimals.setSelection(backParser.getMinimumFractionDigits());
                this.sep.setSelection(backParser.isGroupingUsed() && backParser.getGroupingSize() == 3);
                this.setFormatter(backParser);
                this.setPattern(backParser.toPattern());
                this.formatChanged();
            }
            catch (Exception ex) {
                JaspersoftStudioPlugin.getInstance().logError(ex);
            }
            this.isRefreshing = false;
        }
    }

    @Override
    public Control createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, true));
        Label lab = new Label(container, 0x1000000);
        lab.setText(Messages.NumericPattern_leading_zeroes);
        lab = new Label(container, 0x1000000);
        lab.setText(String.valueOf(Messages.NumericPattern_decimal_places) + ":");
        this.zeroes = new Spinner(container, 2048);
        this.zeroes.setMinimum(0);
        this.zeroes.setMaximum(100);
        this.zeroes.setSelection(1);
        this.zeroes.setIncrement(1);
        this.zeroes.setPageIncrement(10);
        this.zeroes.setLayoutData((Object)new GridData(768));
        this.decimals = new Spinner(container, 2048);
        this.decimals.setMinimum(0);
        this.decimals.setMaximum(100);
        this.decimals.setSelection(2);
        this.decimals.setIncrement(1);
        this.decimals.setPageIncrement(10);
        this.decimals.setLayoutData((Object)new GridData(768));
        this.sep = new Button(container, 32);
        this.sep.setText(Messages.NumericPattern_use_1000_sperator);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.sep.setLayoutData((Object)gd);
        this.list = new org.eclipse.swt.widgets.List(container, 2048);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        gd.heightHint = 200;
        gd.widthHint = 100;
        this.list.setLayoutData((Object)gd);
        DecimalFormat f = (DecimalFormat)this.getFormatter();
        for (String s : this.getDefaults()) {
            f.applyPattern(s);
            this.list.add(f.format(this.getSample()));
        }
        this.backparsePattern();
        this.sep.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!NumericPattern.this.isRefreshing) {
                    DecimalFormat d = (DecimalFormat)NumericPattern.this.getFormatter();
                    d.setGroupingUsed(((Button)e.widget).getSelection());
                    d.setGroupingSize(3);
                    NumericPattern.this.setPattern(d.toPattern());
                    NumericPattern.this.value = d.toPattern();
                    NumericPattern.this.formatChanged();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.decimals.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!NumericPattern.this.isRefreshing) {
                    DecimalFormat d = (DecimalFormat)NumericPattern.this.getFormatter();
                    d.setMinimumFractionDigits(NumericPattern.this.decimals.getSelection());
                    NumericPattern.this.setPattern(d.toPattern());
                    NumericPattern.this.value = d.toPattern();
                    NumericPattern.this.formatChanged();
                }
            }
        });
        this.zeroes.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!NumericPattern.this.isRefreshing) {
                    DecimalFormat d = (DecimalFormat)NumericPattern.this.getFormatter();
                    d.setMinimumIntegerDigits(NumericPattern.this.zeroes.getSelection());
                    NumericPattern.this.setPattern(d.toPattern());
                    NumericPattern.this.value = d.toPattern();
                    NumericPattern.this.formatChanged();
                }
            }
        });
        this.list.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int sel = NumericPattern.this.list.getSelectionIndex();
                if (sel >= 0) {
                    NumericPattern.this.setPattern(NumericPattern.this.dList.get(sel));
                }
                NumericPattern.this.formatChanged();
                DecimalFormat d = (DecimalFormat)NumericPattern.this.getFormatter();
                NumericPattern.this.sep.setSelection(d.isGroupingUsed());
                NumericPattern.this.zeroes.setSelection(d.getMinimumIntegerDigits());
                NumericPattern.this.decimals.setSelection(d.getMinimumFractionDigits());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return container;
    }

    protected List<String> getDefaults() {
        if (this.dList == null) {
            this.dList = new ArrayList<String>();
            this.dList.add("#,##0.###;#,-##0.###");
            this.dList.add("#,##0.###;#,##0.###-");
            this.dList.add("#,##0.###;(#,##0.###)");
            this.dList.add("#,##0.###;(-#,##0.###)");
            this.dList.add("#,##0.###;(#,##0.###-)");
            this.setPattern(this.dList.get(0));
        }
        return this.dList;
    }
}

