/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.descriptor.properties.dialog;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.action.copy.PastableProperties;
import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.help.TableHelpListener;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.CopyElementExpressionProperty;
import com.jaspersoft.studio.model.CopyElementProperty;
import com.jaspersoft.studio.model.ICopyable;
import com.jaspersoft.studio.property.dataset.fields.table.TColumn;
import com.jaspersoft.studio.property.dataset.fields.table.TColumnFactory;
import com.jaspersoft.studio.property.dataset.fields.table.widget.AWidget;
import com.jaspersoft.studio.property.descriptor.properties.dialog.PropertyDTO;
import com.jaspersoft.studio.property.descriptor.properties.dialog.TPropertyLabelProvider;
import com.jaspersoft.studio.property.descriptor.propexpr.dialog.HintsPropertiesList;
import com.jaspersoft.studio.property.descriptor.propexpr.dialog.JRPropertyDialog;
import com.jaspersoft.studio.swt.widgets.table.ListContentProvider;
import com.jaspersoft.studio.swt.widgets.table.ListOrderButtons;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.wizards.ContextHelpIDs;
import com.jaspersoft.studio.wizards.JSSHelpWizardPage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.properties.PropertyMetadata;
import net.sf.jasperreports.properties.StandardPropertyMetadata;
import org.apache.commons.collections4.comparators.NullComparator;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.gef.ui.actions.Clipboard;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;

public class JRPropertyPage
extends JSSHelpWizardPage {
    private JRPropertiesMap value;
    private List<PropertyDTO> props = new ArrayList<PropertyDTO>();
    private Map<String, PropertyMetadata> propsMap = new HashMap<String, PropertyMetadata>();
    private JasperReportsConfiguration jConfig;
    private Object jrElement;
    private ExpressionContext eContext;
    private boolean added = true;
    private boolean refreshing = false;
    private boolean canceled = false;
    private String search;
    private Composite propCmp;
    private StackLayout propCmpLayout;
    private Composite tblCmp;
    private Text txt;
    private ToolBar buttons;
    private ScrolledComposite sc;
    private Composite cmp;
    private boolean showExisting = false;
    private List<PropertyMetadata> eds;
    private List<PropertyMetadata> sortedEDS;
    private Table table;
    private TableViewer tableViewer;
    private Button editButton;
    private Button deleteButton;
    private Composite scmp;
    private ToolItem badd;
    private ToolItem bSystem;

    public void dispose() {
        JRPropertiesMap v = new JRPropertiesMap();
        for (PropertyDTO p : this.props) {
            if (p.getName() == null || p.getName().equals("")) continue;
            v.setProperty(p.getName(), p.getValue());
        }
        super.dispose();
    }

    public void setValue(JRPropertiesMap value) {
        this.value = value;
        if (this.table != null) {
            this.fillTable();
        }
    }

    protected JRPropertyPage(String pageName, JasperReportsConfiguration jConfig, Object jrElement) {
        super(pageName);
        this.setTitle(Messages.common_properties);
        this.setDescription(Messages.JRPropertyPage_description);
        this.jConfig = jConfig;
        this.eContext = new ExpressionContext(jConfig);
        this.jrElement = jrElement;
    }

    @Override
    protected String getContextName() {
        return ContextHelpIDs.WIZARD_PROPERTIES;
    }

    public void createControl(Composite parent) {
        this.getShell().addListener(31, e -> {
            if (e.detail == 4) {
                e.doit = false;
            }
        });
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.setControl((Control)composite);
        this.createButtons(composite);
        this.txt = new Text(composite, 2688);
        this.txt.setLayoutData((Object)new GridData(768));
        this.txt.setMessage("Search property");
        this.txt.addModifyListener(e -> {
            if (!Misc.isNullOrEmpty((String)this.search) && this.txt.getText().trim().equalsIgnoreCase(this.search.trim())) {
                return;
            }
            this.refreshWidgets();
        });
        this.txt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (!Misc.isNullOrEmpty((String)JRPropertyPage.this.search) && JRPropertyPage.this.txt.getText().trim().equalsIgnoreCase(JRPropertyPage.this.search.trim())) {
                    return;
                }
                JRPropertyPage.this.refreshWidgets();
            }
        });
        this.createButtonsTable(composite);
        this.propCmp = new Composite(composite, 0);
        this.propCmpLayout = new StackLayout();
        this.propCmp.setLayout((Layout)this.propCmpLayout);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 3;
        gd.heightHint = 500;
        this.propCmp.setLayoutData((Object)gd);
        this.sc = new ScrolledComposite(this.propCmp, 768);
        this.sc.setExpandHorizontal(true);
        this.sc.setExpandVertical(true);
        this.sc.setAlwaysShowScrollBars(true);
        this.cmp = new Composite((Composite)this.sc, 0);
        this.cmp.setLayout((Layout)new GridLayout(2, false));
        this.cmp.setBackground(SWTResourceManager.getColor((int)1));
        this.cmp.setBackgroundMode(2);
        this.sc.setContent((Control)this.cmp);
        UIUtils.getDisplay().asyncExec(() -> {
            this.txt.setFocus();
            this.createFormWidgets(this.cmp, this.sc);
        });
        this.sc.addListener(11, event -> this.sc.setMinSize(this.cmp.computeSize(this.sc.getClientArea().width, -1)));
        this.propCmpLayout.topControl = this.sc;
    }

    private void createFormWidgets(Composite cmp, ScrolledComposite sc) {
        this.eds = HintsPropertiesList.getPropertiesMetadata(this.jrElement, this.eContext);
        for (PropertyMetadata pm : this.eds) {
            this.propsMap.put(pm.getName(), pm);
        }
        this.refreshWidgets();
    }

    protected void createProperties(String search) {
        String cat = null;
        this.scmp = this.cmp;
        if (this.props.isEmpty()) {
            String[] names = this.value.getPropertyNames();
            int i = 0;
            while (i < names.length) {
                this.props.add(new PropertyDTO(names[i], this.value.getProperty(names[i])));
                ++i;
            }
        }
        for (PropertyDTO pdto : this.props) {
            if (this.propsMap.containsKey(pdto.getName())) continue;
            StandardPropertyMetadata v = new StandardPropertyMetadata();
            v.setName(pdto.getName());
            v.setValueType(String.class.getName());
            this.propsMap.put(pdto.getName(), (PropertyMetadata)v);
            this.added = true;
        }
        if (this.added) {
            this.sortedEDS = new ArrayList<PropertyMetadata>(this.propsMap.values());
            Collections.sort(this.sortedEDS, new Comparator<PropertyMetadata>(){
                private NullComparator nc = new NullComparator(true);

                @Override
                public int compare(PropertyMetadata o1, PropertyMetadata o2) {
                    int i = this.nc.compare((Object)o1.getCategory(), (Object)o2.getCategory());
                    if (i != 0) {
                        return i;
                    }
                    if (o1.getCategory() != null && o2.getCategory() != null && (i = o1.getCategory().compareTo(o2.getCategory())) != 0) {
                        return i;
                    }
                    return o1.getName().compareTo(o2.getName());
                }
            });
            this.added = false;
        }
        for (PropertyMetadata pm : this.sortedEDS) {
            boolean custom;
            if (this.canceled) {
                return;
            }
            if (this.showExisting && !this.containsProperty(pm.getName())) continue;
            String c = pm.getCategory();
            if (c != null && c.indexOf(58) >= 0) {
                c = c.substring(c.indexOf(58) + 1);
            }
            if (c == null) {
                c = "Miscellaneous";
            }
            if (!Misc.isNullOrEmpty((String)search) && !pm.getName().toLowerCase().trim().contains(search) && (pm.getLabel() == null || !pm.getLabel().toLowerCase().trim().contains(search)) && !c.toLowerCase().trim().contains(search)) continue;
            if (!StringUtils.equals((String)c, cat)) {
                cat = c;
                this.buildSection(c);
            }
            if (this.scmp == this.cmp) {
                this.buildSectionComposite();
            }
            TColumn col = TColumnFactory.getTColumn(pm);
            col.setValue((Object)this.jConfig);
            col.setValue1(this.jrElement);
            boolean bl = custom = !this.eds.contains(this.propsMap.get(pm.getName()));
            if (custom && !this.containsProperty(pm.getName())) continue;
            col.setLabelEditable(this.showExisting && custom);
            UIUtils.getDisplay().syncExec(() -> {
                AWidget aWidget = TColumnFactory.addWidget(col, this.scmp, this.value, this.jConfig);
            });
        }
        UIUtils.getDisplay().syncExec(() -> {
            if (this.cmp.getChildren().length == 0) {
                Label lbl = new Label(this.cmp, 0x1000000);
                lbl.setText("Search result is empty");
                GridData gd = new GridData(832);
                gd.horizontalSpan = 2;
                lbl.setLayoutData((Object)gd);
            }
        });
    }

    private void createButtonsTable(Composite parent) {
        this.buttons = new ToolBar(parent, 0x800000);
        final ToolItem bTbl = new ToolItem(this.buttons, 8);
        bTbl.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/eclipse/properties_view.gif"));
        bTbl.addListener(13, new Listener(){
            private boolean table = false;

            public void handleEvent(Event event) {
                if (!this.table) {
                    if (JRPropertyPage.this.tblCmp == null) {
                        JRPropertyPage.this.createTable(JRPropertyPage.this.propCmp);
                    }
                    JRPropertyPage.this.propCmpLayout.topControl = JRPropertyPage.this.tblCmp;
                    JRPropertyPage.this.propCmp.layout(true);
                    bTbl.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/ui-scroll-pane-form.png"));
                    JRPropertyPage.this.fillTable();
                } else {
                    bTbl.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/eclipse/properties_view.gif"));
                    JRPropertyPage.this.propCmpLayout.topControl = JRPropertyPage.this.sc;
                    JRPropertyPage.this.propCmp.layout(true);
                    JRPropertyPage.this.refreshWidgets();
                }
                JRPropertyPage.this.badd.setEnabled(this.table);
                JRPropertyPage.this.bSystem.setEnabled(this.table);
                JRPropertyPage.this.txt.setEnabled(this.table);
                this.table = !this.table;
            }
        });
        this.badd.setToolTipText("Show properties as table or form.");
    }

    private void createButtons(Composite parent) {
        this.buttons = new ToolBar(parent, 0x800000);
        this.badd = new ToolItem(this.buttons, 8);
        this.badd.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/plus.png"));
        this.badd.addListener(13, event -> {
            PropertyDTO p = new PropertyDTO(this.getPropertyName(), "NEW_VALUE");
            p.seteContext(this.eContext);
            p.setJrElement(this.jrElement);
            JRPropertyDialog dialog = new JRPropertyDialog(UIUtils.getShell());
            dialog.setValue(p);
            if (dialog.open() == 0) {
                this.value.setProperty(p.getName(), p.getValue());
                this.props.add(p);
                this.refreshWidgets();
            }
        });
        this.badd.setToolTipText("Add property.");
        this.bSystem = new ToolItem(this.buttons, 32);
        this.bSystem.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/jrxml_icon.png"));
        this.bSystem.addListener(13, event -> {
            this.showExisting = this.bSystem.getSelection();
            this.refreshWidgets();
        });
        this.bSystem.setToolTipText("Show only existing properties in the report template.");
        this.bSystem.setSelection(false);
    }

    protected void createTable(Composite parent) {
        this.tblCmp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        this.tblCmp.setLayout((Layout)layout);
        this.buildTable(this.tblCmp);
        GridData gd = new GridData(1808);
        gd.heightHint = 400;
        this.table.setLayoutData((Object)gd);
        Composite bGroup = new Composite(this.tblCmp, 0);
        bGroup.setLayout((Layout)new GridLayout(1, false));
        bGroup.setLayoutData((Object)new GridData(1040));
        Button addButton = new Button(bGroup, 8);
        addButton.setText(Messages.common_add);
        addButton.setLayoutData((Object)new GridData(768));
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertyDTO p = new PropertyDTO(JRPropertyPage.this.getPropertyName(), "NEW_VALUE");
                p.seteContext(JRPropertyPage.this.eContext);
                p.setJrElement(JRPropertyPage.this.jrElement);
                JRPropertyDialog dialog = new JRPropertyDialog(UIUtils.getShell());
                dialog.setValue(p);
                if (dialog.open() == 0) {
                    JRPropertyPage.this.props.add(p);
                    JRPropertyPage.this.value.setProperty(p.getName(), p.getValue());
                    JRPropertyPage.this.tableViewer.refresh();
                }
            }
        });
        this.editButton = new Button(bGroup, 8);
        this.editButton.setText(Messages.common_edit);
        this.editButton.setLayoutData((Object)new GridData(768));
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection selection = (StructuredSelection)JRPropertyPage.this.tableViewer.getSelection();
                if (selection.size() > 0) {
                    PropertyDTO selectedValue = (PropertyDTO)selection.getFirstElement();
                    JRPropertyPage.this.editElement(selectedValue);
                }
            }
        });
        this.editButton.setEnabled(false);
        this.deleteButton = new Button(bGroup, 8);
        this.deleteButton.setText(Messages.common_delete);
        this.deleteButton.setLayoutData((Object)new GridData(768));
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection selection = (StructuredSelection)JRPropertyPage.this.tableViewer.getSelection();
                if (selection.size() > 0) {
                    PropertyDTO selectedValue = (PropertyDTO)selection.getFirstElement();
                    int index = JRPropertyPage.this.props.indexOf(selectedValue);
                    JRPropertyPage.this.props.remove(index);
                    JRPropertyPage.this.tableViewer.refresh();
                    JRPropertyPage.this.value.removeProperty(selectedValue.getName());
                }
            }
        });
        this.deleteButton.setEnabled(false);
        new ListOrderButtons().createOrderButtons(bGroup, this.tableViewer);
    }

    private String getPropertyName() {
        String name = "newproperty";
        int i = 0;
        while (this.nameExist(name)) {
            name = "newproperty_" + i;
            ++i;
        }
        return name;
    }

    private boolean nameExist(String name) {
        for (PropertyDTO prm : this.props) {
            if (prm.getName() == null || !prm.getName().trim().equals(name)) continue;
            return true;
        }
        return false;
    }

    private void editElement(PropertyDTO edited) {
        PropertyDTO result = edited.clone();
        result.seteContext(this.eContext);
        JRPropertyDialog inputDialog = new JRPropertyDialog(UIUtils.getShell());
        inputDialog.setValue(result);
        if (inputDialog.open() == 0) {
            int index = this.props.indexOf(edited);
            this.props.set(index, result);
            this.value.setProperty(result.getName(), result.getValue());
            this.tableViewer.refresh();
        }
    }

    private void buildTable(Composite composite) {
        this.table = new Table(composite, 68098);
        this.table.setHeaderVisible(true);
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TPropertyLabelProvider());
        this.tableViewer.addDoubleClickListener(event -> {
            int selectedIndex = this.table.getSelectionIndex();
            if (selectedIndex != -1) {
                PropertyDTO selectedElement = this.props.get(selectedIndex);
                this.editElement(selectedElement);
            }
        });
        this.tableViewer.addSelectionChangedListener(event -> {
            int selectedIndex = this.table.getSelectionIndex();
            boolean buttonEnabled = selectedIndex != -1;
            this.editButton.setEnabled(buttonEnabled);
            this.deleteButton.setEnabled(buttonEnabled);
        });
        this.tableViewer.setColumnProperties(new String[]{"NAME", "VALUE"});
        TableColumn[] column = new TableColumn[2];
        column[0] = new TableColumn(this.table, 0);
        column[0].setText(Messages.common_name);
        column[1] = new TableColumn(this.table, 0);
        column[1].setText(Messages.JRPropertyPage_value);
        this.fillTable();
        int i = 0;
        int n = column.length;
        while (i < n) {
            column[i].pack();
            ++i;
        }
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
        this.table.setLayout((Layout)tlayout);
        TableHelpListener.setTableHelp(this.table);
        Menu tableMenu = new Menu((Control)this.table);
        final MenuItem copyItem = new MenuItem(tableMenu, 0);
        copyItem.setText(Messages.common_copy);
        copyItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection selection = (StructuredSelection)JRPropertyPage.this.tableViewer.getSelection();
                ArrayList<ICopyable> copyList = new ArrayList<ICopyable>();
                for (Object selected : selection.toList()) {
                    PropertyDTO prop = (PropertyDTO)selected;
                    if (prop.isExpression()) {
                        copyList.add(new CopyElementExpressionProperty(prop.getName(), prop.getValue()));
                        continue;
                    }
                    copyList.add(new CopyElementProperty(prop.getName(), prop.getValue()));
                }
                if (!copyList.isEmpty()) {
                    PastableProperties container = new PastableProperties(copyList);
                    Clipboard.getDefault().setContents((Object)container);
                }
            }
        });
        final MenuItem pasteItem = new MenuItem(tableMenu, 0);
        pasteItem.setText(Messages.common_paste);
        pasteItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PastableProperties pasteContainer = (PastableProperties)Clipboard.getDefault().getContents();
                List<CopyElementExpressionProperty> copiedProperties = pasteContainer.getCopiedProperties();
                for (CopyElementExpressionProperty property : copiedProperties) {
                    if (property.isExpression() || JRPropertyPage.this.containsProperty(property.getPropertyName())) continue;
                    JRPropertyPage.this.props.add(new PropertyDTO(property.getPropertyName(), property.getValue()));
                }
                JRPropertyPage.this.tableViewer.refresh();
            }
        });
        tableMenu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                copyItem.setEnabled(!JRPropertyPage.this.tableViewer.getSelection().isEmpty());
                boolean pasteEnabled = false;
                if (Clipboard.getDefault().getContents() instanceof PastableProperties) {
                    PastableProperties pasteContainer = (PastableProperties)Clipboard.getDefault().getContents();
                    List<CopyElementExpressionProperty> copiedProperties = pasteContainer.getCopiedProperties();
                    pasteEnabled = copiedProperties != null && !copiedProperties.isEmpty() && JRPropertyPage.this.canPaste(copiedProperties);
                }
                pasteItem.setEnabled(pasteEnabled);
            }
        });
        this.table.setMenu(tableMenu);
    }

    private void fillTable() {
        this.props.clear();
        String[] names = this.value.getPropertyNames();
        int i = 0;
        while (i < names.length) {
            this.props.add(new PropertyDTO(names[i], this.value.getProperty(names[i])));
            ++i;
        }
        this.tableViewer.setInput(this.props);
    }

    private boolean containsProperty(String propertyName) {
        for (PropertyDTO property : this.props) {
            if (!property.getName().equals(propertyName)) continue;
            return true;
        }
        return false;
    }

    private boolean canPaste(List<CopyElementExpressionProperty> copiedProperties) {
        for (CopyElementExpressionProperty property : copiedProperties) {
            if (property.isExpression() || this.containsProperty(property.getPropertyName())) continue;
            return true;
        }
        return false;
    }

    public JRPropertiesMap getValue() {
        return this.value;
    }

    protected void refreshWidgets() {
        if (this.refreshing) {
            this.canceled = true;
            return;
        }
        this.refreshing = true;
        Job job = new Job("refresh widgets"){

            protected IStatus run(IProgressMonitor monitor) {
                boolean ex = JRPropertyPage.this.showExisting;
                try {
                    UIUtils.getDisplay().syncExec(() -> {
                        JRPropertyPage.this.search = JRPropertyPage.this.txt.getText();
                        Control[] controlArray = JRPropertyPage.this.cmp.getChildren();
                        int n = controlArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Control c = controlArray[n2];
                            if (c != JRPropertyPage.this.txt && c != JRPropertyPage.this.buttons) {
                                c.dispose();
                            }
                            ++n2;
                        }
                    });
                    JRPropertyPage.this.canceled = false;
                    JRPropertyPage.this.createProperties(JRPropertyPage.this.search.trim().toLowerCase());
                    if (!JRPropertyPage.this.canceled) {
                        UIUtils.getDisplay().syncExec(() -> {
                            JRPropertyPage.this.sc.setMinSize(JRPropertyPage.this.cmp.computeSize(JRPropertyPage.this.sc.getClientArea().width, -1));
                            JRPropertyPage.this.cmp.layout(true);
                        });
                    }
                }
                catch (Throwable throwable) {
                    JRPropertyPage.this.refreshing = false;
                    UIUtils.getDisplay().syncExec(() -> {
                        if (!JRPropertyPage.this.search.equals(JRPropertyPage.this.txt.getText()) || ex != JRPropertyPage.this.showExisting) {
                            JRPropertyPage.this.refreshWidgets();
                        }
                    });
                    throw throwable;
                }
                JRPropertyPage.this.refreshing = false;
                UIUtils.getDisplay().syncExec(() -> {
                    if (!JRPropertyPage.this.search.equals(JRPropertyPage.this.txt.getText()) || ex != JRPropertyPage.this.showExisting) {
                        JRPropertyPage.this.refreshWidgets();
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setPriority(20);
        job.schedule();
    }

    private void buildSectionComposite() {
        UIUtils.getDisplay().syncExec(() -> {
            this.scmp = new Composite(this.cmp, 0);
            this.scmp.setLayout((Layout)new GridLayout(2, false));
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            this.scmp.setLayoutData((Object)gd);
        });
    }

    private void buildSection(String cat) {
        UIUtils.getDisplay().syncExec(() -> {
            if (this.scmp != null) {
                this.cmp.layout(true);
                this.sc.setMinSize(this.cmp.computeSize(this.sc.getClientArea().width, -1));
            }
            this.scmp = new Composite(this.cmp, 0);
            this.scmp.setLayout((Layout)new GridLayout(2, false));
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            this.scmp.setLayoutData((Object)gd);
            Label lbl = new Label(this.scmp, 0);
            String gn = WordUtils.capitalizeFully((String)cat.replace(".", " "));
            gn = gn.replaceAll("Jasperreports", "JasperReports");
            lbl.setText(gn);
            lbl.setFont(ResourceManager.getBoldFont((Font)lbl.getFont()));
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            lbl.setLayoutData((Object)gd);
            lbl = new Label(this.scmp, 258);
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            lbl.setLayoutData((Object)gd);
        });
    }
}

