/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.descriptor.returnvalue;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.property.descriptor.returnvalue.InputReturnValueDialog;
import com.jaspersoft.studio.property.descriptor.returnvalue.ReturnValueContainer;
import java.util.HashSet;
import net.sf.jasperreports.engine.type.CalculationEnum;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class EditableInputReturnValueDialog
extends InputReturnValueDialog {
    private String[] fromVariables;
    private Combo fromVariableCombo;
    private HashSet<String> invalidTo;
    private HashSet<String> invalidFrom;

    public EditableInputReturnValueDialog(Shell parentShell, ReturnValueContainer rvContainer, String[] toVariables, String[] fromVariables, HashSet<String> invalidTo, HashSet<String> inavlidFrom) {
        super(parentShell, rvContainer, toVariables);
        this.fromVariables = fromVariables != null ? fromVariables : new String[]{};
        this.invalidTo = invalidTo != null ? invalidTo : new HashSet();
        this.invalidFrom = inavlidFrom != null ? inavlidFrom : new HashSet();
    }

    @Override
    protected void createFromVariable(Composite container) {
        Label fromVariableLabel = new Label(container, 0);
        fromVariableLabel.setText(Messages.RVPropertyPage_subreport_variable);
        this.fromVariableCombo = new Combo(container, 0);
        this.fromVariableCombo.setLayoutData((Object)new GridData(768));
        this.fromVariableCombo.setItems(this.fromVariables);
    }

    @Override
    protected void createToVariable(Composite container) {
        Label toVariableLabel = new Label(container, 0);
        toVariableLabel.setText(Messages.RVPropertyPage_to_variable);
        this.toVariable = new Combo(container, 0);
        this.toVariable.setLayoutData((Object)new GridData(768));
        this.toVariable.setItems(this.toVariables);
    }

    @Override
    protected void initializeVariables() {
        int index;
        if (this.rvContainer.getToVariable() != null) {
            index = ArrayUtils.indexOf((Object[])this.toVariables, (Object)this.rvContainer.getToVariable());
            if (index == -1) {
                index = 0;
            }
            this.toVariable.select(index);
        } else {
            this.toVariable.select(0);
        }
        if (this.rvContainer.getFromVariable() != null) {
            index = ArrayUtils.indexOf((Object[])this.fromVariables, (Object)this.rvContainer.getFromVariable());
            if (index == -1) {
                index = 0;
            }
            this.fromVariableCombo.select(index);
        } else {
            this.fromVariableCombo.select(0);
        }
        this.toVariable.addModifyListener(this.widgetModified);
        this.fromVariableCombo.addModifyListener(this.widgetModified);
    }

    @Override
    protected void updateContainer() {
        this.rvContainer.setCalculation(CalculationEnum.values()[this.calculation.getSelectionIndex()]);
        this.rvContainer.setToVariable(this.toVariable.getText());
        this.rvContainer.setFromVariable(this.fromVariableCombo.getText());
        this.rvContainer.setIncrementerFactoryClassName(this.incrementText.getText());
        this.validate();
    }

    @Override
    protected void validate() {
        Button okButton = this.getButton(0);
        if (okButton != null) {
            String fromValue = this.fromVariableCombo.getText().trim();
            String toValue = this.toVariable.getText().trim();
            boolean validFrom = !fromValue.isEmpty() && !this.invalidFrom.contains(fromValue);
            boolean validTo = !toValue.isEmpty() && !this.invalidTo.contains(toValue);
            okButton.setEnabled(validFrom && validTo);
        }
    }
}

