/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.descriptor.returnvalue;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.property.descriptor.returnvalue.ReturnValueContainer;
import com.jaspersoft.studio.utils.EnumHelper;
import com.jaspersoft.studio.utils.SelectionHelper;
import net.sf.jasperreports.eclipse.ui.util.PersistentLocationDialog;
import net.sf.jasperreports.engine.fill.JRIncrementerFactory;
import net.sf.jasperreports.engine.type.CalculationEnum;
import net.sf.jasperreports.engine.type.NamedEnum;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.core.search.BasicSearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.dialogs.SelectionDialog;

public class InputReturnValueDialog
extends PersistentLocationDialog {
    private static final String[] calculationValues = EnumHelper.getEnumNames((NamedEnum[])CalculationEnum.values(), NullEnum.NOTNULL);
    protected Text incrementText;
    protected Combo calculation;
    protected Text fromVariable;
    protected Combo toVariable;
    protected ReturnValueContainer rvContainer;
    protected String[] toVariables;
    protected ModifyListener widgetModified = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            InputReturnValueDialog.this.updateContainer();
        }
    };

    public InputReturnValueDialog(Shell parentShell, ReturnValueContainer rvContainer, String[] toVariables) {
        super(parentShell);
        Assert.isNotNull((Object)rvContainer);
        this.rvContainer = rvContainer;
        this.toVariables = toVariables;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (newShell != null) {
            newShell.setText(Messages.InputReturnValueDialog_dialogTitle);
        }
    }

    protected void createFromVariable(Composite container) {
        Label fromVariableLabel = new Label(container, 0);
        fromVariableLabel.setText(Messages.RVPropertyPage_subreport_variable);
        this.fromVariable = new Text(container, 2048);
        this.fromVariable.setLayoutData((Object)new GridData(768));
    }

    protected void createToVariable(Composite container) {
        Label toVariableLabel = new Label(container, 0);
        toVariableLabel.setText(Messages.RVPropertyPage_to_variable);
        this.toVariable = new Combo(container, 8);
        this.toVariable.setLayoutData((Object)new GridData(768));
        this.toVariable.setItems(this.toVariables);
    }

    protected void initializeVariables() {
        if (this.rvContainer.getToVariable() != null) {
            int index = ArrayUtils.indexOf((Object[])this.toVariables, (Object)this.rvContainer.getToVariable());
            if (index == -1) {
                index = 0;
            }
            this.toVariable.select(index);
        } else {
            this.toVariable.select(0);
        }
        if (this.rvContainer.getFromVariable() != null) {
            this.fromVariable.setText(this.rvContainer.getFromVariable());
        }
        this.toVariable.addModifyListener(this.widgetModified);
        this.fromVariable.addModifyListener(this.widgetModified);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(1808));
        this.createFromVariable(container);
        this.createToVariable(container);
        Label calculationLabel = new Label(container, 0);
        calculationLabel.setText(Messages.RVPropertyPage_calculation_type);
        this.calculation = new Combo(container, 8);
        this.calculation.setLayoutData((Object)new GridData(768));
        this.calculation.setItems(calculationValues);
        Label incrementLabel = new Label(container, 0);
        incrementLabel.setText(Messages.RVPropertyPage_incrementer_factory_class);
        Composite incrementContainer = new Composite(container, 0);
        GridLayout incrementContainerLayout = new GridLayout(2, false);
        incrementContainerLayout.horizontalSpacing = 0;
        incrementContainerLayout.verticalSpacing = 0;
        incrementContainerLayout.marginWidth = 0;
        incrementContainerLayout.marginHeight = 0;
        incrementContainer.setLayout((Layout)incrementContainerLayout);
        incrementContainer.setLayoutData((Object)new GridData(768));
        this.incrementText = new Text(incrementContainer, 2048);
        this.incrementText.setLayoutData((Object)new GridData(768));
        Button incrementButton = new Button(incrementContainer, 0);
        incrementButton.setText("...");
        incrementButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    SelectionDialog dialog = JavaUI.createTypeDialog((Shell)InputReturnValueDialog.this.getShell(), (IRunnableContext)new ProgressMonitorDialog(InputReturnValueDialog.this.getShell()), (IJavaSearchScope)InputReturnValueDialog.this.getIncrementContext(), (int)256, (boolean)false);
                    dialog.setTitle(Messages.ClassTypeCellEditor_open_type);
                    dialog.setMessage(Messages.ClassTypeCellEditor_dialog_message);
                    if (dialog.open() == 0 && dialog.getResult() != null && dialog.getResult().length > 0) {
                        IType bt = (IType)dialog.getResult()[0];
                        InputReturnValueDialog.this.incrementText.setText(bt.getFullyQualifiedName());
                    }
                }
                catch (JavaModelException e1) {
                    e1.printStackTrace();
                }
            }
        });
        if (this.rvContainer.getCalculation() != null) {
            int index = ArrayUtils.indexOf((Object[])CalculationEnum.values(), (Object)this.rvContainer.getCalculation());
            if (index == -1) {
                index = 0;
            }
            this.calculation.select(index);
        }
        if (this.rvContainer.getIncrementerFactoryClassName() != null) {
            this.incrementText.setText(this.rvContainer.getIncrementerFactoryClassName());
        }
        this.initializeVariables();
        this.incrementText.addModifyListener(this.widgetModified);
        this.calculation.addModifyListener(this.widgetModified);
        this.updateContainer();
        return container;
    }

    protected void updateContainer() {
        this.rvContainer.setCalculation(CalculationEnum.values()[this.calculation.getSelectionIndex()]);
        this.rvContainer.setToVariable(this.toVariable.getText());
        this.rvContainer.setFromVariable(this.fromVariable.getText());
        this.rvContainer.setIncrementerFactoryClassName(this.incrementText.getText());
        this.validate();
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.validate();
        return contents;
    }

    protected void validate() {
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(this.fromVariable.getText() != null && !this.fromVariable.getText().trim().isEmpty());
        }
    }

    private IJavaSearchScope getIncrementContext() {
        IJavaSearchScope searchScope = SearchEngine.createWorkspaceScope();
        IProject prj = ((IFileEditorInput)SelectionHelper.getActiveJRXMLEditor().getEditorInput()).getFile().getProject();
        if (prj != null) {
            try {
                IJavaProject jprj = JavaCore.create((IProject)prj);
                IType t = jprj.findType(JRIncrementerFactory.class.getName());
                if (t != null) {
                    searchScope = BasicSearchEngine.createHierarchyScope((IType)t);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return searchScope;
    }
}

