/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.descriptor.tabstops.dialog;

import com.jaspersoft.studio.jface.IntegerCellEditorValidator;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.property.descriptors.NamedEnumPropertyDescriptor;
import com.jaspersoft.studio.swt.widgets.table.DeleteButton;
import com.jaspersoft.studio.swt.widgets.table.INewElement;
import com.jaspersoft.studio.swt.widgets.table.ListContentProvider;
import com.jaspersoft.studio.swt.widgets.table.ListOrderButtons;
import com.jaspersoft.studio.swt.widgets.table.NewButton;
import com.jaspersoft.studio.utils.EnumHelper;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.TabStop;
import net.sf.jasperreports.engine.type.NamedEnum;
import net.sf.jasperreports.engine.type.TabStopAlignEnum;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class TabStopsPage
extends WizardPage {
    private List<TabStop> value;
    private Table table;
    private TableViewer tableViewer;
    private NamedEnumPropertyDescriptor<TabStopAlignEnum> sfdesc = new NamedEnumPropertyDescriptor<TabStopAlignEnum>(null, null, TabStopAlignEnum.CENTER, NullEnum.NOTNULL);

    public List<TabStop> getValue() {
        return this.value;
    }

    public void dispose() {
        super.dispose();
    }

    public void setValue(List<TabStop> value) {
        this.value = value;
        if (value == null) {
            value = new ArrayList<TabStop>();
        }
        if (this.table != null) {
            this.fillTable(this.table, value);
        }
    }

    protected TabStopsPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.TabStopsPage_title);
        this.setDescription(Messages.TabStopsPage_description);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        this.setControl((Control)composite);
        this.buildTable(composite);
        GridData gd = new GridData(1808);
        gd.heightHint = 400;
        this.table.setLayoutData((Object)gd);
        Composite bGroup = new Composite(composite, 0);
        bGroup.setLayout((Layout)new GridLayout(1, false));
        bGroup.setLayoutData((Object)new GridData(1040));
        new NewButton().createNewButtons(bGroup, this.tableViewer, new INewElement(){

            @Override
            public Object newElement(List<?> input, int pos) {
                TabStop p = new TabStop();
                p.setPosition(20);
                p.setAlignment(TabStopAlignEnum.LEFT);
                return p;
            }
        });
        new DeleteButton().createDeleteButton(bGroup, this.tableViewer);
        new ListOrderButtons().createOrderButtons(bGroup, this.tableViewer);
    }

    private void buildTable(Composite composite) {
        this.table = new Table(composite, 68098);
        this.table.setHeaderVisible(true);
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TLabelProvider());
        this.attachCellEditors(this.tableViewer, (Composite)this.table);
        TableColumn[] column = new TableColumn[2];
        column[0] = new TableColumn(this.table, 0);
        column[0].setText(Messages.TabStopsPage_col1);
        column[1] = new TableColumn(this.table, 0);
        column[1].setText(Messages.TabStopsPage_col2);
        this.fillTable(this.table, this.value);
        int i = 0;
        int n = column.length;
        while (i < n) {
            column[i].pack();
            ++i;
        }
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
        this.table.setLayout((Layout)tlayout);
    }

    private void attachCellEditors(TableViewer viewer, Composite parent) {
        viewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                if (property.equals("POSITION")) {
                    return true;
                }
                return property.equals("ALIGNEMENT");
            }

            public Object getValue(Object element, String property) {
                TabStop prop = (TabStop)element;
                if ("POSITION".equals(property)) {
                    return Integer.toString(prop.getPosition());
                }
                if ("ALIGNEMENT".equals(property)) {
                    return TabStopsPage.this.sfdesc.getIntValue(prop.getAlignment());
                }
                return "";
            }

            public void modify(Object element, String property, Object value) {
                TabStopsPage.this.setErrorMessage(null);
                TabStopsPage.this.setMessage(TabStopsPage.this.getDescription());
                TableItem tableItem = (TableItem)element;
                TabStop data = (TabStop)tableItem.getData();
                if ("POSITION".equals(property)) {
                    try {
                        data.setPosition(new Integer((String)value).intValue());
                    }
                    catch (NumberFormatException numberFormatException) {
                        TabStopsPage.this.setErrorMessage(Messages.TabStopsPage_formatError);
                    }
                } else if ("ALIGNEMENT".equals(property)) {
                    data.setAlignment(TabStopsPage.this.sfdesc.getEnumValue(value));
                }
                TabStopsPage.this.tableViewer.update(element, new String[]{property});
                TabStopsPage.this.tableViewer.refresh();
            }
        });
        final TextCellEditor tce = new TextCellEditor(parent);
        tce.setValidator((ICellEditorValidator)IntegerCellEditorValidator.instance());
        tce.addListener(new ICellEditorListener(){

            public void applyEditorValue() {
                TabStopsPage.this.setErrorMessage(null);
            }

            public void cancelEditor() {
                TabStopsPage.this.setErrorMessage(null);
            }

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
                TabStopsPage.this.setErrorMessage(tce.getErrorMessage());
            }
        });
        viewer.setCellEditors(new CellEditor[]{tce, new ComboBoxCellEditor(parent, EnumHelper.getEnumNames((NamedEnum[])TabStopAlignEnum.values(), NullEnum.NOTNULL), 0x800008)});
        viewer.setColumnProperties(new String[]{"POSITION", "ALIGNEMENT"});
    }

    private void fillTable(Table table, Object val) {
        this.tableViewer.setInput(val);
    }

    private final class TLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            TabStop tabstop = (TabStop)element;
            switch (columnIndex) {
                case 0: {
                    return Integer.toString(tabstop.getPosition());
                }
                case 1: {
                    if (tabstop.getAlignment() == null) break;
                    return tabstop.getAlignment().getName();
                }
            }
            return "";
        }
    }
}

