/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.descriptors;

import com.jaspersoft.studio.help.HelpSystem;
import com.jaspersoft.studio.help.IHelp;
import com.jaspersoft.studio.help.IHelpRefBuilder;
import com.jaspersoft.studio.jface.IntegerCellEditorValidator;
import com.jaspersoft.studio.property.descriptor.text.EditableTextCellEditor;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.widgets.ASPropertyWidget;
import com.jaspersoft.studio.property.section.widgets.IPropertyDescriptorWidget;
import com.jaspersoft.studio.property.section.widgets.SPNumber;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class IntegerPropertyDescriptor
extends TextPropertyDescriptor
implements IPropertyDescriptorWidget,
IHelp {
    private boolean isNullable = true;
    private int minValue = 0;
    private int maxValue = Integer.MAX_VALUE;
    private IHelpRefBuilder refBuilder;

    public IntegerPropertyDescriptor(Object id, String displayName) {
        super(id, displayName);
    }

    public CellEditor createPropertyEditor(Composite parent) {
        EditableTextCellEditor editor = new EditableTextCellEditor(parent){

            protected Object doGetValue() {
                String value = (String)super.doGetValue();
                if (value == null || value.equals("")) {
                    return null;
                }
                return new Integer(value);
            }

            protected void doSetValue(Object value) {
                if (value == null) {
                    super.doSetValue((Object)"");
                } else {
                    Assert.isTrue((this.text != null && value instanceof Integer ? 1 : 0) != 0);
                    super.doSetValue((Object)((Integer)value).toString());
                }
            }
        };
        editor.setValidator(IntegerCellEditorValidator.instance());
        this.setValidator(IntegerCellEditorValidator.instance());
        HelpSystem.bindToHelp((IPropertyDescriptor)this, editor.getControl());
        return editor;
    }

    @Override
    public ASPropertyWidget<?> createWidget(Composite parent, AbstractSection section) {
        SPNumber spNumber = new SPNumber(parent, section, (IPropertyDescriptor)this);
        spNumber.setNullable(this.isNullable);
        spNumber.setDigits(0, 0, Integer.class);
        spNumber.setBounds(this.minValue, this.maxValue);
        return spNumber;
    }

    @Override
    public void setHelpRefBuilder(IHelpRefBuilder refBuilder) {
        this.refBuilder = refBuilder;
    }

    @Override
    public String getHelpReference() {
        if (this.refBuilder != null) {
            return this.refBuilder.getHelpReference();
        }
        return null;
    }

    public void setNullable(boolean value) {
        this.isNullable = value;
    }

    public void setBounds(int min, int max) {
        this.minValue = min;
        this.maxValue = max;
    }
}

