/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.infoList;

import com.jaspersoft.studio.property.infoList.ElementDescription;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wb.swt.SWTResourceManager;

public class SelectableComposite
extends ScrolledComposite {
    private List<ElementDescription> items = null;
    private Composite selectedComposite;
    private List<Composite> compositeList = new ArrayList<Composite>();
    private Color unselectedColor = SWTResourceManager.getColor((int)255, (int)255, (int)225);
    private Color selectedColor = SWTResourceManager.getColor((int)51, (int)153, (int)255);
    private SelectionAdapter mouseDoubleClick;
    private MouseListener compositeMouseAction = new MouseListener(){

        public void mouseUp(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            SelectableComposite.this.widgetSelected(e.getSource());
        }

        public void mouseDoubleClick(MouseEvent e) {
            SelectableComposite.this.widgetSelected(e.getSource());
            if (SelectableComposite.this.mouseDoubleClick != null) {
                Event baseEvent = new Event();
                baseEvent.data = SelectableComposite.this.selectedComposite.getData();
                baseEvent.item = SelectableComposite.this.selectedComposite;
                baseEvent.widget = e.widget;
                SelectionEvent event = new SelectionEvent(baseEvent);
                SelectableComposite.this.mouseDoubleClick.widgetSelected(event);
            } else {
                SelectableComposite.this.widgetSelected(((Control)e.getSource()).getParent());
            }
            SelectableComposite.this.setScrolledFocus();
        }
    };
    private Listener arrowListener = new Listener(){

        private int getActualSelectionIndex() {
            int index = 0;
            if (SelectableComposite.this.selectedComposite == null) {
                return 0;
            }
            for (ElementDescription item : SelectableComposite.this.items) {
                if (SelectableComposite.this.selectedComposite.getData() == item) break;
                ++index;
            }
            return index;
        }

        public void handleEvent(Event event) {
            if (event.keyCode == 0x1000001 || event.keyCode == 0x1000002) {
                int selectionIndex = this.getActualSelectionIndex();
                int newSelectionIndex = -1;
                if (event.keyCode == 0x1000001 && selectionIndex > 0) {
                    newSelectionIndex = selectionIndex - 1;
                } else if (event.keyCode == 0x1000002 && selectionIndex < SelectableComposite.this.items.size() - 1) {
                    newSelectionIndex = selectionIndex + 1;
                }
                if (newSelectionIndex != -1) {
                    ElementDescription elementToSelect = SelectableComposite.this.items.get(newSelectionIndex);
                    for (Composite comp : SelectableComposite.this.compositeList) {
                        if (comp.isDisposed() || comp.getData() != elementToSelect) continue;
                        if (SelectableComposite.this.selectedComposite != null) {
                            SelectableComposite.this.selectedComposite.setBackground(SelectableComposite.this.unselectedColor);
                            SelectableComposite.this.setChildrenColor(SelectableComposite.this.selectedComposite, SelectableComposite.this.unselectedColor);
                        }
                        SelectableComposite.this.selectedComposite = comp;
                        SelectableComposite.this.showControl((Control)SelectableComposite.this.selectedComposite);
                        SelectableComposite.this.selectedComposite.setBackground(SelectableComposite.this.selectedColor);
                        SelectableComposite.this.setChildrenColor(SelectableComposite.this.selectedComposite, SelectableComposite.this.selectedColor);
                        SelectableComposite.this.setScrolledFocus();
                        break;
                    }
                }
            }
        }
    };

    private void widgetSelected(Object source) {
        if (source.getClass().equals(Composite.class)) {
            if (source != this.selectedComposite) {
                if (this.selectedComposite != null) {
                    this.selectedComposite.setBackground(this.unselectedColor);
                    this.setChildrenColor(this.selectedComposite, this.unselectedColor);
                }
                this.selectedComposite = (Composite)source;
                this.selectedComposite.setBackground(this.selectedColor);
                this.setChildrenColor(this.selectedComposite, this.selectedColor);
                this.setScrolledFocus();
            }
        } else {
            this.widgetSelected(((Control)source).getParent());
        }
    }

    public SelectableComposite(Composite parent) {
        super(parent, 512);
        this.setLayout((Layout)new GridLayout(1, false));
        this.selectedComposite = null;
        this.mouseDoubleClick = null;
        this.getVerticalBar().setIncrement(5);
    }

    public boolean isItemSetted() {
        return this.items != null;
    }

    public void setItems(List<ElementDescription> items) {
        this.items = items;
        this.createItems();
    }

    public void SetDoubleClickListener(SelectionAdapter listener) {
        this.mouseDoubleClick = listener;
    }

    public ElementDescription getSelectedElement() {
        if (this.selectedComposite != null) {
            return (ElementDescription)this.selectedComposite.getData();
        }
        return null;
    }

    private void setScrolledFocus() {
        this.forceFocus();
    }

    private void setChildrenColor(Composite parent, Color color) {
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.setBackground(color);
            ++n2;
        }
    }

    private void createItems() {
        final Composite mainComposite = new Composite((Composite)this, 0);
        GridLayout mainCompLayout = new GridLayout(1, false);
        mainCompLayout.verticalSpacing = 0;
        mainCompLayout.horizontalSpacing = 0;
        mainCompLayout.marginWidth = 0;
        mainCompLayout.marginHeight = 0;
        mainComposite.setLayout((Layout)mainCompLayout);
        this.setContent((Control)mainComposite);
        mainComposite.setRedraw(false);
        this.compositeList.clear();
        for (ElementDescription item : this.items) {
            Composite comp = new Composite(mainComposite, 2048);
            comp.setLayoutData((Object)new GridData(4, 128, true, false));
            GridLayout containerLayout = new GridLayout(1, false);
            comp.setLayout((Layout)containerLayout);
            comp.setData((Object)item);
            comp.setBackground(this.unselectedColor);
            Label titleLabel = new Label(comp, 0);
            titleLabel.setFont(SWTResourceManager.getBoldFont((Font)titleLabel.getFont()));
            titleLabel.setText(item.getName());
            titleLabel.addMouseListener(this.compositeMouseAction);
            this.createDescription(item.getDescription(), comp, item.getStyles());
            comp.addMouseListener(this.compositeMouseAction);
            this.setChildrenColor(comp, this.unselectedColor);
            this.compositeList.add(comp);
        }
        mainComposite.setRedraw(true);
        mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Point size = SelectableComposite.this.getSize();
                mainComposite.setSize(mainComposite.computeSize(size.x, -1));
            }
        });
        PlatformUI.getWorkbench().getDisplay().addFilter(1, this.arrowListener);
    }

    private void createDescription(String text, Composite comp, StyleRange[] styles) {
        final StyledText descLabel = new StyledText(comp, 66);
        descLabel.setRightMargin(10);
        descLabel.setEditable(false);
        descLabel.setText(text);
        descLabel.setLayoutData((Object)new GridData(768));
        descLabel.addMouseListener(this.compositeMouseAction);
        if (styles != null && styles.length > 0) {
            descLabel.setStyleRanges(styles);
        }
        descLabel.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                SelectableComposite.this.setScrolledFocus();
                descLabel.setSelection(0, 0);
            }
        });
    }

    public void showOnlyElement(String name) {
        for (Composite comp : this.compositeList) {
            GridData layoutData;
            ElementDescription desc = (ElementDescription)comp.getData();
            if (desc.getName().contains(name) || name.isEmpty()) {
                if (comp.isVisible()) continue;
                comp.setVisible(true);
                layoutData = (GridData)comp.getLayoutData();
                layoutData.exclude = false;
                continue;
            }
            if (!comp.isVisible()) continue;
            comp.setVisible(false);
            layoutData = (GridData)comp.getLayoutData();
            layoutData.exclude = true;
        }
        if (this.getContent() != null) {
            int width = this.getContent().getSize().x;
            this.getContent().setSize(width, this.getContent().computeSize((int)width, (int)-1).y);
            this.layout(true, true);
        }
    }

    public void dispose() {
        PlatformUI.getWorkbench().getDisplay().removeFilter(1, this.arrowListener);
        super.dispose();
        this.selectedColor.dispose();
        this.unselectedColor.dispose();
        this.compositeList.clear();
    }
}

