/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.itemproperty.celleditor;

import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.properties.view.validation.ValidationError;
import com.jaspersoft.studio.property.descriptor.JSSDialogCellEditor;
import com.jaspersoft.studio.property.itemproperty.desc.ADescriptor;
import com.jaspersoft.studio.property.itemproperty.desc.DescriptorPropertyLabelProvider;
import com.jaspersoft.studio.widgets.framework.ui.dialog.ItemPropertyElementDialog;
import net.sf.jasperreports.components.items.StandardItemProperty;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ItemPropertyCellEditor
extends JSSDialogCellEditor {
    private String id;
    private ExpressionContext expContext;
    private ADescriptor descriptor;
    private DescriptorPropertyLabelProvider labelProvider;

    public ItemPropertyCellEditor(Composite parent, ExpressionContext expContext, String id, ADescriptor descriptor) {
        super(parent, true);
        this.expContext = expContext;
        this.id = id;
        this.descriptor = descriptor;
    }

    public ItemPropertyCellEditor(Composite parent, int style, ExpressionContext expContext, ADescriptor descriptor) {
        super(parent, style, true);
        this.expContext = expContext;
        this.descriptor = descriptor;
    }

    @Override
    protected Object openDialogBox(Control cellEditorWindow) {
        StandardItemProperty sip = (StandardItemProperty)this.getValue();
        if (sip == null) {
            sip = new StandardItemProperty(this.id, null, null);
        }
        ItemPropertyElementDialog dialog = new ItemPropertyElementDialog(UIUtils.getShell(), this.descriptor.getDescription(this.id), sip.getValue(), sip.getValueExpression(), this.expContext);
        dialog.setHelpAvailable(false);
        if (dialog.open() == 0) {
            return new StandardItemProperty(this.id, dialog.getStaticValue(), dialog.getExpressionValue());
        }
        return null;
    }

    @Override
    protected void updateContents(Object value) {
        block5: {
            if (this.getDefaultLabel() == null) {
                return;
            }
            if (this.labelProvider == null) {
                this.labelProvider = new DescriptorPropertyLabelProvider(this.descriptor);
            }
            String text = this.labelProvider.getText(value);
            this.getDefaultLabel().setText(text);
            if (this.descriptor == null || this.id == null) {
                return;
            }
            try {
                this.descriptor.validateItem(null);
            }
            catch (ValidationError e) {
                if (!e.getProps().contains(this.id)) break block5;
                this.setErrorMessage(e.getMessage());
            }
        }
    }

    public void setExpressionContext(ExpressionContext expContext) {
        this.expContext = expContext;
    }
}

