/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.itemproperty.dialog;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.property.itemproperty.desc.ADescriptor;
import com.jaspersoft.studio.property.itemproperty.desc.DescriptorPropertyLabelProvider;
import com.jaspersoft.studio.property.itemproperty.dialog.AItemDialog;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.widgets.framework.IWItemProperty;
import com.jaspersoft.studio.widgets.framework.WItemProperty;
import com.jaspersoft.studio.widgets.framework.events.ItemPropertyModifiedEvent;
import com.jaspersoft.studio.widgets.framework.events.ItemPropertyModifiedListener;
import com.jaspersoft.studio.widgets.framework.ui.ItemPropertyDescription;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.components.items.ItemProperty;
import net.sf.jasperreports.components.items.StandardItemProperty;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wb.swt.ResourceManager;

public abstract class FormItemDialog
extends AItemDialog {
    private boolean showAddDatasetButton = true;
    protected Map<String, WItemProperty> map = new HashMap<String, WItemProperty>();
    protected ScrolledComposite sc;

    public FormItemDialog(Shell parentShell, ADescriptor descriptor, JasperReportsConfiguration jrConfig, boolean showDataset) {
        super(parentShell, descriptor, jrConfig, showDataset);
    }

    public FormItemDialog(Shell parentShell, ADescriptor descriptor, JasperReportsConfiguration jrConfig, boolean showDataset, boolean showAddDatasetButton) {
        super(parentShell, descriptor, jrConfig, showDataset);
        this.showAddDatasetButton = showAddDatasetButton;
    }

    @Override
    protected void createAddItemDataButton(Composite cmp) {
        if (this.showAddDatasetButton) {
            super.createAddItemDataButton(cmp);
        }
    }

    @Override
    protected void createValue(CTabFolder tabFolder) {
        CTabItem bptab = new CTabItem(tabFolder, 0);
        bptab.setText(Messages.ItemDialog_0);
        Composite cmp = this.createScrolledComposite(tabFolder, bptab);
        this.createValues(cmp);
        this.configScrolledComposite(cmp);
    }

    @Override
    protected void createValue(Composite parent) {
        Composite cmp = this.createScrolledComposite(parent);
        this.createValues(cmp);
        this.configScrolledComposite(cmp);
    }

    protected abstract void createValues(Composite var1);

    @Override
    protected void fillData() {
        this.refresh = true;
        try {
            for (String key : this.map.keySet()) {
                WItemProperty expr = this.map.get(key);
                expr.setExpressionContext(this.currentExpContext);
                boolean createNew = true;
                for (ItemProperty ip : this.item.getProperties()) {
                    if (ip == null || !ip.getName().equals(key)) continue;
                    expr.setValue(ip.getValue(), ip.getValueExpression());
                    createNew = false;
                    break;
                }
                if (!createNew) continue;
                StandardItemProperty p = new StandardItemProperty();
                p.setName(key);
                expr.setValue(p.getValue(), p.getValueExpression());
                this.item.addItemProperty((ItemProperty)p);
            }
        }
        finally {
            this.refresh = false;
        }
        super.fillData();
    }

    protected void createItemProperty(Composite cmp, String key) {
        ItemPropertyDescription<?> ipd = this.descriptor.getDescription(key);
        if (ipd == null) {
            return;
        }
        Label lbl = new Label(cmp, 0);
        lbl.setText(ipd.getLabel());
        lbl.setToolTipText(ipd.getToolTip());
        final WItemProperty expr = new WItemProperty(cmp, 0, ipd, this.descriptor.getPropertyEditor());
        expr.setLabelProvider(new DescriptorPropertyLabelProvider(this.descriptor));
        GridData gd = new GridData(768);
        expr.setLayoutData(gd);
        expr.addModifyListener(new ItemPropertyModifiedListener(){

            @Override
            public void itemModified(ItemPropertyModifiedEvent event) {
                if (expr.isRefresh()) {
                    FormItemDialog.this.validateForm();
                    return;
                }
                if (FormItemDialog.this.refresh) {
                    return;
                }
                FormItemDialog.this.item.getProperties().clear();
                for (String key : FormItemDialog.this.map.keySet()) {
                    IWItemProperty wProp = FormItemDialog.this.map.get(key);
                    StandardItemProperty prop = new StandardItemProperty(wProp.getPropertyName(), wProp.getStaticValue(), wProp.getExpressionValue());
                    FormItemDialog.this.item.addItemProperty((ItemProperty)prop);
                }
                FormItemDialog.this.validateForm();
            }
        });
        this.map.put(key, expr);
    }

    @Override
    protected void setupExpressionContext() {
        super.setupExpressionContext();
        for (WItemProperty w : this.map.values()) {
            w.setExpressionContext(this.currentExpContext);
        }
    }

    protected Composite createScrolledComposite(CTabFolder tabFolder, CTabItem bptab) {
        Composite cmp = this.createScrolledComposite((Composite)tabFolder);
        bptab.setControl((Control)this.sc);
        return cmp;
    }

    protected Composite createScrolledComposite(Composite parent) {
        if (parent.getLayout() != null && parent.getLayout() instanceof GridLayout) {
            GridLayout l = (GridLayout)parent.getLayout();
            l.marginHeight = 0;
            l.marginWidth = 0;
            l.marginTop = 0;
        }
        this.sc = new ScrolledComposite(parent, 512);
        this.sc.setLayoutData((Object)new GridData(1808));
        Composite cmp = new Composite((Composite)this.sc, 0);
        cmp.setLayout((Layout)new GridLayout(2, false));
        this.sc.setContent((Control)cmp);
        this.sc.setExpandHorizontal(true);
        this.sc.setExpandVertical(true);
        this.sc.setAlwaysShowScrollBars(true);
        return cmp;
    }

    protected void configScrolledComposite(final Composite cmp) {
        this.sc.setMinSize(cmp.computeSize(-1, -1));
        this.sc.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                FormItemDialog.this.sc.setMinSize(cmp.computeSize(-1, -1));
            }
        });
    }

    protected Composite createSection(Composite parent, String text) {
        return this.createSection(parent, text, true);
    }

    protected Composite createSection(Composite parent, String text, boolean expanded) {
        Section ec = new Section(parent, 4);
        ec.setText(Misc.nvl((String)text));
        ec.setExpanded(expanded);
        ec.setFont(ResourceManager.getBoldFont((Font)ec.getFont()));
        Label lbl = new Label((Composite)ec, 258);
        ec.setSeparatorControl((Control)lbl);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        ec.setLayoutData((Object)gd);
        ec.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                FormItemDialog.this.sc.setMinSize(FormItemDialog.this.sc.getContent().computeSize(-1, -1));
            }
        });
        Composite c = new Composite((Composite)ec, 64);
        c.setLayout((Layout)new GridLayout(2, false));
        ec.setClient((Control)c);
        return c;
    }

    protected Composite createGroup(Composite parent, String text) {
        Composite ec = new Composite(parent, 4);
        ec.setLayout((Layout)new GridLayout());
        if (!Misc.isNullOrEmpty((String)text)) {
            Label lbl = new Label(ec, 0);
            lbl.setText(text);
            lbl.setFont(ResourceManager.getBoldFont((Font)lbl.getFont()));
        }
        new Label(ec, 258).setLayoutData((Object)new GridData(768));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        ec.setLayoutData((Object)gd);
        Composite c = new Composite(ec, 64);
        c.setLayout((Layout)new GridLayout(2, false));
        c.setLayoutData((Object)new GridData(1808));
        return c;
    }

    public static void createSeparator(Composite cmp) {
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        new Label(cmp, 258).setLayoutData((Object)gd);
    }

    public Label createCenteredLabel(final Composite cmp) {
        Label lbl = new Label(cmp, 64);
        final GridData gd = new GridData(64);
        gd.horizontalSpan = 2;
        gd.widthHint = 300;
        lbl.setLayoutData((Object)gd);
        if (this.sc != null) {
            this.sc.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    gd.widthHint = Math.max(200, FormItemDialog.this.sc.getSize().x - 20);
                }
            });
        } else {
            cmp.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    gd.widthHint = Math.max(200, cmp.getSize().x - 10);
                    if (FormItemDialog.this.sc != null) {
                        gd.widthHint = Math.min(gd.widthHint, FormItemDialog.this.sc.getSize().x);
                    }
                }
            });
        }
        return lbl;
    }
}

