/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.itemproperty.dialog;

import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.property.itemproperty.desc.ADescriptor;
import com.jaspersoft.studio.property.itemproperty.dialog.AItemDialog;
import com.jaspersoft.studio.property.itemproperty.dialog.ElementDatasetDialog;
import com.jaspersoft.studio.property.itemproperty.label.ItemLabelProvider;
import com.jaspersoft.studio.swt.widgets.table.DeleteButton;
import com.jaspersoft.studio.swt.widgets.table.EditButton;
import com.jaspersoft.studio.swt.widgets.table.IEditElement;
import com.jaspersoft.studio.swt.widgets.table.INewElement;
import com.jaspersoft.studio.swt.widgets.table.ListOrderButtons;
import com.jaspersoft.studio.swt.widgets.table.NewButton;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.widgets.framework.ui.ItemPropertyDescription;
import java.util.List;
import net.sf.jasperreports.components.items.Item;
import net.sf.jasperreports.components.items.ItemData;
import net.sf.jasperreports.components.items.ItemProperty;
import net.sf.jasperreports.components.items.StandardItem;
import net.sf.jasperreports.components.items.StandardItemData;
import net.sf.jasperreports.components.items.StandardItemProperty;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.util.JRCloneUtils;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class ItemDataDialog
extends ElementDatasetDialog {
    protected StandardItemData itemData;
    private Button bhasds;
    private boolean hasDS;
    private ADescriptor descriptor;
    protected List<ItemData> itemDatas;
    private ExpressionContext expContext;
    private APropertyNode pnode;
    protected IEditElement<Item> editElement;
    protected TableViewer itemsViewer;
    protected CTabItem dsTabItem;
    protected CTabItem itTabItem;

    public ItemDataDialog(Shell parentShell, String title, String message, List<ItemData> itemDatas, StandardItemData itemData, JasperReportsConfiguration jConfig, ADescriptor descriptor, ExpressionContext expconContext, APropertyNode pnode) {
        super(parentShell, title, message, itemData.getDataset(), jConfig);
        this.itemData = itemData;
        this.itemDatas = itemDatas;
        this.descriptor = descriptor;
        this.expContext = expconContext;
        this.pnode = pnode;
        this.hasDS = itemData.getDataset() != null;
    }

    @Override
    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.getItemName());
    }

    @Override
    protected void preElementDataset(Composite parent) {
        this.bhasds = new Button(parent, 32);
        this.bhasds.setText(Messages.ItemDataDialog_0);
        this.bhasds.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ItemDataDialog.this.hasDS = ItemDataDialog.this.bhasds.getSelection();
                if (ItemDataDialog.this.hasDS) {
                    ItemDataDialog.this.itemData.setDataset(ItemDataDialog.this.getDataset());
                } else {
                    ItemDataDialog.this.itemData.setDataset(null);
                }
                UIUtils.setEnabled((Control)ItemDataDialog.this.compositeDatasetInfo, (boolean)ItemDataDialog.this.hasDS);
            }
        });
        this.bhasds.setSelection(this.itemData.getDataset() != null);
    }

    @Override
    protected void createElementDatasetArea(Composite area) {
        Composite c = new Composite(area, 0);
        c.setLayout((Layout)new GridLayout());
        c.setLayoutData((Object)new GridData(1808));
        CTabFolder tabFolder = new CTabFolder(c, 0x800080);
        tabFolder.setLayoutData((Object)new GridData(1808));
        this.createItems(tabFolder);
        this.dsTabItem = new CTabItem(tabFolder, 0);
        this.dsTabItem.setText(Messages.common_dataset);
        Composite cmp = new Composite((Composite)tabFolder, 0);
        cmp.setLayout((Layout)new GridLayout());
        super.createElementDatasetArea(cmp);
        UIUtils.setEnabled((Control)this.compositeDatasetInfo, (boolean)this.hasDS);
        this.dsTabItem.setControl((Control)cmp);
    }

    protected void createItems(CTabFolder tabFolder) {
        this.itTabItem = new CTabItem(tabFolder, 0);
        this.itTabItem.setText(this.getItemName());
        Composite containerCmp = new Composite((Composite)tabFolder, 0);
        containerCmp.setLayout((Layout)new GridLayout(2, false));
        this.itemsViewer = new TableViewer(containerCmp, 68354);
        this.itemsViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.itemsViewer.setLabelProvider((IBaseLabelProvider)new ItemLabelProvider(this.descriptor){

            @Override
            public String getColumnText(Object element, int columnIndex) {
                return this.getText(element);
            }
        });
        GridData gd = new GridData(1808);
        gd.widthHint = 600;
        this.itemsViewer.getTable().setLayoutData((Object)gd);
        Composite c = new Composite(containerCmp, 0);
        c.setLayout((Layout)new GridLayout());
        c.setLayoutData((Object)new GridData(2));
        new NewButton().createNewButtons(c, this.itemsViewer, new INewElement(){

            @Override
            public Object newElement(List<?> input, int pos) {
                int indx = ItemDataDialog.this.itemDatas.indexOf(ItemDataDialog.this.itemData);
                List clones = JRCloneUtils.cloneList(ItemDataDialog.this.itemDatas);
                StandardItemData idClone = (StandardItemData)clones.get(indx);
                StandardItem item = new StandardItem();
                ItemPropertyDescription<?>[] itemPropertyDescriptionArray = ItemDataDialog.this.descriptor.getItemPropertyDescriptors();
                int n = itemPropertyDescriptionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ItemPropertyDescription<?> ipd = itemPropertyDescriptionArray[n2];
                    if (ipd.isMandatory()) {
                        Object obj;
                        StandardItemProperty p = new StandardItemProperty(ipd.getName(), ipd.getDefaultValueString(), null);
                        item.addItemProperty((ItemProperty)p);
                        StructuredSelection s = (StructuredSelection)ItemDataDialog.this.itemsViewer.getSelection();
                        if (s != null && (obj = s.getFirstElement()) != null && obj instanceof Item) {
                            ItemDataDialog.this.descriptor.setupDefaultValue((Item)obj, p);
                        }
                    }
                    ++n2;
                }
                idClone.addItem((Item)item);
                ItemDataDialog.this.descriptor.setItemDatas(clones, ItemDataDialog.this.pnode);
                ItemDataDialog.this.descriptor.setItemData((ItemData)idClone);
                ItemDataDialog.this.descriptor.setItem((Item)item);
                AItemDialog dialog = ItemDataDialog.this.createItemDialog();
                dialog.setValues(clones, idClone, item);
                dialog.setExpressionContext(ItemDataDialog.this.expContext);
                try {
                    if (dialog.open() == 0) {
                        ItemDataDialog.this.itemDatas.clear();
                        ItemDataDialog.this.itemDatas.addAll(clones);
                        ItemDataDialog.this.itemData = dialog.getItemData();
                    } else {
                        item = null;
                    }
                }
                finally {
                    ItemDataDialog.this.descriptor.setItem((Item)item);
                    ItemDataDialog.this.descriptor.setItemData((ItemData)ItemDataDialog.this.itemData);
                    ItemDataDialog.this.descriptor.setItemDatas(ItemDataDialog.this.itemDatas, ItemDataDialog.this.pnode);
                }
                return item;
            }
        });
        EditButton<Item> eb = new EditButton<Item>();
        this.editElement = new IEditElement<Item>(){

            @Override
            public void editElement(List<Item> input, int pos) {
                int indx = ItemDataDialog.this.itemDatas.indexOf(ItemDataDialog.this.itemData);
                List clones = JRCloneUtils.cloneList(ItemDataDialog.this.itemDatas);
                StandardItemData idClone = (StandardItemData)clones.get(indx);
                StandardItem itemClone = (StandardItem)idClone.getItems().get(pos);
                ItemDataDialog.this.descriptor.setItemDatas(clones, ItemDataDialog.this.pnode);
                ItemDataDialog.this.descriptor.setItemData((ItemData)idClone);
                ItemDataDialog.this.descriptor.setItem((Item)itemClone);
                try {
                    AItemDialog dialog = ItemDataDialog.this.createItemDialog();
                    dialog.setValues(clones, idClone, itemClone);
                    dialog.setExpressionContext(ItemDataDialog.this.expContext);
                    if (dialog.open() == 0) {
                        input.set(pos, (Item)itemClone);
                        ItemDataDialog.this.itemDatas.clear();
                        ItemDataDialog.this.itemDatas.addAll(clones);
                        ItemDataDialog.this.itemData = dialog.getItemData();
                    }
                }
                finally {
                    ItemDataDialog.this.descriptor.setItem((Item)ItemDataDialog.this.itemData.getItems().get(pos));
                    ItemDataDialog.this.descriptor.setItemData((ItemData)ItemDataDialog.this.itemData);
                    ItemDataDialog.this.descriptor.setItemDatas(ItemDataDialog.this.itemDatas, ItemDataDialog.this.pnode);
                }
            }
        };
        eb.createEditButtons(c, this.itemsViewer, this.editElement);
        eb.editOnDoubleClick();
        new DeleteButton().createDeleteButton(c, this.itemsViewer, true);
        new ListOrderButtons().createOrderButtons(c, this.itemsViewer);
        this.createAdditionalPanel(containerCmp);
        this.itTabItem.setControl((Control)containerCmp);
        this.itemsViewer.setInput((Object)this.itemData.getItems());
    }

    protected void createAdditionalPanel(Composite parent) {
    }

    protected String getItemName() {
        return "Items";
    }

    protected abstract AItemDialog createItemDialog();

    @Override
    public JRElementDataset getDataset() {
        return this.hasDS ? super.getDataset() : null;
    }
}

