/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.itemproperty.dialog;

import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.editor.expression.IExpressionContextSetter;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.property.itemproperty.desc.ADescriptor;
import com.jaspersoft.studio.property.itemproperty.desc.AItemDataListPropertyDescriptor;
import com.jaspersoft.studio.property.itemproperty.dialog.AItemDialog;
import com.jaspersoft.studio.property.itemproperty.dialog.ItemDataDialog;
import com.jaspersoft.studio.property.itemproperty.dialog.TableItemDialog;
import com.jaspersoft.studio.property.itemproperty.label.ItemLabelProvider;
import com.jaspersoft.studio.swt.widgets.table.DeleteButton;
import com.jaspersoft.studio.swt.widgets.table.EditButton;
import com.jaspersoft.studio.swt.widgets.table.IEditElement;
import com.jaspersoft.studio.swt.widgets.table.INewElement;
import com.jaspersoft.studio.swt.widgets.table.ListContentProvider;
import com.jaspersoft.studio.swt.widgets.table.NewButton;
import com.jaspersoft.studio.utils.UIUtil;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.List;
import net.sf.jasperreports.components.items.ItemData;
import net.sf.jasperreports.components.items.StandardItemData;
import net.sf.jasperreports.eclipse.ui.ATitledDialog;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.util.JRCloneUtils;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class ItemDataListDialog
extends ATitledDialog
implements IExpressionContextSetter {
    private ExpressionContext expContext;
    private List<ItemData> value;
    private TableViewer tviewer;
    private ADescriptor descriptor;
    private EditButton<StandardItemData> bpropEdit;
    private JasperReportsConfiguration jContext;
    private APropertyNode pnode;

    public ItemDataListDialog(Shell parentShell, ADescriptor descriptor, List<ItemData> value, AItemDataListPropertyDescriptor pd, APropertyNode pnode) {
        super(parentShell);
        this.value = value;
        this.descriptor = descriptor;
        this.jContext = pnode.getJasperConfiguration();
        this.pnode = pnode;
        this.setTitle(pd.getDisplayName());
        this.setDefaultSize(600, 600);
    }

    @Override
    public void setExpressionContext(ExpressionContext expContext) {
        this.expContext = expContext;
    }

    protected Control createDialogArea(Composite parent) {
        Composite cmp = new Composite((Composite)super.createDialogArea(parent), 0);
        cmp.setLayout((Layout)new GridLayout(2, false));
        cmp.setLayoutData((Object)new GridData(1808));
        Table wtable = new Table(cmp, 68098);
        wtable.setLayoutData((Object)new GridData(1808));
        this.tviewer = new TableViewer(wtable);
        this.tviewer.setLabelProvider((IBaseLabelProvider)new ItemLabelProvider(this.descriptor){

            @Override
            public Image getImage(Object element) {
                return null;
            }

            @Override
            protected String getColumnText4ItemData(ItemData element, int columnIndex) {
                return this.getText4ItemData(element);
            }

            @Override
            public String getText4ItemData(ItemData element) {
                return String.valueOf(Messages.ItemLabelProvider_7) + " " + (ItemDataListDialog.this.value.indexOf(element) + 1);
            }
        });
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, false));
        wtable.setLayout((Layout)tlayout);
        this.tviewer.setContentProvider((IContentProvider)new ListContentProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tviewer, (int)2);
        UIUtil.setViewerCellEditingOnDblClick(this.tviewer);
        Composite bGroup = new Composite(cmp, 0);
        bGroup.setLayout((Layout)new GridLayout(1, false));
        bGroup.setLayoutData((Object)new GridData(1040));
        new NewButton().createNewButtons(bGroup, this.tviewer, new INewElement(){

            @Override
            public Object newElement(List<?> input, int pos) {
                List clones = JRCloneUtils.cloneList(ItemDataListDialog.this.value);
                StandardItemData itemData = new StandardItemData();
                clones.add(itemData);
                if (ItemDataListDialog.this.createItemDataDialog(clones, itemData).open() == 0) {
                    return itemData;
                }
                return null;
            }
        });
        this.bpropEdit = new EditButton();
        this.bpropEdit.createEditButtons(bGroup, this.tviewer, new IEditElement<StandardItemData>(){

            @Override
            public void editElement(List<StandardItemData> input, int pos) {
                StandardItemData itemDataClone;
                List clones = JRCloneUtils.cloneList(ItemDataListDialog.this.value);
                if (ItemDataListDialog.this.createItemDataDialog(clones, itemDataClone = (StandardItemData)ItemDataListDialog.this.getStandardItemData(clones)).open() == 0) {
                    input.set(pos, itemDataClone);
                }
            }
        });
        this.bpropEdit.editOnDoubleClick();
        new DeleteButton().createDeleteButton(bGroup, this.tviewer);
        this.tviewer.setInput(this.value);
        return cmp;
    }

    private ItemData getStandardItemData(List<ItemData> clones) {
        IStructuredSelection sel = (IStructuredSelection)this.tviewer.getSelection();
        Object fe = sel.getFirstElement();
        if (fe != null) {
            if (fe instanceof StandardItemData) {
                return clones.get(this.value.indexOf((StandardItemData)fe));
            }
        } else if (!Misc.isNullOrEmpty(this.value)) {
            return (StandardItemData)clones.get(0);
        }
        return null;
    }

    protected ItemDataDialog createItemDataDialog(List<ItemData> clones, StandardItemData itemData) {
        ItemDataDialog dialog = new ItemDataDialog(UIUtils.getShell(), Messages.SPItemDataList_6, Messages.SPItemDataList_7, clones, itemData, this.jContext, this.descriptor, this.expContext, this.pnode){

            @Override
            protected AItemDialog createItemDialog() {
                return ItemDataListDialog.this.createItemDialog();
            }
        };
        return dialog;
    }

    protected AItemDialog createItemDialog() {
        return new TableItemDialog(UIUtils.getShell(), this.descriptor, this.jContext, false);
    }

    public List<ItemData> getValue() {
        return this.value;
    }
}

